/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AssertionCreationState;
import com.pingidentity.fsm.state.impl.ConfigAssertionLifetimeState;
import com.pingidentity.fsm.state.impl.SelectSamlProfilesState;
import com.pingidentity.fsm.state.impl.SpProtocolSettingsState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SpBrowserSsoTasklet
extends MultiProtocolTasklet
implements NeededCredentialsApi,
WebSsoApi,
SamlProfilesApi,
AttributeNamesApi {
    final ConfigAssertionLifetimeState configAssertionLifetimeState;
    final SelectSamlProfilesState selectSamlProfilesState;
    final AssertionCreationState assertionCreationState;
    final SpProtocolSettingsState spProtocolSettingsState;
    final SummaryCardState summaryCardState;
    private static final long serialVersionUID = 1L;

    public SpBrowserSsoTasklet(Visit visit) {
        super("SpBrowserSsoTasklet", "Browser SSO");
        this.setSystemVisit(visit);
        this.selectSamlProfilesState = new SelectSamlProfilesState(this);
        this.configAssertionLifetimeState = new ConfigAssertionLifetimeState(this);
        this.assertionCreationState = new AssertionCreationState(this);
        this.spProtocolSettingsState = new SpProtocolSettingsState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setInitialState(this.selectSamlProfilesState);
        this.setCancelAvailable(true);
    }

    @Override
    public void configureTasklet() {
        if (this.isConnectionProtocol1x() || this.isWsFedProtocol()) {
            this.setInitialState(this.configAssertionLifetimeState);
        } else {
            this.setInitialState(this.selectSamlProfilesState);
        }
        this.clearAllStatesOutgoingTransitions();
        this.selectSamlProfilesState.addOutgoingTransition(this, this.configAssertionLifetimeState);
        this.configAssertionLifetimeState.addOutgoingTransition(this, this.assertionCreationState);
        this.assertionCreationState.addOutgoingTransition(this, this.spProtocolSettingsState);
        this.spProtocolSettingsState.addOutgoingTransition(this, this.summaryCardState);
        boolean isWsFedJwt = this.isWsFedJwt();
        this.configAssertionLifetimeState.updateKeyContext(isWsFedJwt);
        this.assertionCreationState.updateKeyContext(isWsFedJwt);
    }

    @Override
    public Protocol getProtocolType() {
        return this.findParent(ConnectionTasklet.class).getProtocolType();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void finish() {
        SpConnection connection = new SpConnection();
        this.save(connection);
        this.setPopulateData(connection);
        super.finish();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.isAnySsoSelected() && this.spProtocolSettingsState.isBackChannelAuthenticationNeeded();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.isAnySsoSelected() && this.spProtocolSettingsState.isDigitalSignatureVerificationNeeded();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.isAnySsoSelected() && this.spProtocolSettingsState.isDigitalSignatureNeeded();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return (this.isAnySsoSelected() || WsTrustTokenType.SAML20 == this.getWsFedTokenType()) && this.spProtocolSettingsState.isEncryptionCertificateNeeded();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return this.isAnySsoSelected() && this.spProtocolSettingsState.isDecryptionKeyNeeded();
    }

    @Override
    public boolean isInboundArtifact() {
        return this.spProtocolSettingsState.isInboundArtifact();
    }

    @Override
    public boolean isArtifactSsoSlo() {
        return this.spProtocolSettingsState.isArtifactSsoSlo();
    }

    @Override
    public boolean isSoapSlo() {
        return this.spProtocolSettingsState.isSoapSlo();
    }

    @Override
    public boolean isInboundSoap() {
        return this.spProtocolSettingsState.isInboundSoap();
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        return this.spProtocolSettingsState.isAnyOutboundSoapNotUsingHttps();
    }

    @Override
    public boolean isAnySloSelected() {
        return this.selectSamlProfilesState.isAnySloSelected();
    }

    @Override
    public boolean isAnySpSelected() {
        return this.selectSamlProfilesState.isAnySpSelected();
    }

    @Override
    public boolean isAnySsoSelected() {
        return this.selectSamlProfilesState.isAnySsoSelected();
    }

    @Override
    public boolean isAttributeQuerySelected() {
        return false;
    }

    @Override
    public boolean isIdpSLOSelected() {
        return this.selectSamlProfilesState.isIdpSLOSelected();
    }

    @Override
    public boolean isIdpSSOSelected() {
        return this.selectSamlProfilesState.isIdpSSOSelected();
    }

    @Override
    public boolean isOnlySpSSOSelected() {
        return this.selectSamlProfilesState.isOnlySpSSOSelected();
    }

    @Override
    public boolean isSomethingOtherThanIdpInitiatedSsoSelected() {
        return this.selectSamlProfilesState.isSomethingOtherThanIdpInitiatedSsoSelected();
    }

    @Override
    public boolean isSomethingOtherThanSpInitiatedSsoSelected() {
        return this.selectSamlProfilesState.isSomethingOtherThanSpInitiatedSsoSelected();
    }

    @Override
    public boolean isSpSLOSelected() {
        return this.selectSamlProfilesState.isSpSLOSelected();
    }

    @Override
    public boolean isSpSSOSelected() {
        return this.selectSamlProfilesState.isSpSSOSelected();
    }

    @Override
    public boolean onlyIdpSsoSelected() {
        return this.selectSamlProfilesState.onlyIdpSsoSelected();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.assertionCreationState.getAllAttrNamesSorted();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.assertionCreationState.getAllAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.assertionCreationState.getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.assertionCreationState.getSortedMutableAttributeNames();
    }

    public boolean isWsFedJwt() {
        SpConnectionConfigTasklet spConnTasklet = this.findParent(SpConnectionConfigTasklet.class);
        if (spConnTasklet != null) {
            return spConnTasklet.isWsFedJwt() && this.isWsFedProtocol();
        }
        return false;
    }

    public WsTrustTokenType getWsFedTokenType() {
        SpConnectionConfigTasklet spConnTasklet = this.findParent(SpConnectionConfigTasklet.class);
        if (spConnTasklet != null) {
            return spConnTasklet.getWsFedTokenType();
        }
        return null;
    }
}

