/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OverrideInstanceState;
import com.pingidentity.fsm.state.impl.SelectAdapterState;
import com.pingidentity.fsm.state.impl.SelectAddlAssertionAttrsState;
import com.pingidentity.fsm.state.impl.SelectAssertionMappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAuthnSourceMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;

public class SpConfigAdapterMappingTasklet
extends SpAuthnSourceMappingTasklet
implements PluginMappingApi {
    private static final long serialVersionUID = 20050515L;
    private final SelectAdapterState selectAdapterState = new SelectAdapterState(this);
    private final OverrideInstanceState overrideInstanceState;

    public SpConfigAdapterMappingTasklet(Visit visit) {
        super("SpConfigAdapterMappingTasklet", "IdP Adapter Mapping", visit);
        this.selectAdapterState.setAdapterType(SelectAdapterState.ADAPTER_TYPE.IDP_AUTHN);
        this.overrideInstanceState = new OverrideInstanceState(this);
        this.setInitialState(this.selectAdapterState);
        this.reconfigureTransitions();
    }

    @Override
    protected void reconfigureInitialTransitions() {
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.overrideInstanceState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConfigAdapterMappingTasklet.this.isOverridePluginConnectionSettings();
            }
        });
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = SpConfigAdapterMappingTasklet.this.getParentTasklet().findParent(SpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectAssertionMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !SpConfigAdapterMappingTasklet.this.isOverridePluginConnectionSettings();
            }
        });
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.getSummaryState()){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !SpConfigAdapterMappingTasklet.this.isAttrMappingNeeded();
            }
        });
        this.overrideInstanceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = SpConfigAdapterMappingTasklet.this.getParentTasklet().findParent(SpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.overrideInstanceState.addOutgoingTransition(this, this.selectAssertionMappingState);
    }

    @Override
    public void refreshAttributeOverrides() {
        this.selectAdapterState.createAdapterAttributeList();
    }

    @SuppressFBWarnings(value={"HE_EQUALS_USE_HASHCODE"})
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SpConfigAdapterMappingTasklet) {
            return this.getDescription().equals(((SpConfigAdapterMappingTasklet)o).getDescription());
        }
        return false;
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getDescription().toLowerCase().compareTo(((SpConfigAdapterMappingTasklet)o).getDescription().toLowerCase());
    }

    public AuthnAdapterInstance getSelectedAdapter() {
        return this.selectAdapterState.getSelectedAdapter();
    }

    public String getDescription() {
        if (this.isOverridePluginPopulated()) {
            return ((PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit()).getName();
        }
        return this.getSelectedAdapter() != null ? this.getSelectedAdapter().getName() : "";
    }

    @Override
    public List<String> getPluginContract() {
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit();
        if (this.isOverridePluginPopulated() && pluginInstanceTasklet.createAdapterContractState.getContract() != null) {
            return pluginInstanceTasklet.getAllContractAttrNamesSorted();
        }
        return this.selectAdapterState.getAttributeList();
    }

    public void setNewAdapter(boolean newAdapter) {
        this.selectAdapterState.setNewAdapter(newAdapter);
    }

    @Override
    public boolean isNewAdapter() {
        return this.selectAdapterState.isNewAdapter();
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.getSelectedAdapter();
    }

    @Override
    public String getMappingSourceForDisplay() {
        return "Adapter";
    }

    @Override
    public boolean isOverridePluginPopulated() {
        return this.isOverridePluginConnectionSettings() && this.overrideInstanceState.getTaskletToEdit() != null && this.overrideInstanceState.getTaskletToEdit().getPopulateData() != null;
    }

    @Override
    public boolean isOverridePluginConnectionSettings() {
        return this.selectAdapterState.isOverrideAdapterConnectionSettings();
    }

    @Override
    public void removeConnectionOverride() {
        this.overrideInstanceState.setTaskletToEditToNull();
    }

    @Override
    public void cancel() {
        AdapterToAssertionMapping mapping;
        if (this.getPopulateData() != null && (mapping = (AdapterToAssertionMapping)this.getPopulateData()).isSavedConnectionOverride()) {
            mapping.resetAdapterInstanceId();
        }
        super.cancel();
    }

    @Override
    public AuthnSourceToAssertionMapping newDomainMapping() {
        return new AdapterToAssertionMapping();
    }

    @Override
    public SelectAddlAssertionAttrsState newAdditionalAttrsState() {
        return new SelectAssertionMappingState(this);
    }

    @Override
    public void addAuthnSourceToPropertySelectionSource(DataMap.Sources sources) {
        ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
        if (sourceInstance != null) {
            List srcNames = null;
            srcNames = this.isOverridePluginPopulated() ? this.getPluginContract() : sourceInstance.getAttributeContract().getAllAttrNamesSorted();
            sources.addPropertySelectionSource("Adapter", new StringPairPropertySelectionModel(true, srcNames));
        }
        this.addExtendedPropertiesToSelectionSources(sources);
    }

    @Override
    public List<SourceContextType> getContextTypes() {
        return SourceContextType.getContextTypesForSpBrowserSSOWithAdapters();
    }
}

