/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SelectAddlAssertionAttrsState;
import com.pingidentity.fsm.state.impl.SelectC2cAssertionAttrsState;
import com.pingidentity.fsm.state.impl.SelectC2cContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.SpAuthnSourceMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SpConfigC2cMappingTasklet
extends SpAuthnSourceMappingTasklet {
    private static final long serialVersionUID = 1L;
    private final SelectC2cContractState selectC2cContractState = new SelectC2cContractState(this);

    public SpConfigC2cMappingTasklet(Visit visit) {
        super("SpConfigC2cMappingTasklet", "Authentication Policy Mapping", visit);
        this.setInitialState(this.selectC2cContractState);
        this.reconfigureTransitions();
    }

    @SuppressFBWarnings(value={"HE_EQUALS_USE_HASHCODE"})
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SpConfigC2cMappingTasklet) {
            return this.getDescription().equals(((SpConfigC2cMappingTasklet)o).getDescription());
        }
        return false;
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getDescription().toLowerCase().compareTo(((SpConfigC2cMappingTasklet)o).getDescription().toLowerCase());
    }

    public String getDescription() {
        String contractName = this.selectC2cContractState.getSelectedContractName();
        return contractName != null ? contractName : "";
    }

    public void setNewContract(boolean newContract) {
        this.selectC2cContractState.setNewContract(newContract);
    }

    public boolean isNewContract() {
        return this.selectC2cContractState.isNewContract();
    }

    private List<String> getSortedContractAttrs() {
        C2cContract contract = MgmtFactory.getC2cContractManager().getContract(this.selectC2cContractState.getSelectedContractId());
        if (contract != null) {
            return contract.getAllAttrNamesSorted();
        }
        return new ArrayList<String>();
    }

    @Override
    public AuthnSourceToAssertionMapping newDomainMapping() {
        return new C2cContractToAssertionMapping();
    }

    @Override
    public SelectAddlAssertionAttrsState newAdditionalAttrsState() {
        return new SelectC2cAssertionAttrsState(this);
    }

    public String getContractId() {
        return this.selectC2cContractState.getSelectedContractId();
    }

    public String getContractName() {
        return this.selectC2cContractState.getSelectedContractName();
    }

    @Override
    public void addAuthnSourceToPropertySelectionSource(DataMap.Sources sources) {
        sources.addPropertySelectionSource("Authentication Policy Contract", new StringPairPropertySelectionModel(true, this.getSortedContractAttrs()));
        this.addExtendedPropertiesToSelectionSources(sources);
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        C2cContract contract = MgmtFactory.getC2cContractManager().getContract(this.getContractId());
        if (contract != null) {
            return contract.getAllAttributeNames();
        }
        return Collections.emptyList();
    }

    @Override
    public String getMappingSourceForDisplay() {
        return "Authentication Policy Contract";
    }

    public void refreshName() {
        this.selectC2cContractState.refreshName();
    }

    @Override
    public List<SourceContextType> getContextTypes() {
        return SourceContextType.getContextTypesForSpBrowserSSOWithC2cContracts();
    }
}

