/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AttrReqSecurityPolicyState;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.RetrievableAttributesState;
import com.pingidentity.fsm.state.impl.SpXaspAttributeSourceMappingState;
import com.pingidentity.fsm.state.impl.SpXaspConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.issuancecriteria.impl.SpXaspIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SpXaspTasklet
extends MappingTasklet
implements AttributeNamesApi,
NeededCredentialsApi {
    private static final long serialVersionUID = 20050515L;
    final RetrievableAttributesState retrievableAttributesState;
    final SpXaspAttributeSourceMappingState spAttributeSourceMappingState;
    final SpXaspIssuanceCriteriaState spXaspIssuanceCriteriaState;
    final AttrReqSecurityPolicyState attrReqSecurityPolicyState;
    final SummaryCardState summaryCardState;

    public SpXaspTasklet(Visit visit) {
        super("SpXaspTasklet", "Attribute Query");
        this.setSystemVisit(visit);
        this.retrievableAttributesState = new RetrievableAttributesState(this);
        this.attrReqSecurityPolicyState = new AttrReqSecurityPolicyState(this);
        if (!MgmtFactory.getJCEManager().allowXmlEncryption()) {
            this.attrReqSecurityPolicyState.setDisableXmlEncryption(true);
            this.attrReqSecurityPolicyState.setNoteKey("SpXaspTasklet_AttrReqSecurityPolicyState_Luna");
        }
        this.spAttributeSourceMappingState = new SpXaspAttributeSourceMappingState(this, "mapping");
        this.spXaspIssuanceCriteriaState = new SpXaspIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.createTransitions();
        this.setInitialState(this.retrievableAttributesState);
        this.setCancelAvailable(true);
    }

    private void createTransitions() {
        this.retrievableAttributesState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.spAttributeSourceMappingState);
        this.spAttributeSourceMappingState.addOutgoingTransition(this, this.spXaspIssuanceCriteriaState);
        this.spXaspIssuanceCriteriaState.addOutgoingTransition(this, this.attrReqSecurityPolicyState);
        this.attrReqSecurityPolicyState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public void finish() {
        AttributeRequester attributeRequester = new AttributeRequester();
        attributeRequester.setAttributeMapping(new AttributeMapping());
        this.save(attributeRequester);
        this.setPopulateData(attributeRequester);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void cancel(TaskletState state) {
        this.populate(state, this.getPopulateData());
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.retrievableAttributesState.getRetrievableAttributes().getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.retrievableAttributesState.getRetrievableAttributes().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.retrievableAttributesState.getRetrievableAttributes().getSortedMutableAttributeNames();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.retrievableAttributesState.getRetrievableAttributes().getAllAttributeNames();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return true;
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.attrReqSecurityPolicyState.isRequireSignedAttributeQuery();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.attrReqSecurityPolicyState.isSignResponse() || this.attrReqSecurityPolicyState.isSignAssertion();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return this.attrReqSecurityPolicyState.isEncryptAssertion();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return this.attrReqSecurityPolicyState.isRequireEncryptedNameId();
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new SpXaspConfigAttributeSourcesState(this, "configAttributeSources");
    }

    @Override
    public String getContractTypeForDisplay() {
        return "Retrievable Attributes";
    }

    @Override
    public String getNoteKeySuffix() {
        return "SpXasp";
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.spAttributeSourceMappingState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.spXaspIssuanceCriteriaState.getIssuanceCriteriaList();
    }
}

