/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigUserProvisioningLdapDirSearchState;
import com.pingidentity.fsm.state.impl.ErrorHandlingState;
import com.pingidentity.fsm.state.impl.EventTriggerState;
import com.pingidentity.fsm.state.impl.SelectDatabaseSchemaAndStoredProcState;
import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.UserAttributesState;
import com.pingidentity.fsm.state.impl.UserProvisioningAdapterContractMappingState;
import com.pingidentity.fsm.state.impl.UserProvisioningAttributesState;
import com.pingidentity.fsm.state.impl.UserProvisioningConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.UserProvisioningJdbcUniqueIdState;
import com.pingidentity.fsm.state.impl.UserProvisioningSqlMethodState;
import com.pingidentity.fsm.state.impl.UserRepositoryState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.MappingNameItem;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.websso.Protocol;

public class UserProvisioningTasklet
extends MultiProtocolTasklet
implements AttributeSourceApi {
    private static final long serialVersionUID = 20050515L;
    private static final String NOT_CONFIGURED = "Not Configured";
    private static final String NONE = "None";
    private static final String ENABLED = "Enabled";
    final UserAttributesState userAttributesState;
    final UserProvisioningSqlMethodState userProvisioningSqlMethodState;
    final UserRepositoryState userRepositoryState;
    final EventTriggerState eventTriggerState;
    final SelectDatabaseTableAndColumnsState selectDatabaseTableAndColumnsState;
    final SelectDatabaseSchemaAndStoredProcState selectStoredProceduresState;
    final UserProvisioningJdbcUniqueIdState userProvisioningJdbcUniqueIdState;
    final ConfigUserProvisioningLdapDirSearchState configLdapDirSearchState;
    final UserProvisioningAdapterContractMappingState jdbcAdapterContractMappingState;
    final UserProvisioningAdapterContractMappingState storedProcParamMappingState;
    final UserProvisioningAdapterContractMappingState ldapAdapterContractMappingState;
    final ErrorHandlingState ldapErrorHandlingState;
    final ErrorHandlingState jdbcErrorHandlingState;
    final UserProvisioningAttributesState userProvisioningAttributesState;
    final UserProvisioningConfigLdapFilterState userProvisioningConfigLdapFilterState;
    final SummaryCardState summaryCardState;
    private boolean isFinished = false;

    public UserProvisioningTasklet(Visit visit) {
        super("UserProvisioningTasklet");
        this.setSystemVisit(visit);
        this.userAttributesState = new UserAttributesState(this);
        this.userRepositoryState = new UserRepositoryState(this, "userRepository");
        this.userRepositoryState.setMenuName("User Repository");
        this.userProvisioningSqlMethodState = new UserProvisioningSqlMethodState(this);
        this.selectDatabaseTableAndColumnsState = new SelectDatabaseTableAndColumnsState(this, "expressProvisioningJdbcLocation", "Location");
        this.selectStoredProceduresState = new SelectDatabaseSchemaAndStoredProcState(this, "expressProvisioningStoredProcedureLocation", "Stored Procedure Location");
        this.userProvisioningJdbcUniqueIdState = new UserProvisioningJdbcUniqueIdState(this);
        this.jdbcAdapterContractMappingState = new UserProvisioningAdapterContractMappingState(this, "jdbcUserProvisioningAdapterContractMapping", "Target Parameter");
        this.storedProcParamMappingState = new UserProvisioningAdapterContractMappingState(this, "jdbcUserProvisioningAdapterContractMapping", "Target Parameter");
        this.eventTriggerState = new EventTriggerState(this);
        this.jdbcErrorHandlingState = new ErrorHandlingState(this);
        this.configLdapDirSearchState = new ConfigUserProvisioningLdapDirSearchState(this);
        this.userProvisioningConfigLdapFilterState = new UserProvisioningConfigLdapFilterState(this, "userProvisioningConfigLdapFilter");
        this.userProvisioningAttributesState = new UserProvisioningAttributesState(this);
        this.ldapAdapterContractMappingState = new UserProvisioningAdapterContractMappingState(this, "ldapUserProvisioningAdapterContractMapping");
        this.ldapErrorHandlingState = new ErrorHandlingState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setCancelAvailable(true);
    }

    @Override
    public void configureTasklet() {
        if (((IdpConnectionConfigTasklet)this.getParentTasklet()).isConnectionProtocol20()) {
            this.setInitialState(this.userAttributesState);
        } else {
            this.setInitialState(this.userRepositoryState);
        }
        this.setMenuName("JIT Provisioning");
        this.reconfigureTransitions(this.getInitialState());
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
        DataSource.DSType curType = this.userRepositoryState.getDataSourceType();
        switch (curType) {
            case JDBC: {
                this.createJdbcTransitions();
                break;
            }
            case LDAP: {
                this.createLdapTransitions();
                break;
            }
            default: {
                this.createDefaultTransitions();
            }
        }
    }

    protected void createJdbcTransitions() {
        this.userAttributesState.addOutgoingTransition(this, this.userRepositoryState);
        this.userRepositoryState.addOutgoingTransition(this, this.userProvisioningSqlMethodState);
        if (this.isTableSqlMethod()) {
            this.createTableSqlTransitions();
        } else {
            this.createStoredProcedureTransitions();
        }
    }

    protected void createTableSqlTransitions() {
        this.userProvisioningSqlMethodState.addOutgoingTransition(this, this.selectDatabaseTableAndColumnsState);
        this.selectDatabaseTableAndColumnsState.addOutgoingTransition(this, this.userProvisioningJdbcUniqueIdState);
        this.userProvisioningJdbcUniqueIdState.addOutgoingTransition(this, this.jdbcAdapterContractMappingState);
        this.jdbcAdapterContractMappingState.addOutgoingTransition(this, this.eventTriggerState);
        this.eventTriggerState.addOutgoingTransition(this, this.jdbcErrorHandlingState);
        this.jdbcErrorHandlingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createStoredProcedureTransitions() {
        this.userProvisioningSqlMethodState.addOutgoingTransition(this, this.selectStoredProceduresState);
        this.selectStoredProceduresState.addOutgoingTransition(this, this.storedProcParamMappingState);
        this.storedProcParamMappingState.addOutgoingTransition(this, this.jdbcErrorHandlingState);
        this.jdbcErrorHandlingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createLdapTransitions() {
        this.userAttributesState.addOutgoingTransition(this, this.userRepositoryState);
        this.userRepositoryState.addOutgoingTransition(this, this.configLdapDirSearchState);
        this.configLdapDirSearchState.addOutgoingTransition(this, this.userProvisioningConfigLdapFilterState);
        this.userProvisioningConfigLdapFilterState.addOutgoingTransition(this, this.userProvisioningAttributesState);
        this.userProvisioningAttributesState.addOutgoingTransition(this, this.ldapAdapterContractMappingState);
        this.ldapAdapterContractMappingState.addOutgoingTransition(this, this.eventTriggerState);
        this.eventTriggerState.addOutgoingTransition(this, this.ldapErrorHandlingState);
        this.ldapErrorHandlingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createDefaultTransitions() {
        this.userAttributesState.addOutgoingTransition(this, this.userRepositoryState);
        this.userRepositoryState.addOutgoingTransition(this, this.summaryCardState);
        this.userRepositoryState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public Protocol getProtocolType() {
        return ((ConnectionTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        AdministrativeUser user = this.getSystemVisit().getCurrentUser();
        return !user.isAuditor() && ((TaskletState)this.getCurrentState()).isSaveDraftAvailable();
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.userRepositoryState.getSelectedDataSource();
    }

    public boolean isAttrQueryEnabled() {
        return this.userAttributesState.isAttrQueryEnabled();
    }

    public String getUserAttributes() {
        if (this.userAttributesState == null || this.userAttributesState.getAttributeContractList() == null) {
            return NOT_CONFIGURED;
        }
        List<String> attrs = this.userAttributesState.getAttributeContractList();
        return !attrs.isEmpty() ? Util.listToCommaDelimString(attrs) : NONE;
    }

    public boolean isUsingStoredProcedure() {
        return this.userProvisioningSqlMethodState != null && !this.userProvisioningSqlMethodState.isTableSqlMethod() && this.selectStoredProceduresState != null && !StringUtils.isBlank((String)this.selectStoredProceduresState.getSelectedInsertStoredProcedure());
    }

    public String getStoredProcedureName() {
        if (this.isUsingStoredProcedure()) {
            return this.selectStoredProceduresState.getSelectedInsertStoredProcedure();
        }
        return NOT_CONFIGURED;
    }

    @Override
    public List<String> getContractToFulfill() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }

    @Override
    public List<String> getAllAttributes() {
        return this.userRepositoryState.getAllAttributes();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        idpConnection.setUserProvisioning(new UserProvisioning());
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    @Override
    public boolean isDataStoreAvailable(DataSource dataSource) {
        if (dataSource != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            return dsMgr.test(dataSource);
        }
        return false;
    }

    public boolean setStatesToVOMode(DataSource dataSource) {
        this.userRepositoryState.setViewOnly(true, this.getTaskletName() + "_UserRepositoryStateVo");
        if (dataSource instanceof JdbcDataSource) {
            this.userProvisioningSqlMethodState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningSqlMethodStateVo");
            this.selectDatabaseTableAndColumnsState.setViewOnly(true, this.getTaskletName() + "_ExpressProvisioningJdbcLocationStateVo");
            this.userProvisioningJdbcUniqueIdState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningJdbcUniqueIdStateVo");
            this.jdbcAdapterContractMappingState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningAdapterContractMappingStateVo");
            this.selectStoredProceduresState.setViewOnly(true, this.getTaskletName() + "_SelectDatabaseSchemaAndStoredProcStateVo");
            this.storedProcParamMappingState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningAdapterContractMappingStateVo");
            this.storedProcParamMappingState.setNoteKey("UserProvisioningTasklet_UserProvisioningStoredProcParamMappingStateVo");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(true, this.getTaskletName() + "_ConfigUserProvisioningLdapDirSearchStateVo");
            this.userProvisioningConfigLdapFilterState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningConfigLdapFilterStateVo");
            this.userProvisioningAttributesState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningAttributesStateVo");
            this.ldapAdapterContractMappingState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningAdapterContractMappingStateVo");
        }
        return false;
    }

    public boolean setStatesToEditMode(DataSource dataSource) {
        this.userRepositoryState.setViewOnly(false, this.getTaskletName() + "_UserRepositoryState");
        if (dataSource instanceof JdbcDataSource) {
            this.userProvisioningSqlMethodState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningSqlMethodState");
            this.selectDatabaseTableAndColumnsState.setViewOnly(false, this.getTaskletName() + "_ExpressProvisioningJdbcLocationState");
            this.userProvisioningJdbcUniqueIdState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningJdbcUniqueIdState");
            this.jdbcAdapterContractMappingState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningAdapterContractMappingState");
            this.selectStoredProceduresState.setViewOnly(false, this.getTaskletName() + "_SelectDatabaseSchemaAndStoredProcState");
            this.storedProcParamMappingState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningAdapterContractMappingState");
            this.storedProcParamMappingState.setNoteKey("UserProvisioningTasklet_UserProvisioningStoredProcParamMappingState");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(false, this.getTaskletName() + "_ConfigUserProvisioningLdapDirSearchState");
            this.userProvisioningConfigLdapFilterState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningConfigLdapFilterState");
            this.userProvisioningAttributesState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningAttributesState");
            this.ldapAdapterContractMappingState.setViewOnly(false, this.getTaskletName() + "_UserProvisioningAdapterContractMappingState");
        }
        return false;
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        this.isFinished = super.onFinish(cycle);
        return this.isFinished;
    }

    public void setReadOnly() {
        DataSource ds = this.getSelectedDataSource();
        Visit v = this.getSystemVisit();
        if (ds != null && !v.isSkipForUIPerformanceFlag()) {
            if (!this.isDataStoreAvailable(ds)) {
                this.setStatesToVOMode(ds);
            } else {
                this.setStatesToEditMode(ds);
            }
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    public ArrayList<String> getAllColumns() {
        return null;
    }

    @Override
    public List<String> getAllFields() {
        return null;
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return null;
    }

    @Override
    public List<String> getSelectedAttributes() {
        DataSource.DSType curType = this.userRepositoryState.getDataSourceType();
        switch (curType) {
            case JDBC: {
                return this.isTableSqlMethod() ? this.selectDatabaseTableAndColumnsState.getAllColumns() : this.selectStoredProceduresState.getAllColumns();
            }
            case LDAP: {
                return this.userProvisioningAttributesState.getSelectedAttributes();
            }
        }
        return null;
    }

    public String getSelectedSchema() {
        return this.isTableSqlMethod() ? this.selectDatabaseTableAndColumnsState.getSelectedSchema() : this.selectStoredProceduresState.getSelectedSchema();
    }

    public boolean isJdbcProvisioning() {
        return this.userRepositoryState.getDataSourceType() == DataSource.DSType.JDBC;
    }

    public boolean isLdapProvisioning() {
        return this.userRepositoryState.getDataSourceType() == DataSource.DSType.LDAP;
    }

    public boolean isTableSqlMethod() {
        return this.userProvisioningSqlMethodState.isTableSqlMethod();
    }

    public boolean isDatabaseTableAndColumnStatePopulated() {
        return this.selectDatabaseTableAndColumnsState.isPopulated();
    }

    public String getSelectedSqlMethodForDisplay() {
        return this.userProvisioningSqlMethodState.getSelectedSqlMethodForDisplay();
    }

    public ArrayList<String> getSelectedColumns() {
        return null;
    }

    @Override
    public List<String> getSelectedFields() {
        return null;
    }

    @Override
    public String getTableName() {
        return this.isTableSqlMethod() ? this.selectDatabaseTableAndColumnsState.getSelectedTable() : this.selectStoredProceduresState.getSelectedInsertStoredProcedure();
    }

    public String getSchemaName() {
        return this.isTableSqlMethod() ? this.selectDatabaseTableAndColumnsState.getSchemaName() : this.selectStoredProceduresState.getSchemaName();
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public boolean includeAdditionalValues() {
        return false;
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return null;
    }

    public String getAttributeQueryStatus() {
        if (this.userAttributesState == null) {
            return NOT_CONFIGURED;
        }
        return this.userAttributesState.isAttrQueryEnabled() ? ENABLED : NONE;
    }

    public String getErrorHandling() {
        if (this.isJdbcProvisioning()) {
            return this.jdbcErrorHandlingState.getSummary();
        }
        if (this.isLdapProvisioning()) {
            return this.ldapErrorHandlingState.getSummary();
        }
        return NOT_CONFIGURED;
    }

    public String getEventTrigger() {
        return this.eventTriggerState.getSummary();
    }

    public String getUserRepository() {
        return !StringUtils.isEmpty((String)this.userRepositoryState.getDataSourceDesc()) ? this.userRepositoryState.getDataSourceDesc() : NONE;
    }

    public List<ResultInfo> getAllColumnsWithMetadata() {
        return this.isTableSqlMethod() ? this.selectDatabaseTableAndColumnsState.getAllColumnsWithMetadata() : this.selectStoredProceduresState.getAllInsertStoredProcedureColumnsWithMetadata();
    }

    public List<MappingNameItem> getAttrQueryAttrList() {
        IdpConnectionConfigTasklet t = this.findParent(IdpConnectionConfigTasklet.class);
        return t.getAttrQueryAttrList();
    }

    public String getSelectedColumn() {
        return this.userProvisioningJdbcUniqueIdState.getSelectedColumn();
    }

    public List<String> getTarget() {
        DataSource.DSType curType = this.userRepositoryState.getDataSourceType();
        switch (curType) {
            case JDBC: {
                return this.jdbcAdapterContractMappingState.getTarget();
            }
            case LDAP: {
                return this.ldapAdapterContractMappingState.getTarget();
            }
        }
        return Collections.emptyList();
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        String assertionLabel = "Assertion";
        ConnectionTasklet connectionTasklet = this.getParentTasklet().findParent(ConnectionTasklet.class);
        if (connectionTasklet.isConnectionProtocolOIDC()) {
            assertionLabel = "Provider Claims";
        }
        sources.addPropertySelectionSource(assertionLabel, this.getAssertionValues());
        UserProvisioningTasklet t = this.findParent(UserProvisioningTasklet.class);
        if (t.isAttrQueryEnabled()) {
            sources.addPropertySelectionSource("Attribute Query", this.getAttrQueryAttrValues());
        }
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForExpressProv()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    public IPropertySelectionModel getAttrQueryAttrValues() {
        ArrayList<String> attrQueryLocalNames = new ArrayList<String>();
        for (MappingNameItem item : this.getAttrQueryAttrList()) {
            attrQueryLocalNames.add("${" + item.getLocalName() + "}");
        }
        return new StringPairPropertySelectionModel(true, attrQueryLocalNames);
    }

    private IPropertySelectionModel getAssertionValues() {
        AttributeNamesApi ana = this.findParent(AttributeNamesApi.class);
        String[] values = ana.getAllAttrNamesSorted().toArray(new String[0]);
        return new StringPairPropertySelectionModel(true, values);
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        DataSource.DSType curType = this.userRepositoryState.getDataSourceType();
        switch (curType) {
            case JDBC: {
                return this.jdbcAdapterContractMappingState.getModel();
            }
            case LDAP: {
                return this.ldapAdapterContractMappingState.getModel();
            }
        }
        return this.storedProcParamMappingState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return null;
    }
}

