/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ErrorHandlingState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsTrustAttributeContractState;
import com.pingidentity.fsm.state.impl.WsTrustRequestContractSelectionState;
import com.pingidentity.fsm.state.impl.WsTrustTokenProcessorMappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenProcessorMappingTasklet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;

public class WsTrustSpTokenCreationTasklet
extends Tasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 2L;
    final WsTrustAttributeContractState wsTrustAttributeContractState;
    final WsTrustRequestContractSelectionState wsTrustRequestContractSelectionState;
    final WsTrustTokenProcessorMappingState wsTrustTokenProcessorMappingState;
    final ErrorHandlingState wsTrustErrorHandlingState;
    final SummaryCardState summaryCardState;

    public WsTrustSpTokenCreationTasklet(Visit visit) {
        super("WsTrustSpTokenCreationTasklet", "Token Creation");
        this.setSystemVisit(visit);
        this.wsTrustAttributeContractState = new WsTrustAttributeContractState(this, "createAttributeContract");
        this.wsTrustRequestContractSelectionState = new WsTrustRequestContractSelectionState(this);
        this.wsTrustTokenProcessorMappingState = new WsTrustTokenProcessorMappingState(this);
        this.wsTrustErrorHandlingState = new ErrorHandlingState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setInitialState(this.wsTrustAttributeContractState);
        this.setCancelAvailable(true);
    }

    public void configureTasklet() {
        this.clearAllStatesOutgoingTransitions();
        this.wsTrustAttributeContractState.addOutgoingTransition(this, this.wsTrustRequestContractSelectionState);
        this.wsTrustRequestContractSelectionState.addOutgoingTransition(this, this.wsTrustTokenProcessorMappingState);
        if (this.wsTrustRequestContractSelectionState.isAdditionalParamsFromRequest()) {
            this.wsTrustTokenProcessorMappingState.addOutgoingTransition(this, this.wsTrustErrorHandlingState);
            this.wsTrustErrorHandlingState.addOutgoingTransition(this, this.summaryCardState);
        } else {
            this.wsTrustTokenProcessorMappingState.addOutgoingTransition(this, this.summaryCardState);
        }
    }

    public AttributeContract getContract() {
        return this.wsTrustAttributeContractState.getContract();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    public List<String> getProcessorsInUseByConnection() {
        return this.wsTrustTokenProcessorMappingState.getProcessorsInUseByConnection();
    }

    @Override
    public void finish() {
        SpConnection spConnection = new SpConnection();
        WsTrustFederatedWscSettings wsTrustFederatedWscSettings = new WsTrustFederatedWscSettings();
        spConnection.setWsTrustSettings(wsTrustFederatedWscSettings);
        this.save(spConnection);
        this.setPopulateData(spConnection.getWsTrustSettings());
        super.finish();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.wsTrustAttributeContractState.getAllAttrNamesSorted();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.wsTrustAttributeContractState.getAllAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.wsTrustAttributeContractState.getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.wsTrustAttributeContractState.getSortedMutableAttributeNames();
    }

    public boolean isAdditionalParamsFromRequest() {
        return this.wsTrustRequestContractSelectionState.isAdditionalParamsFromRequest();
    }

    public String getSelectedContract() {
        return this.wsTrustRequestContractSelectionState.getSelectedContract();
    }

    public void cleanAttributeMappings(Set<String> attributeContract) {
        List<Tasklet> mappingTasklets = this.wsTrustTokenProcessorMappingState.getTasklets();
        if (mappingTasklets != null) {
            for (Tasklet mappingTasklet : mappingTasklets) {
                if (!(mappingTasklet instanceof WsTrustTokenProcessorMappingTasklet)) continue;
                WsTrustTokenProcessorMappingTasklet contractMappingTasklet = (WsTrustTokenProcessorMappingTasklet)mappingTasklet;
                contractMappingTasklet.cleanAttributeMappings(attributeContract);
            }
        }
    }
}

