/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OverrideInstanceState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.VirtualServerIdMappingState;
import com.pingidentity.fsm.state.impl.WsTrustConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.WsTrustConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.WsTrustConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.WsTrustConfigureCustomSourceFiltersState;
import com.pingidentity.fsm.state.impl.WsTrustSelectCustomSourceFieldsState;
import com.pingidentity.fsm.state.impl.WsTrustSelectDataSourceState;
import com.pingidentity.fsm.state.impl.WsTrustSelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.state.impl.WsTrustSelectTokenGeneratorDataSourceState;
import com.pingidentity.fsm.state.impl.WsTrustSelectTokenGeneratorState;
import com.pingidentity.fsm.state.impl.WsTrustTokenGeneratorContractFulfillmentState;
import com.pingidentity.fsm.state.issuancecriteria.impl.WsTrustTokenGeneratorIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGenerationTasklet;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.websso.Protocol;

public class WsTrustTokenGeneratorMappingTasklet
extends MultiProtocolTasklet
implements AttributeSourceApi,
PluginMappingApi {
    private static final long serialVersionUID = 1L;
    private boolean defaultTokenForConnection = false;
    private final WsTrustSelectTokenGeneratorState wsTrustSelectTokenGeneratorState;
    private final VirtualServerIdMappingState virtualServerIdMappingState;
    private final WsTrustSelectTokenGeneratorDataSourceState wsTrustSelectTokenGeneratorDataSourceState;
    private final WsTrustSelectDataSourceState wsTrustSelectDataSourceState;
    private final WsTrustConfigLdapDirSearchState wsTrustConfigLdapDirSearchState;
    private final WsTrustConfigLdapFilterState wsTrustConfigLdapFilterState;
    private final WsTrustSelectDatabaseTableAndColumnsState wsTrustSelectDatabaseTableAndColumnsState;
    private final WsTrustConfigDatabaseFilterState wsTrustConfigDatabaseFilterState;
    private final WsTrustConfigureCustomSourceFiltersState wsTrustConfigureCustomSourceFiltersState;
    private final WsTrustSelectCustomSourceFieldsState wsTrustSelectCustomSourceFieldsState;
    private final WsTrustTokenGeneratorContractFulfillmentState wsTrustTokenGeneratorContractFulfillmentState;
    private final WsTrustTokenGeneratorIssuanceCriteriaState wsTrustTokenGeneratorIssuanceCriteriaState;
    private final SummaryCardState summaryCardState;
    private final OverrideInstanceState overrideInstanceState;

    public WsTrustTokenGeneratorMappingTasklet(Visit visit) {
        super("WsTrustTokenGeneratorMappingTasklet", "Token Generator Mapping & User Lookup");
        this.setSystemVisit(visit);
        this.wsTrustSelectTokenGeneratorState = new WsTrustSelectTokenGeneratorState(this);
        this.virtualServerIdMappingState = new VirtualServerIdMappingState(this);
        this.wsTrustSelectTokenGeneratorDataSourceState = new WsTrustSelectTokenGeneratorDataSourceState(this);
        this.wsTrustSelectDataSourceState = new WsTrustSelectDataSourceState(this, "idpSelectDataSource");
        this.wsTrustSelectDataSourceState.setMenuName("Data Store");
        this.wsTrustConfigLdapDirSearchState = new WsTrustConfigLdapDirSearchState(this, "configLdapDirSearch");
        this.wsTrustConfigLdapFilterState = new WsTrustConfigLdapFilterState(this, "idpConfigLdapFilter");
        this.wsTrustSelectDatabaseTableAndColumnsState = new WsTrustSelectDatabaseTableAndColumnsState(this);
        this.wsTrustConfigDatabaseFilterState = new WsTrustConfigDatabaseFilterState(this, "idpConfigDatabaseFilter");
        this.wsTrustConfigureCustomSourceFiltersState = new WsTrustConfigureCustomSourceFiltersState(this);
        this.wsTrustSelectCustomSourceFieldsState = new WsTrustSelectCustomSourceFieldsState(this);
        this.wsTrustTokenGeneratorContractFulfillmentState = new WsTrustTokenGeneratorContractFulfillmentState(this, "mapping");
        this.wsTrustTokenGeneratorIssuanceCriteriaState = new WsTrustTokenGeneratorIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.overrideInstanceState = new OverrideInstanceState(this);
        this.setInitialState(this.wsTrustSelectTokenGeneratorState);
        this.setCancelAvailable(true);
        this.wsTrustSelectTokenGeneratorState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.overrideInstanceState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return WsTrustTokenGeneratorMappingTasklet.this.isOverridePluginConnectionSettings();
            }
        });
        this.wsTrustSelectTokenGeneratorState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = WsTrustTokenGeneratorMappingTasklet.this.getParentTasklet().findParent(IdpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.wsTrustSelectTokenGeneratorState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustSelectTokenGeneratorDataSourceState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return !WsTrustTokenGeneratorMappingTasklet.this.isOverridePluginConnectionSettings();
            }
        });
        this.overrideInstanceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = WsTrustTokenGeneratorMappingTasklet.this.getParentTasklet().findParent(IdpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.overrideInstanceState.addOutgoingTransition(this, this.wsTrustSelectTokenGeneratorDataSourceState);
        this.wsTrustTokenGeneratorContractFulfillmentState.addOutgoingTransition(this, this.wsTrustTokenGeneratorIssuanceCriteriaState);
        this.wsTrustTokenGeneratorIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
        this.createNoAdditionalValuesTransitions();
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        if (!(curState instanceof WsTrustSelectTokenGeneratorState) && !(curState instanceof OverrideInstanceState)) {
            this.clearAllStatesOutgoingTransitions(curState);
        }
        if (curState instanceof WsTrustSelectTokenGeneratorDataSourceState) {
            WsTrustSelectTokenGeneratorDataSourceState state = (WsTrustSelectTokenGeneratorDataSourceState)curState;
            if (state.includeAdditionalValues()) {
                this.wsTrustSelectTokenGeneratorDataSourceState.addOutgoingTransition(this, this.wsTrustSelectDataSourceState);
                this.configureSelectDataSourceStateTransitions();
            } else {
                this.createNoAdditionalValuesTransitions();
            }
        } else if (curState instanceof WsTrustSelectDataSourceState) {
            this.configureSelectDataSourceStateTransitions();
        }
        this.wsTrustTokenGeneratorContractFulfillmentState.addOutgoingTransition(this, this.wsTrustTokenGeneratorIssuanceCriteriaState);
        this.wsTrustTokenGeneratorIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    private void configureSelectDataSourceStateTransitions() {
        DataSource.DSType curType = this.wsTrustSelectDataSourceState.getDataSourceType();
        switch (curType) {
            case Other: {
                this.createCustomTransitions();
                break;
            }
            case JDBC: {
                this.createJdbcTransitions();
                break;
            }
            case LDAP: {
                this.createLdapTransitions();
                break;
            }
            case None: {
                this.wsTrustSelectDataSourceState.addOutgoingTransition(this, this.wsTrustTokenGeneratorContractFulfillmentState);
            }
        }
    }

    private void createNoAdditionalValuesTransitions() {
        this.virtualServerIdMappingState.addOutgoingTransition(this, this.wsTrustSelectTokenGeneratorDataSourceState);
        this.wsTrustSelectTokenGeneratorDataSourceState.addOutgoingTransition(this, this.wsTrustTokenGeneratorContractFulfillmentState);
    }

    private void createLdapTransitions() {
        this.wsTrustSelectDataSourceState.addOutgoingTransition(this, this.wsTrustConfigLdapDirSearchState);
        this.wsTrustConfigLdapDirSearchState.addOutgoingTransition(this, this.wsTrustConfigLdapFilterState);
        this.wsTrustConfigLdapFilterState.addOutgoingTransition(this, this.wsTrustTokenGeneratorContractFulfillmentState);
    }

    private void createJdbcTransitions() {
        this.wsTrustSelectDataSourceState.addOutgoingTransition(this, this.wsTrustSelectDatabaseTableAndColumnsState);
        this.wsTrustSelectDatabaseTableAndColumnsState.addOutgoingTransition(this, this.wsTrustConfigDatabaseFilterState);
        this.wsTrustConfigDatabaseFilterState.addOutgoingTransition(this, this.wsTrustTokenGeneratorContractFulfillmentState);
    }

    private void createCustomTransitions() {
        this.wsTrustSelectDataSourceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustConfigureCustomSourceFiltersState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = WsTrustTokenGeneratorMappingTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                return instance == null || descriptor == null ? false : descriptor instanceof CustomDataSourceDriverDescriptor;
            }
        });
        this.wsTrustSelectDataSourceState.addOutgoingTransition(this, this.wsTrustSelectCustomSourceFieldsState);
        this.wsTrustConfigureCustomSourceFiltersState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustSelectCustomSourceFieldsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = WsTrustTokenGeneratorMappingTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                if (instance == null || descriptor == null) {
                    return true;
                }
                if (descriptor instanceof CustomDataSourceDriverDescriptor) {
                    return ((CustomDataSourceDriverDescriptor)descriptor).isShowSelectCustomSourceFields();
                }
                return true;
            }
        });
        this.wsTrustConfigureCustomSourceFiltersState.addOutgoingTransition(this, this.wsTrustTokenGeneratorContractFulfillmentState);
        this.wsTrustSelectCustomSourceFieldsState.addOutgoingTransition(this, this.wsTrustTokenGeneratorContractFulfillmentState);
    }

    @Override
    public Protocol getProtocolType() {
        return this.findParent(ConnectionTasklet.class).getProtocolType();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        AdministrativeUser user = this.getSystemVisit().getCurrentUser();
        return !user.isAuditor() && ((TaskletState)this.getCurrentState()).isSaveDraftAvailable();
    }

    public boolean setStatesToVOMode(DataSource dataSource) {
        this.wsTrustSelectDataSourceState.setViewOnly(true, this.getTaskletName() + "_WsTrustSelectDataSourceStateVo");
        if (dataSource instanceof JdbcDataSource) {
            this.wsTrustSelectDatabaseTableAndColumnsState.setViewOnly(true, this.getTaskletName() + "_WsTrustSelectDatabaseTableAndColumnsStateVo");
            this.wsTrustConfigDatabaseFilterState.setViewOnly(true, this.getTaskletName() + "_WsTrustConfigDatabaseFilterStateVo");
            this.wsTrustTokenGeneratorContractFulfillmentState.setViewOnly(true, this.getTaskletName() + "_WsTrustTokenGeneratorContractFulfillmentStateVo");
        } else if (dataSource instanceof LdapDataSource) {
            this.wsTrustConfigLdapDirSearchState.setViewOnly(true, this.getTaskletName() + "_WsTrustConfigLdapDirSearchStateVo");
            this.wsTrustConfigLdapFilterState.setViewOnly(true, this.getTaskletName() + "_WsTrustConfigLdapFilterStateVo");
            this.wsTrustTokenGeneratorContractFulfillmentState.setViewOnly(true, this.getTaskletName() + "_WsTrustTokenGeneratorContractFulfillmentStateVo");
        }
        return false;
    }

    public boolean setStatesToEditMode(DataSource dataSource) {
        this.wsTrustSelectDataSourceState.setViewOnly(false, this.getTaskletName() + "_WsTrustSelectDataSourceState");
        if (dataSource instanceof JdbcDataSource) {
            this.wsTrustSelectDatabaseTableAndColumnsState.setViewOnly(false, this.getTaskletName() + "_WsTrustSelectDatabaseTableAndColumnsState");
            this.wsTrustConfigDatabaseFilterState.setViewOnly(false, this.getTaskletName() + "_WsTrustConfigDatabaseFilterState");
            this.wsTrustTokenGeneratorContractFulfillmentState.setViewOnly(false, this.getTaskletName() + "_WsTrustTokenGeneratorContractFulfillmentState");
        } else if (dataSource instanceof LdapDataSource) {
            this.wsTrustConfigLdapDirSearchState.setViewOnly(false, this.getTaskletName() + "_WsTrustConfigLdapDirSearchState");
            this.wsTrustConfigLdapFilterState.setViewOnly(false, this.getTaskletName() + "_WsTrustConfigLdapFilterState");
            this.wsTrustTokenGeneratorContractFulfillmentState.setViewOnly(false, this.getTaskletName() + "_WsTrustTokenGeneratorContractFulfillmentState");
        }
        return false;
    }

    public void setNewTokenGenerator(boolean val) {
        this.wsTrustSelectTokenGeneratorState.setNewTokenGenerator(val);
    }

    public List<String> getGeneratorsInUseByConnection() {
        WsTrustTokenGenerationTasklet parentTasklet = (WsTrustTokenGenerationTasklet)this.getParentTasklet();
        return parentTasklet.getGeneratorsInUseByConnection();
    }

    public String getSelectedPluginId() {
        return this.wsTrustSelectTokenGeneratorState.getSelectedTokenGeneratorId();
    }

    @Override
    public void finish() {
        TokenPluginAttributeMapping tokenPluginAttributeMapping = new TokenPluginAttributeMapping();
        this.save(tokenPluginAttributeMapping);
        this.setPopulateData(tokenPluginAttributeMapping);
        super.finish();
    }

    public void setReadOnly() {
        DataSource ds = this.getSelectedDataSource();
        Visit v = this.getSystemVisit();
        if (ds != null && !v.isSkipForUIPerformanceFlag()) {
            if (!this.isDataStoreAvailable(ds)) {
                this.setStatesToVOMode(ds);
            } else {
                this.setStatesToEditMode(ds);
            }
        }
    }

    public List<String> getAttributeList() {
        WsTrustTokenGenerationTasklet parentTasklet = (WsTrustTokenGenerationTasklet)this.getParentTasklet();
        return parentTasklet.getAttributeList();
    }

    @Override
    public boolean isDataStoreAvailable(DataSource dataSource) {
        if (dataSource != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            return dsMgr.test(dataSource) ? true : this.setStatesToVOMode(dataSource);
        }
        return false;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.wsTrustSelectTokenGeneratorState.getSelectedTokenGenerator();
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.wsTrustSelectDataSourceState.getSelectedDataSource();
    }

    @Override
    public boolean includeAdditionalValues() {
        return this.wsTrustSelectTokenGeneratorDataSourceState.includeAdditionalValues();
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return null;
    }

    @Override
    public String getDescription() {
        if (this.isOverridePluginPopulated()) {
            return ((PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit()).getName();
        }
        return this.getSelectedPlugin() != null ? this.getSelectedPlugin().getName() : "";
    }

    public List<String> getVirtualServerIds() {
        return this.virtualServerIdMappingState.getRestrictedVirtualServerIds();
    }

    @Override
    public String getType() {
        return this.wsTrustSelectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public String getTableName() {
        return this.wsTrustSelectDatabaseTableAndColumnsState.getSelectedTable();
    }

    @Override
    public List<String> getAllColumns() {
        return this.wsTrustSelectDatabaseTableAndColumnsState.getAllColumns();
    }

    @Override
    public List<String> getContractToFulfill() {
        return this.wsTrustSelectTokenGeneratorState.getAttributeList();
    }

    @Override
    public String getDataSourceType() {
        return this.wsTrustSelectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return this.wsTrustSelectTokenGeneratorDataSourceState.getSelectedDataSource();
    }

    @Override
    public List<String> getSelectedColumns() {
        return this.wsTrustSelectDatabaseTableAndColumnsState.getSelectedColumns();
    }

    @Override
    public List<String> getAllAttributes() {
        return this.wsTrustConfigLdapDirSearchState.getAllAttributes();
    }

    @Override
    public List<String> getSelectedAttributes() {
        return this.wsTrustConfigLdapDirSearchState.getSelectedAttributes();
    }

    @Override
    public List<String> getAllFields() {
        return this.wsTrustSelectCustomSourceFieldsState.getAllFields();
    }

    @Override
    public List<String> getSelectedFields() {
        return this.wsTrustSelectCustomSourceFieldsState.getSelectedFields();
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return this.wsTrustSelectDataSourceState.getSelectedCustomAttributeSource();
    }

    public boolean isDefaultTokenForConnection() {
        return this.defaultTokenForConnection;
    }

    public void setDefaultTokenForConnection(boolean defaultTokenForConnection) {
        this.defaultTokenForConnection = defaultTokenForConnection;
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        List<String> attributeList = this.getAttributeList();
        String[] values = attributeList.toArray(new String[attributeList.size()]);
        sources.addPropertySelectionSource("Assertion", new StringPairPropertySelectionModel(true, values));
        if (this.includeAdditionalValues()) {
            String[] dsValues = null;
            if ("JDBC".equals(this.getDataSourceType())) {
                List<String> selectedColumns = this.getSelectedColumns();
                dsValues = selectedColumns.toArray(new String[selectedColumns.size()]);
            } else if ("LDAP".equals(this.getType())) {
                List<String> selectedAttributes = this.getSelectedAttributes();
                dsValues = selectedAttributes.toArray(new String[selectedAttributes.size()]);
            } else {
                List<String> selectedFields = this.getSelectedFields();
                dsValues = selectedFields.toArray(new String[selectedFields.size()]);
            }
            sources.addPropertySelectionSource(this.getDataSourceType(), new StringPairPropertySelectionModel(true, dsValues));
        }
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForWsTrustTokenGen()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    public Set<String> getTarget() {
        return this.wsTrustTokenGeneratorContractFulfillmentState.getTarget();
    }

    @Override
    public boolean isOverridePluginConnectionSettings() {
        return this.wsTrustSelectTokenGeneratorState.isOverrideAdapterConnectionSettings();
    }

    @Override
    public boolean isNewAdapter() {
        return this.wsTrustSelectTokenGeneratorState.isNewTokenGenerator();
    }

    @Override
    public void refreshAttributeOverrides() {
        this.wsTrustSelectTokenGeneratorState.createTokenGeneratorAttributeList();
    }

    @Override
    public boolean isOverridePluginPopulated() {
        return this.isOverridePluginConnectionSettings() && this.overrideInstanceState.getTaskletToEdit() != null && this.overrideInstanceState.getTaskletToEdit().getPopulateData() != null;
    }

    @Override
    public List<String> getPluginContract() {
        PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit();
        if (this.isOverridePluginPopulated() && pluginInstanceTasklet.createAdapterContractState.getContract() != null) {
            return pluginInstanceTasklet.getAllContractAttrNamesSorted();
        }
        return this.wsTrustSelectTokenGeneratorState.getAttributeList();
    }

    @Override
    public void removeConnectionOverride() {
        this.overrideInstanceState.setTaskletToEditToNull();
    }

    public String getPluginId() {
        if (this.isOverridePluginPopulated()) {
            return ((PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit()).getPluginId();
        }
        return this.getSelectedPluginId();
    }

    @Override
    public void cancel() {
        TokenPluginAttributeMapping mapping;
        if (this.getPopulateData() != null && (mapping = (TokenPluginAttributeMapping)this.getPopulateData()).isSavedConnectionOverride()) {
            mapping.resetAdapterInstanceId();
        }
        super.cancel();
    }

    public String getLdapSearchScope() {
        return this.wsTrustConfigLdapDirSearchState.getSelectedSearchScope();
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.wsTrustTokenGeneratorContractFulfillmentState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.wsTrustTokenGeneratorIssuanceCriteriaState.getIssuanceCriteriaList();
    }
}

