/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.fragments;

import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.state.impl.fragments.PolicyFragmentState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.AbstractPolicyTasklet;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PolicyFragmentTasklet
extends AbstractPolicyTasklet {
    private static final long serialVersionUID = 1L;
    private final transient PolicyFragmentManager fragmentManager = MgmtFactory.getPolicyFragmentManager();
    private final PolicyFragmentState fragmentState;

    public PolicyFragmentTasklet(Visit visit) {
        super(visit);
        this.setMenuName("Fragment");
        this.setTaskletName("PolicyFragmentTasklet");
        this.setHelpName("PolicyFragmentTasklet");
        this.fragmentState = new PolicyFragmentState(this);
        this.setInitialState(this.fragmentState);
        this.setFinishLabel("Save");
    }

    @Override
    public void finish() {
        PolicyFragment fragment = this.getCurrentPolicyFragment();
        this.fragmentState.saveMappings();
        this.fragmentManager.save(fragment);
        this.populate(fragment);
        this.setMode(Mode.edit);
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.AUTHN_POLICY_ATTRS);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.FRAGMENT_ATTRS);
        dependencyErrorHandler.removeDependencyError(this.getId(), AffectedItemType.FRAGMENTS);
        this.checkForClusterReplication();
        super.finish();
    }

    public void delete() {
        PolicyFragment fragment = this.getCurrentPolicyFragment();
        this.fragmentManager.delete(fragment.getId());
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.removeDependencyError(this.getId(), AffectedItemType.FRAGMENTS);
    }

    @Override
    public AbstractPolicyState getPolicyState() {
        return this.fragmentState;
    }

    public PolicyFragment getCurrentPolicyFragment() {
        return this.fragmentState.getPolicyFragment();
    }

    @Override
    public boolean isFragment() {
        return true;
    }

    public String getInputContractId() {
        return this.fragmentState.getInputContractId();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isIdInUse(String id) {
        return this.getParentPoliciesState().getTasklets().stream().anyMatch(tasklet -> id.equalsIgnoreCase(((AbstractPolicyTasklet)tasklet).getId()));
    }

    @Override
    public boolean isFinishAvailable() {
        return !this.getCurrentUser().isAuditor() && super.isFinishAvailable();
    }

    @Override
    public boolean isSaveAllAvailable() {
        return !this.getCurrentUser().isAuditor() && super.isSaveAllAvailable();
    }

    @Override
    public boolean isNameInUse(String name) {
        return this.getParentPoliciesState().getTasklets().stream().anyMatch(tasklet -> name.equalsIgnoreCase(((PolicyFragmentTasklet)tasklet).getName()) && !this.getId().equals(((PolicyFragmentTasklet)tasklet).getId()));
    }

    public boolean isInUse() {
        return MgmtFactory.getPolicyFragmentManager().isFragmentInUse(this.getId());
    }

    public void refresh(IRequestCycle cycle) {
        this.fragmentState.setDelegate(this.getDelegate(cycle));
        this.fragmentState.refreshState();
    }
}

