/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.oauth.exchange;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.oauth.exchange.GeneratorPolicyManagementState;
import com.pingidentity.fsm.state.impl.oauth.exchange.GeneratorTokenTypeState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.BasePolicyManagementTasklet;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class GeneratorPolicyManagementTasklet
extends BasePolicyManagementTasklet {
    private static final long serialVersionUID = 20200508L;
    private static final String MENU_NAME = "Token Exchange Generator Group";
    private final GeneratorPolicyManagementState generatorPolicyManagementState;
    private final GeneratorTokenTypeState generatorTokenTypeState;
    private final SummaryCardState summaryCardState;
    private final transient TokenExchangeGeneratorPolicyManager generatorPolicyManager = MgmtFactory.getTokenExchangeGeneratorPolicyManager();

    public GeneratorPolicyManagementTasklet(Visit visit) {
        super("GeneratorPolicyManagementTasklet", MENU_NAME);
        this.setSystemVisit(visit);
        this.generatorPolicyManagementState = new GeneratorPolicyManagementState(this);
        this.generatorTokenTypeState = new GeneratorTokenTypeState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.generatorPolicyManagementState.addOutgoingTransition(this, this.generatorTokenTypeState);
        this.generatorTokenTypeState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.generatorPolicyManagementState);
        this.setCancelAvailable(true);
        this.setSaveDraftAvailable(false);
    }

    @Override
    public String getId() {
        return this.generatorPolicyManagementState.getId();
    }

    @Override
    public void delete() {
        TokenExchangeGeneratorPolicies tegps = this.generatorPolicyManager.getTokenExchangeGeneratorPolicies();
        TokenExchangeGeneratorPolicy tegp = this.getTokenExchangeGeneratorPolicy();
        tegps.removePolicy(tegp.getId());
        this.generatorPolicyManager.saveTokenExchangeGeneratorPolicies(tegps);
    }

    public String getName() {
        return this.generatorPolicyManagementState.getName();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void cancel() {
        Object origData = this.getPopulateData();
        if (origData != null) {
            TokenExchangeGeneratorPolicy policy = (TokenExchangeGeneratorPolicy)origData;
            super.cancel();
            this.setPopulateData(policy);
        } else {
            super.cancel();
        }
    }

    @Override
    public void finish() {
        TokenExchangeGeneratorPolicies tegps = this.generatorPolicyManager.getTokenExchangeGeneratorPolicies();
        TokenExchangeGeneratorPolicy tegp = this.getTokenExchangeGeneratorPolicy();
        tegps.addPolicy(tegp);
        if (StringUtils.isEmpty((String)tegps.getDefaultInstanceId())) {
            tegps.setDefaultInstanceId(tegp.getId());
        }
        this.generatorPolicyManager.saveTokenExchangeGeneratorPolicies(tegps);
        super.finish();
    }

    public TokenExchangeGeneratorPolicy getTokenExchangeGeneratorPolicy() {
        TokenExchangeGeneratorPolicy tokenExchangeGeneratorPolicy = new TokenExchangeGeneratorPolicy();
        this.save(tokenExchangeGeneratorPolicy);
        return tokenExchangeGeneratorPolicy;
    }
}

