/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.oauth.exchange;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorPolicy2GeneratorMappingState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorPolicy2GeneratorMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.impl.DependencyErrorManagementTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Source2TargetManager;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class PolicyProcessor2GeneratorMappingTasklet
extends Source2TargetMappingTasklet<ProcessorPolicy2GeneratorMapping> {
    private static final long serialVersionUID = 2019111203L;
    private final transient TokenGeneratorManager tokenGeneratorMgr = MgmtFactory.getTokenGeneratorManager();
    private final transient TokenExchangeProcessorPolicyManager processorPolicyMgr = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private final transient ProcessorPolicy2TokenGeneratorManager teppToGroupMappingMgr = MgmtFactory.getProcessorPolicy2TokenGeneratorManager();

    public PolicyProcessor2GeneratorMappingTasklet(Visit visit) {
        super("PolicyProcessor2GeneratorMappingTasklet", "Mapping Configuration", visit);
        this.setSaveDraftAvailable(false);
    }

    @Override
    public String getNoteKeySuffix() {
        return "PP2TG";
    }

    @Override
    public String getMappingSourceForDisplay() {
        return "Processor Policies";
    }

    @Override
    public MappingState buildMappingFullfillmentState() {
        return new ProcessorPolicy2GeneratorMappingState(this, "mapping");
    }

    @Override
    public void loadMapping(ProcessorPolicy2GeneratorMapping mapping) {
        this.s2tMapping = mapping;
        TokenExchangeProcessorPolicy policy = this.processorPolicyMgr.getTokenExchangeProcessorPolicies().getPolicy(mapping.getSourceId());
        this.sourceInstance = ProcessorPolicy2GeneratorMappingsState.createDummySource(policy);
        this.targetInstance = this.tokenGeneratorMgr.getInstance(mapping.getTargetId());
    }

    @Override
    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        StringPairPropertySelectionModel sourceModel = new StringPairPropertySelectionModel(true);
        ConfigurablePluginInstance sourceInstance = this.getSelectedPlugin();
        for (String name : sourceInstance.getAttributeContract().getAllAttrNamesSorted()) {
            sourceModel.add(name, name);
        }
        sources.addPropertySelectionSource("Processor Policy", sourceModel);
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForTokenExchangeProcessorPolicyMappings()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
        this.addExtendedPropertiesToSelectionSources(sources);
    }

    @Override
    public ProcessorPolicy2GeneratorMapping copyMapping(ProcessorPolicy2GeneratorMapping mapping) {
        return new ProcessorPolicy2GeneratorMapping((Source2TargetMapping)mapping);
    }

    @Override
    protected void createTransitions() {
        this.licenseGroupState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.mappingFullfillmentState);
        this.mappingFullfillmentState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public AffectedItemType getAffectedItemType() {
        return AffectedItemType.TEPP_TO_TG_MAPPING;
    }

    @Override
    public void finish() {
        Tasklet parent = this.getParentTasklet();
        if (parent instanceof DependencyErrorManagementTasklet) {
            ProcessorPolicy2GeneratorMapping populateData = (ProcessorPolicy2GeneratorMapping)this.getSource2TargetManager().createEmptyMapping();
            this.save(populateData);
            ProcessorPolicy2GeneratorMapping mapping = populateData;
            mapping.setSourceId(((ProcessorPolicy2GeneratorMapping)this.s2tMapping).getSourceId());
            mapping.setTargetId(((ProcessorPolicy2GeneratorMapping)this.s2tMapping).getTargetId());
            this.teppToGroupMappingMgr.saveMapping((Source2TargetMapping)mapping);
            DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            String sourceId = ((ProcessorPolicy2GeneratorMapping)this.s2tMapping).getSourceId();
            TokenExchangeProcessorPolicies tokenExchangeProcessorPolicies = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies();
            TokenExchangeProcessorPolicy policy = tokenExchangeProcessorPolicies.getPolicy(sourceId);
            if (policy != null) {
                dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)policy, DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY);
            }
            String tokenGeneratorId = ((ProcessorPolicy2GeneratorMapping)this.s2tMapping).getTargetId();
            TokenGeneratorInstance tg = (TokenGeneratorInstance)MgmtFactory.getTokenGeneratorManager().getInstance(tokenGeneratorId);
            if (tg != null) {
                dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)tg, DependencyType.TOKEN_GENERATOR);
            }
        }
        super.finish();
    }

    @Override
    public Source2TargetManager<ProcessorPolicy2GeneratorMapping> getSource2TargetManager() {
        return this.teppToGroupMappingMgr;
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.addAll(super.getAdditionalInputAttributesForFilter());
        attributes.addAll(this.getExtendedPropertiesSubstitutionsForFilter());
        Collections.sort(attributes);
        return attributes;
    }
}

