/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.oauth.exchange;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BaseConfigAttributeSourcesState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorMappingAttributeSourcesState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorMappingContractFulfillmentState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorMappingIssuanceCriteriaState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorMappingTokenTypeState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorPolicyManagementTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class ProcessorMappingTasklet
extends MappingTasklet {
    private static final String TASKLET_NAME = "ProcessorMappingTasklet";
    private static final String MENU_NAME = "Token Processor Mapping";
    private final TokenProcessorManager tokenProcessorMgr = MgmtFactory.getTokenProcessorManager();
    private final ProcessorMappingTokenTypeState processorMappingTokenTypeState;
    private final ProcessorMappingContractFulfillmentState processorMappingContractFulfillmentState;
    private final ProcessorMappingIssuanceCriteriaState processorMappingIssuanceCriteriaState;
    private final SummaryCardState summaryCardState;

    public ProcessorMappingTasklet(Visit visit) {
        super(TASKLET_NAME, MENU_NAME);
        this.setSystemVisit(visit);
        this.processorMappingTokenTypeState = new ProcessorMappingTokenTypeState(this);
        this.processorMappingContractFulfillmentState = new ProcessorMappingContractFulfillmentState(this, "processorMappingContractFulfillment");
        this.processorMappingIssuanceCriteriaState = new ProcessorMappingIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.processorMappingTokenTypeState.addOutgoingTransition(this, this.configAttributeSourcesState);
        this.configAttributeSourcesState.addOutgoingTransition(this, this.processorMappingContractFulfillmentState);
        this.processorMappingContractFulfillmentState.addOutgoingTransition(this, this.processorMappingIssuanceCriteriaState);
        this.processorMappingIssuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.processorMappingTokenTypeState);
        this.setCancelAvailable(true);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public BaseConfigAttributeSourcesState constructConfigAttributeSourcesState() {
        return new ProcessorMappingAttributeSourcesState(this, "configAttributeSources");
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getMappingSourceForDisplay() {
        return null;
    }

    public String getSubjectTokenType() {
        return this.processorMappingTokenTypeState.getSubjectTokenType();
    }

    public String getActorTokenType() {
        return this.processorMappingTokenTypeState.getActorTokenType();
    }

    public boolean isActorTokenRequired() {
        ProcessorPolicyManagementTasklet parentTasklet = (ProcessorPolicyManagementTasklet)this.getParentTasklet();
        return parentTasklet.isActorTokenRequired();
    }

    public void addContextSources(DataMap.Sources sources) {
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForTokenExchangeProcessorPolicyMappings()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    public void addTokenProcessorSources(DataMap.Sources sources) {
        TokenProcessorInstance subjectInstance = (TokenProcessorInstance)this.tokenProcessorMgr.getInstance(this.processorMappingTokenTypeState.getSubjectTokenProcessor());
        StringPairPropertySelectionModel subjectModel = new StringPairPropertySelectionModel(true);
        for (String attrName : subjectInstance.getAttributeContract().getAllAttrNamesSorted()) {
            subjectModel.add(attrName, "subjecttoken." + attrName);
        }
        sources.addPropertySelectionSource("Subject Token", subjectModel);
        if (StringUtils.isNotBlank((String)this.processorMappingTokenTypeState.getActorTokenProcessor())) {
            TokenProcessorInstance actorInstance = (TokenProcessorInstance)this.tokenProcessorMgr.getInstance(this.processorMappingTokenTypeState.getActorTokenProcessor());
            StringPairPropertySelectionModel actorModel = new StringPairPropertySelectionModel(true);
            for (String attrName : actorInstance.getAttributeContract().getAllAttrNamesSorted()) {
                actorModel.add(attrName, "actortoken." + attrName);
            }
            sources.addPropertySelectionSource("Actor Token", actorModel);
        }
        this.addExtendedPropertiesToSelectionSources(sources);
    }

    @Override
    public Collection<String> getAdditionalInputAttributesForFilter() {
        TokenProcessorInstance subjectInstance = (TokenProcessorInstance)this.tokenProcessorMgr.getInstance(this.processorMappingTokenTypeState.getSubjectTokenProcessor());
        Set<String> result = subjectInstance.getAttributeContract().getAllAttrNamesSorted().stream().map(s -> "subjecttoken." + s).collect(Collectors.toSet());
        if (StringUtils.isNotBlank((String)this.processorMappingTokenTypeState.getActorTokenProcessor())) {
            TokenProcessorInstance actorInstance = (TokenProcessorInstance)this.tokenProcessorMgr.getInstance(this.processorMappingTokenTypeState.getActorTokenProcessor());
            result.addAll(actorInstance.getAttributeContract().getAllAttrNamesSorted().stream().map(s -> "actortoken." + s).collect(Collectors.toSet()));
        }
        result.addAll(this.getExtendedPropertiesSubstitutionsForFilter());
        return result;
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }
}

