/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.setup;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.DirectorySetupSummaryState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.setup.AbstractSetupState;
import com.pingidentity.fsm.state.impl.setup.DirectorySetupState;
import com.pingidentity.fsm.state.impl.setup.KerberosAuthenticationState;
import com.pingidentity.fsm.state.impl.setup.LdapsConfirmationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;

public class DirectorySetupTasklet
extends Tasklet {
    private final Log log = LogFactory.getLog(this.getClass());
    private final DirectorySetupState directorySetupState;
    private final KerberosAuthenticationState kerberosAuthenticationState;
    private final DirectorySetupSummaryState summaryCardState;
    private final List<AbstractSetupState> states = new LinkedList<AbstractSetupState>();

    public DirectorySetupTasklet(Visit visit) {
        super("DirectorySetupTasklet", "Directory Configuration");
        this.setSystemVisit(visit);
        this.directorySetupState = new DirectorySetupState(this);
        this.kerberosAuthenticationState = new KerberosAuthenticationState(this);
        this.summaryCardState = new DirectorySetupSummaryState(this);
        this.summaryCardState.setSummaryTitle("Summary");
        this.states.add(this.directorySetupState);
        this.states.add(this.kerberosAuthenticationState);
        this.setCancelAvailable(true);
        this.setSaveDraftAvailable(false);
        this.setInitialState(this.directorySetupState);
        this.reconfigureTransitions();
        this.populateAllStates(null);
    }

    @Override
    public void reconfigureTransitions() {
        this.clearAllStatesOutgoingTransitions();
        this.directorySetupState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.kerberosAuthenticationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return DirectorySetupTasklet.this.directorySetupState.isActiveDirectory();
            }
        });
        this.directorySetupState.addOutgoingTransition(new TaskletTransition(this, this.summaryCardState));
        this.kerberosAuthenticationState.addOutgoingTransition(new TaskletTransition(this, this.summaryCardState));
    }

    @Override
    public boolean isNextEnabled() {
        if (this.getCurrentState() instanceof LdapsConfirmationState) {
            return ((LdapsConfirmationState)this.getCurrentState()).shouldNextButtonBeEnabled();
        }
        return ((TaskletState)this.getCurrentState()).isNextEnabled();
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    public SummaryCardState getSummaryCardState() {
        return this.summaryCardState;
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        if (super.onFinish(cycle)) {
            this.saveStateValues();
            this.getParentTasklet().next(cycle);
            return true;
        }
        return false;
    }

    @Override
    public void resetAllStates() {
        super.resetAllStates();
        if (this.isCompleted()) {
            for (TaskletState tempState : this.getStateList()) {
                tempState.setItClickable(true);
            }
        }
    }

    @Override
    public void gotoSummaryState(IRequestCycle cycle) {
        if (this.isCompleted()) {
            this.setGotoState(this.getSummaryState().getTaskletStateId());
            this.goToState(cycle);
        }
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    private void saveStateValues() {
        for (AbstractSetupState state : this.states) {
            state.saveCurrentState();
        }
    }

    public DirectorySetupState getDirectorySetupState() {
        return this.directorySetupState;
    }

    public KerberosAuthenticationState getKerberosAuthenticationState() {
        return this.kerberosAuthenticationState;
    }
}

