/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConnectionLimitState;
import com.pingidentity.fsm.state.impl.setup.DeleteDraftState;
import com.pingidentity.fsm.state.impl.setup.IdentitiesConfigState;
import com.pingidentity.fsm.state.impl.setup.KerberosAuthenticationState;
import com.pingidentity.fsm.state.impl.setup.PingOneConfirmationState;
import com.pingidentity.fsm.state.impl.setup.PingOneNextStepsState;
import com.pingidentity.fsm.state.impl.setup.ProvisioningSetupState;
import com.pingidentity.fsm.state.impl.setup.SamlEntityIdState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.impl.setup.PingOneSetupTasklet;
import java.util.Set;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public class IdpConfigurationTasklet
extends PingOneSetupTasklet {
    private KerberosAuthenticationState kerberosAuthenticationState;
    private ProvisioningSetupState provisioningSetupState;

    public IdpConfigurationTasklet(Visit visit) {
        super("ConnectToPingOne", "Configure Identity Repository");
        this.setSystemVisit(visit);
        this.deleteDraftState = new DeleteDraftState(this);
        this.samlEntityIdState = new SamlEntityIdState(this);
        this.identitiesConfigState = new IdentitiesConfigState(this);
        this.identitiesConfigState.showSpConnTemplate(true);
        this.identitiesConfigState.setDirectoryNote("Use this option to connect with a new or existing data store.");
        this.identitiesConfigState.setSimplePcvNote("If you just want to quickly get PingFederate functioning as a test Identity Repository, you don't need to connect to a directory.");
        this.kerberosAuthenticationState = new KerberosAuthenticationState(this);
        this.provisioningSetupState = new ProvisioningSetupState(this);
        this.pingOneConfirmationState = new PingOneConfirmationState(this);
        this.pingOneConfirmationState.setPingoneSSOUsecase(true);
        this.pingOneNextStepsState = new PingOneNextStepsState((IWizard)this, false);
        if (!LicenseManager.canAddConnection()) {
            this.setInitialState(new ConnectionLimitState(this));
            this.setCancelAvailable(false);
            this.setFinishAvailable(false);
            this.setSaveDraftAvailable(false);
            return;
        }
        if (this.isDeleteDraftNeeded()) {
            this.setInitialState(this.deleteDraftState);
        } else {
            this.setInitialState(this.identitiesConfigState);
        }
        this.reconfigureTransitions();
        this.setCancelAvailable(true);
        this.setSaveDraftAvailable(false);
        this.populateAllStates(null);
    }

    @Override
    public void reconfigureTransitions() {
        this.deleteDraftState.addOutgoingTransition(this, this.identitiesConfigState);
        this.identitiesConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.samlEntityIdState){

            @Override
            public boolean validate() {
                return !IdpConfigurationTasklet.this.isSamlEntityIdDefined();
            }
        });
        this.samlEntityIdState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.kerberosAuthenticationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConfigurationTasklet.this.isActiveDirectory();
            }
        });
        this.samlEntityIdState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.provisioningSetupState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConfigurationTasklet.this.isDirectoryConfigured() && IdpConfigurationTasklet.this.canConfigureProvisioning();
            }
        });
        this.identitiesConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.kerberosAuthenticationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConfigurationTasklet.this.isActiveDirectory();
            }
        });
        this.identitiesConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.provisioningSetupState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConfigurationTasklet.this.isDirectoryConfigured() && IdpConfigurationTasklet.this.canConfigureProvisioning();
            }
        });
        this.kerberosAuthenticationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.provisioningSetupState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConfigurationTasklet.this.isDirectoryConfigured() && IdpConfigurationTasklet.this.canConfigureProvisioning();
            }
        });
        this.samlEntityIdState.addOutgoingTransition(this, this.pingOneConfirmationState);
        this.kerberosAuthenticationState.addOutgoingTransition(new TaskletTransition(this, this.pingOneConfirmationState));
        this.provisioningSetupState.addOutgoingTransition(new TaskletTransition(this, this.pingOneConfirmationState));
        this.identitiesConfigState.addOutgoingTransition(this, this.pingOneConfirmationState);
        this.pingOneConfirmationState.addOutgoingTransition(this, this.pingOneNextStepsState);
    }

    @Override
    public String getPingOneAccountName() {
        return MgmtFactory.getPingOneAdminService().getMetadata().getPingOneCompanyName();
    }

    @Override
    public boolean isPingOneProvisioningEnabled() {
        return this.provisioningSetupState.isConfigureProvisioning();
    }

    @Override
    public String getPingOneProvisioningGroupDn() {
        return this.provisioningSetupState.getGroupDN();
    }

    @Override
    public boolean isPingOneProvisioningNested() {
        return this.provisioningSetupState.isNestedGroups();
    }

    @Override
    public boolean isKerberosConfigured() {
        return this.kerberosAuthenticationState.isConfigureKerberos();
    }

    @Override
    public String getRealmName() {
        return this.kerberosAuthenticationState.getRealmName();
    }

    @Override
    public KerberosRealm getKerberosRealm() {
        return this.kerberosAuthenticationState.getKerberosRealm();
    }

    @Override
    public Set<String> getKerberosIpRanges() {
        return this.kerberosAuthenticationState.getIpRanges();
    }

    @Override
    public Set<String> getKdcHostnames() {
        return this.kerberosAuthenticationState.getHostnames();
    }

    @Override
    public boolean isPingoneSSOUsecase() {
        return true;
    }

    @Override
    public boolean isPingIDUsecase() {
        return false;
    }
}

