/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.IWizardTransition;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.setup.AbstractDirectoryConfigState;
import com.pingidentity.fsm.state.impl.setup.BasicInfoState;
import com.pingidentity.fsm.state.impl.setup.CreateAdminAccountState;
import com.pingidentity.fsm.state.impl.setup.IdentitiesConfigState;
import com.pingidentity.fsm.state.impl.setup.IdentityStoreConfigState;
import com.pingidentity.fsm.state.impl.setup.KerberosAuthenticationState;
import com.pingidentity.fsm.state.impl.setup.LicenseImportState;
import com.pingidentity.fsm.state.impl.setup.PingFedConfirmationState;
import com.pingidentity.fsm.state.impl.setup.PingFedNextStepsState;
import com.pingidentity.fsm.state.impl.setup.PingOneAccountState;
import com.pingidentity.fsm.state.impl.setup.PingOneConfirmationState;
import com.pingidentity.fsm.state.impl.setup.PingOneNextStepsState;
import com.pingidentity.fsm.state.impl.setup.ProvisioningSetupState;
import com.pingidentity.fsm.state.impl.setup.UsecasesState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.impl.MainMenuTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.DirectorySetupTasklet;
import com.pingidentity.session.AdminSessionTracker;
import com.pingidentity.session.LoginTracker;
import com.pingidentity.util.ProvisionerGlobalSettingsHelper;
import com.pingidentity.util.ResponseModificationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.util.license.LicenseManager;

public class InitialSetupTasklet
extends AbstractPingOneSetupTasklet {
    private final Log log = LogFactory.getLog(this.getClass());
    private PingOneAccountState pingOneAccountState;
    private LicenseImportState licenseImportState;
    private IdentitiesConfigState identitiesConfigState;
    private UsecasesState usecasesState;
    private BasicInfoState basicInfoState;
    private CreateAdminAccountState createAdminAccountState;
    private IdentityStoreConfigState identityStoreConfigState;
    private PingFedConfirmationState pingFedConfirmationState;
    private PingFedNextStepsState pingFedNextStepsState;
    private AdministrativeUser tempUser;

    public InitialSetupTasklet(Visit visit, HttpServletRequest request) {
        super("InitialSetupTasklet", "Setup");
        this.setSystemVisit(visit);
        this.createStates();
        if (this.isNativeLogin()) {
            this.loginAsTempUser(request);
        }
        this.reconfigureTransitions();
    }

    @Override
    public void reconfigureTransitions() {
        if (this.pingOneAccountState.isPingOneSelected() || StringUtils.isBlank((String)this.pingOneAccountState.getSetupType())) {
            this.setupPingOneFlow();
        } else {
            this.setupStandaloneFlow();
        }
        this.resetClickability(this.pingOneAccountState);
    }

    private void setupPingOneFlow() {
        List<Object> transitions = Collections.emptyList();
        if (this.identitiesConfigState.getOutgoingTransitions() != null) {
            transitions = Arrays.asList(this.identitiesConfigState.getOutgoingTransitions());
        }
        this.pingOneAccountState.clearOutgoingTransitions();
        this.identitiesConfigState.clearOutgoingTransitions();
        this.usecasesState.clearOutgoingTransitions();
        this.basicInfoState.clearOutgoingTransitions();
        this.pingOneConfirmationState.clearOutgoingTransitions();
        this.pingOneAccountState.addOutgoingTransition(this, this.identitiesConfigState);
        if (!transitions.isEmpty()) {
            transitions.forEach(transition -> this.identitiesConfigState.addOutgoingTransition((IWizardTransition)transition));
        } else {
            this.identitiesConfigState.addOutgoingTransition(this, this.usecasesState);
        }
        this.usecasesState.addOutgoingTransition(this, this.basicInfoState);
        this.basicInfoState.addOutgoingTransition(this, this.pingOneConfirmationState);
        this.basicInfoState.setNoteKey("PingOneSetup_BasicInfoState_note");
        this.pingOneConfirmationState.addOutgoingTransition(this, this.pingOneNextStepsState);
    }

    private void resetClickability(TaskletState initialState) {
        if (initialState.getOutgoingTransition() != null) {
            TaskletState nextState = (TaskletState)initialState.getOutgoingTransition().getTarget();
            if (!initialState.isItClickable()) {
                nextState.setItClickable(false);
            }
            this.resetClickability(nextState);
        }
    }

    private void setupStandaloneFlow() {
        this.pingOneAccountState.clearOutgoingTransitions();
        this.licenseImportState.clearOutgoingTransitions();
        this.basicInfoState.clearOutgoingTransitions();
        this.identityStoreConfigState.clearOutgoingTransitions();
        this.createAdminAccountState.clearOutgoingTransitions();
        this.pingFedConfirmationState.clearOutgoingTransitions();
        this.pingOneAccountState.addOutgoingTransition(this, this.licenseImportState);
        this.licenseImportState.addOutgoingTransition(this, this.basicInfoState);
        this.basicInfoState.setNoteKey("StandaloneSetup_BasicInfoState_note");
        this.basicInfoState.addOutgoingTransition(this, this.identityStoreConfigState);
        this.basicInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.createAdminAccountState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return InitialSetupTasklet.this.isNativeLogin();
            }
        });
        this.basicInfoState.addOutgoingTransition(this, this.pingFedConfirmationState);
        this.identityStoreConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.createAdminAccountState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return InitialSetupTasklet.this.isNativeLogin();
            }
        });
        this.identityStoreConfigState.addOutgoingTransition(this, this.pingFedConfirmationState);
        this.identityStoreConfigState.setDataStoreRequired(false);
        this.identityStoreConfigState.setDirectoryButtonLabel("Begin");
        this.createAdminAccountState.addOutgoingTransition(this, this.pingFedConfirmationState);
        this.pingFedConfirmationState.addOutgoingTransition(this, this.pingFedNextStepsState);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void finish() {
        MainMenuTasklet portalMenu = new MainMenuTasklet(this.getSystemVisit());
        this.getSystemVisit().getTaskletStack().add(0, portalMenu);
        this.getSystemVisit().setInitialTasklet(portalMenu);
        RequestContext ctx = this.getCycle().getRequestContext();
        if (ctx != null) {
            HttpServletResponse resp = ctx.getResponse();
            if (resp != null) {
                ResponseModificationUtil.setClearSiteDataHeaders(this.getCycle().getRequestContext().getResponse());
            }
            ResponseModificationUtil.setPathRedirectOnResponse(ctx, "/pingfederate/app");
        }
        super.finish();
    }

    @Override
    public String getEntityId() {
        return this.basicInfoState.getEntityID();
    }

    @Override
    public boolean next(IRequestCycle cycle) {
        boolean result = super.next(cycle);
        if (this.needsPingOneSso(this.getSystemVisit())) {
            this.logoutCurrentUser();
            throw new PageRedirectException("login");
        }
        return result;
    }

    @Override
    public boolean isEnablingSaml2Protocol() {
        return true;
    }

    @Override
    public void saveEntityIdState() {
        this.basicInfoState.save(null);
    }

    @Override
    public void clearEntityId() {
        this.basicInfoState.setEntityID("");
    }

    @Override
    public String getPingOneAccountName() {
        return this.pingOneAccountState.getCompanyName();
    }

    public String getAdminUsername() {
        return this.createAdminAccountState.getUsername();
    }

    @Override
    public void preSave() {
        if (this.isNativeLogin()) {
            AdminAuthManager.getInstance().getAdminUserManager().saveUsers(new ArrayList());
            if (!this.isAssociated()) {
                this.logoutCurrentUser();
                this.loginAsUser(this.createAdminAccountState.getNewUser(), this.getCycle().getRequestContext().getRequest());
            }
        }
    }

    @Override
    public String getBaseURL() {
        return this.basicInfoState.getBaseURL();
    }

    @Override
    public boolean isInitialSetup() {
        return true;
    }

    public void loginAsUser(AdministrativeUser user, HttpServletRequest request) {
        LoginTracker loginTracker = LoginTracker.getInstance();
        this.getSystemVisit().setCurrentUser(user);
        this.getSystemVisit().setUserAuthenticated(true);
        AdminAuditLogger.setIpAddress((String)request.getRemoteAddr());
        AdminAuditLogger.setUser((String)user.getUserName());
        AdminAuditLogger.setRoles((String)new String(user.describeUser(true)));
        if (!user.equals((Object)this.tempUser)) {
            AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)this.getMessage("Login_success"));
        }
        loginTracker.logInUser(request, user);
        AdminSessionTracker.getInstance().addAdminSession(request.getSession(), user);
    }

    public boolean needsPingOneSso(Visit visit) {
        return !visit.isPingOneSso() && this.isAssociated() && this.isNativeLogin();
    }

    public void logoutCurrentUser() {
        AdministrativeUser currentUser = this.getSystemVisit().getCurrentUser();
        if (currentUser != null) {
            LoginTracker loginTracker = LoginTracker.getInstance();
            loginTracker.logOutUser(this.getCycle().getRequestContext().getSession(), currentUser);
        }
        this.getSystemVisit().setCurrentUser(null);
        this.getSystemVisit().setUserAuthenticated(false);
        this.getSystemVisit().setPingOneSso(false);
    }

    public void loginAsTempUser(HttpServletRequest request) {
        this.createTempUser();
        this.loginAsUser(this.tempUser, request);
    }

    private void createTempUser() {
        if (this.tempUser == null) {
            this.tempUser = new AdministrativeUser();
            this.tempUser.setAdmin(true);
            this.tempUser.setAdminManager(true);
            this.tempUser.setCryptoManager(true);
            this.tempUser.setExpressionAdmin(true);
            this.tempUser.setUserName("temporary");
            this.tempUser.setActive(true);
            this.tempUser.setDescription("Temporary user for setup.");
            this.tempUser.setIsTempUser(true);
        }
    }

    private void createStates() {
        this.pingOneAccountState = new PingOneAccountState(this);
        this.licenseImportState = new LicenseImportState(this);
        this.identitiesConfigState = new IdentitiesConfigState(this);
        this.usecasesState = new UsecasesState(this);
        this.basicInfoState = new BasicInfoState(this);
        this.createAdminAccountState = new CreateAdminAccountState(this);
        this.identityStoreConfigState = new IdentityStoreConfigState(this);
        this.pingOneConfirmationState = new PingOneConfirmationState(this);
        this.pingFedConfirmationState = new PingFedConfirmationState(this);
        this.pingOneNextStepsState = new PingOneNextStepsState((IWizard)this, true);
        this.pingFedNextStepsState = new PingFedNextStepsState(this);
        this.setInitialState(this.pingOneAccountState);
        this.setCurrentState(this.pingOneAccountState);
    }

    @Override
    public void resetAllStates() {
        this.reconfigureTransitions();
    }

    @Override
    public boolean isFullWidth() {
        return true;
    }

    private boolean isNativeLogin() {
        return AdminAuthManager.getInstance().isNative();
    }

    @Override
    UsecasesState getUsecaseState() {
        return this.usecasesState;
    }

    @Override
    KerberosAuthenticationState getKerberosState() {
        if (this.pingOneAccountState.isPingOneSelected() || StringUtils.isBlank((String)this.pingOneAccountState.getSetupType())) {
            return this.usecasesState.getKerberosState();
        }
        return this.identityStoreConfigState.getTaskletToEdit(DirectorySetupTasklet.class).getKerberosAuthenticationState();
    }

    public UsecasesState getIdentitiesDefaultNextState() {
        return this.usecasesState;
    }

    @Override
    public boolean isNextEnabled() {
        return ((TaskletState)this.getCurrentState()).isNextEnabled();
    }

    @Override
    public void importLicense(IValidationDelegate delegate) {
        this.log.debug((Object)"Importing new license.");
        ArrayList errors = new ArrayList();
        LicenseManager.importLicense((String)this.getLicenseString(), errors);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                delegate.record(error, ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    ProvisioningSetupState getProvisioningSetupState() {
        return this.usecasesState.getProvisioningState();
    }

    @Override
    public AbstractDirectoryConfigState getDirectoryState() {
        if (this.pingOneAccountState.isPingOneSelected() || StringUtils.isBlank((String)this.pingOneAccountState.getSetupType())) {
            return this.identitiesConfigState;
        }
        return this.identityStoreConfigState.getTaskletToEdit(DirectorySetupTasklet.class).getDirectorySetupState();
    }

    @Override
    public boolean canConfigureProvisioning() {
        if (!this.isDirectoryConfigured()) {
            return false;
        }
        boolean hasRealLicense = this.hasRealLicense();
        if (!hasRealLicense && this.isAssociated()) {
            return true;
        }
        return hasRealLicense && ProvisionerGlobalSettingsHelper.canEnableProvisioning();
    }

    private boolean hasRealLicense() {
        return LicenseManager.getLicense() != null && LicenseManager.getLicense().isValid();
    }

    private String getLicenseString() {
        if (this.pingOneAccountState.isPingOneSelected()) {
            return this.pingOneAccountState.getPingOneLicense();
        }
        return this.licenseImportState.getLicenseContents();
    }

    @Override
    public boolean isShowDisconnect() {
        return true;
    }

    @Override
    public boolean isBridgeMode() {
        if (!this.hasRealLicense() && this.isAssociated()) {
            return true;
        }
        return super.isBridgeMode();
    }

    public boolean canAddConnection() {
        return true;
    }
}

