/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.setup;

import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.draft.mgmt.DraftManagerImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.setup.AbstractDirectoryConfigState;
import com.pingidentity.fsm.state.impl.setup.ConnectToPingOneState;
import com.pingidentity.fsm.state.impl.setup.DeleteDraftState;
import com.pingidentity.fsm.state.impl.setup.IdentitiesConfigState;
import com.pingidentity.fsm.state.impl.setup.KerberosAuthenticationState;
import com.pingidentity.fsm.state.impl.setup.PingOneConfirmationState;
import com.pingidentity.fsm.state.impl.setup.PingOneNextStepsState;
import com.pingidentity.fsm.state.impl.setup.ProvisioningSetupState;
import com.pingidentity.fsm.state.impl.setup.SamlEntityIdState;
import com.pingidentity.fsm.state.impl.setup.UsecasesState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.util.ProvisionerGlobalSettingsHelper;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public class PingOneSetupTasklet
extends AbstractPingOneSetupTasklet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final LocalSettingsManager settingsManager = MgmtFactory.getLocalSettingsManager();
    private static final PingOneAdminService service = MgmtFactory.getPingOneAdminService();
    private static final DraftManager draftManager = DraftManagerImpl.getInstance();
    protected ConnectToPingOneState connectToPingOneState;
    protected DeleteDraftState deleteDraftState;
    protected IdentitiesConfigState identitiesConfigState;
    protected UsecasesState usecasesState;
    protected SamlEntityIdState samlEntityIdState;
    private String p1EntityId;
    private boolean isDraftDeleted = false;

    public PingOneSetupTasklet(String taskletName, String menuName) {
        super(taskletName, menuName);
    }

    public PingOneSetupTasklet(Visit visit) {
        super("ConnectToPingOne", "Connect to PingOne for Enterprise");
        this.setSystemVisit(visit);
        this.connectToPingOneState = new ConnectToPingOneState(this);
        this.deleteDraftState = new DeleteDraftState(this);
        this.samlEntityIdState = new SamlEntityIdState(this);
        this.identitiesConfigState = new IdentitiesConfigState(this);
        this.identitiesConfigState.showSpConnTemplate(true);
        this.usecasesState = new UsecasesState(this);
        this.pingOneConfirmationState = new PingOneConfirmationState(this);
        this.pingOneNextStepsState = new PingOneNextStepsState((IWizard)this, false);
        this.setInitialState(this.connectToPingOneState);
        this.reconfigureTransitions();
        this.setCancelAvailable(true);
        this.setSaveDraftAvailable(false);
        this.populateAllStates(null);
    }

    @Override
    public void onCancelWithoutPop(IRequestCycle cycle) {
        super.onCancelWithoutPop(cycle);
        this.setReloadToPingOneSettings();
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        boolean finishStatus = super.onFinish(cycle);
        this.setReloadToPingOneSettings();
        return finishStatus;
    }

    @Override
    public boolean isEnablingSaml2Protocol() {
        return this.samlEntityIdState.isEnableProtocol();
    }

    @Override
    public void preSave() {
    }

    @Override
    public String getBaseURL() {
        return "";
    }

    @Override
    public String getEntityId() {
        return this.samlEntityIdState.getEntityID();
    }

    @Override
    public void saveEntityIdState() {
        this.samlEntityIdState.setEnableProtocol(true);
        if (StringUtils.isBlank((String)this.samlEntityIdState.getEntityID())) {
            this.samlEntityIdState.setEntityID(this.getP1DefaultEntityId());
        }
        this.samlEntityIdState.save(null);
    }

    private String getP1DefaultEntityId() {
        PingOneAdminService service = MgmtFactory.getPingOneAdminService();
        if (service.isAssociated()) {
            return service.getSpConnectionFactory().getFactoryMetadata().getGlobalEntityId();
        }
        return "";
    }

    @Override
    public void clearEntityId() {
        this.samlEntityIdState.setEntityID("");
    }

    @Override
    public String getPingOneAccountName() {
        return this.connectToPingOneState.getCompanyName();
    }

    @Override
    public void importLicense(IValidationDelegate delegate) {
    }

    @Override
    public void reconfigureTransitions() {
        if (StringUtils.isBlank((String)settingsManager.getLocalSettings().getEntityId())) {
            this.connectToPingOneState.addOutgoingTransition(this, this.identitiesConfigState);
            this.identitiesConfigState.addOutgoingTransition(this, this.usecasesState);
            this.usecasesState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.samlEntityIdState){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean validate() {
                    if (PingOneSetupTasklet.this.usecasesState.isPingOneSSOSelected()) {
                        PingOneSetupTasklet.this.samlEntityIdState.setEnableProtocol(true);
                        return true;
                    }
                    return false;
                }
            });
            this.samlEntityIdState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.deleteDraftState){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean validate() {
                    return PingOneSetupTasklet.this.isDeleteDraftNeeded();
                }
            });
            this.usecasesState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.deleteDraftState){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean validate() {
                    return PingOneSetupTasklet.this.isDeleteDraftNeeded();
                }
            });
        } else {
            this.samlEntityIdState.setEnableProtocol(false);
            this.connectToPingOneState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.deleteDraftState){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean validate() {
                    return PingOneSetupTasklet.this.isDeleteDraftNeeded();
                }
            });
            this.connectToPingOneState.addOutgoingTransition(this, this.identitiesConfigState);
        }
        this.samlEntityIdState.addOutgoingTransition(this, this.pingOneConfirmationState);
        this.deleteDraftState.addOutgoingTransition(new TaskletTransition(this, this.pingOneConfirmationState));
        this.identitiesConfigState.addOutgoingTransition(this, this.usecasesState);
        this.usecasesState.addOutgoingTransition(this, this.pingOneConfirmationState);
        this.pingOneConfirmationState.addOutgoingTransition(this, this.pingOneNextStepsState);
        super.reconfigureTransitions();
    }

    public boolean isDraftDeleted() {
        return this.isDraftDeleted;
    }

    public void setDraftDeleted(boolean draftDeleted) {
        this.isDraftDeleted = draftDeleted;
    }

    protected boolean isDeleteDraftNeeded() {
        return this.isAssociated() && !this.isDraftDeleted() && this.doesP1DraftConnectionExist();
    }

    private boolean doesP1DraftConnectionExist() {
        this.p1EntityId = this.getP1EntityId();
        return draftManager.isSpEntityIdInUse(this.p1EntityId, null);
    }

    public void deleteP1DraftConnection() {
        if (!StringUtils.isEmpty((String)this.p1EntityId)) {
            draftManager.deleteDraft(this.p1EntityId, ConnectionType.SP);
            this.setDraftDeleted(true);
        }
        this.setInitialState(this.connectToPingOneState);
        this.reconfigureTransitions();
    }

    public String getP1EntityId() {
        if (this.p1EntityId != null) {
            return this.p1EntityId;
        }
        String entityID = "";
        try {
            entityID = service.getSpConnectionFactory().createSpConnection().getEntityId();
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to retrieve entity id from PingOne.");
        }
        return entityID;
    }

    @Override
    protected ProvisioningSetupState getProvisioningSetupState() {
        return this.usecasesState.getProvisioningState();
    }

    @Override
    public AbstractDirectoryConfigState getDirectoryState() {
        return this.identitiesConfigState;
    }

    @Override
    public boolean canConfigureProvisioning() {
        return this.isDirectoryConfigured() && ProvisionerGlobalSettingsHelper.canEnableProvisioning();
    }

    @Override
    UsecasesState getUsecaseState() {
        return this.usecasesState;
    }

    @Override
    KerberosAuthenticationState getKerberosState() {
        return this.usecasesState.getKerberosState();
    }

    @Override
    public boolean isNextAvailable() {
        if (this.getCurrentState() instanceof DeleteDraftState) {
            return false;
        }
        return super.isNextAvailable();
    }

    boolean isSamlEntityIdDefined() {
        return StringUtils.isNotBlank((String)settingsManager.getLocalSettings().getEntityId());
    }

    public boolean canAddConnection() {
        return LicenseManager.canAddConnection();
    }

    @Override
    public boolean gotoSummaryIfPopSkipped() {
        return true;
    }

    @Override
    public boolean isSkipPopToParent() {
        return this.isAssociated();
    }

    private void setReloadToPingOneSettings() {
        this.setupNavMenuReload();
        this.setNavMenuTarget("pingOneSettings");
    }
}

