/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.setup;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.setup.KerberosAuthenticationState;
import com.pingidentity.fsm.state.impl.setup.PingOneSsoSummaryState;
import com.pingidentity.fsm.state.impl.setup.ProvisioningSetupState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.PingOneSsoWizard;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.util.ProvisionerGlobalSettingsHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public class PingOneSsoSetupTasklet
extends Tasklet
implements PingOneSsoWizard {
    private final KerberosAuthenticationState kerberosAuthenticationState;
    private final ProvisioningSetupState provisioningSetupState;
    private final PingOneSsoSummaryState summaryCardState;

    public PingOneSsoSetupTasklet(Visit visit) {
        super("PingOneSsoSetupTasklet", "PingOne SSO Additional Features");
        this.setSystemVisit(visit);
        this.kerberosAuthenticationState = new KerberosAuthenticationState(this);
        this.provisioningSetupState = new ProvisioningSetupState(this);
        this.summaryCardState = new PingOneSsoSummaryState(this);
        this.setCancelAvailable(true);
        this.setSaveDraftAvailable(false);
        this.setInitialState(this.kerberosAuthenticationState);
        this.setupTransitions();
    }

    private void setupTransitions() {
        this.kerberosAuthenticationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.provisioningSetupState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PingOneSsoSetupTasklet.this.canConfigureProvisioning();
            }
        });
        this.kerberosAuthenticationState.addOutgoingTransition(new TaskletTransition(this, this.summaryCardState));
        this.provisioningSetupState.addOutgoingTransition(new TaskletTransition(this, this.summaryCardState));
    }

    public boolean canConfigureProvisioning() {
        boolean hasRealLicense;
        if (!this.isDirectoryConfigured()) {
            return false;
        }
        boolean bl = hasRealLicense = LicenseManager.getLicense() != null && LicenseManager.getLicense().isValid();
        if (!hasRealLicense && this.isAssociated()) {
            return true;
        }
        return hasRealLicense && ProvisionerGlobalSettingsHelper.canEnableProvisioning();
    }

    private AbstractPingOneSetupTasklet getParent() {
        return this.findParent(AbstractPingOneSetupTasklet.class);
    }

    @Override
    public void reconfigureTransitions() {
        this.setupTransitions();
        if (this.canConfigureKerberos()) {
            this.setInitialState(this.kerberosAuthenticationState);
        } else {
            this.setInitialState(this.provisioningSetupState);
        }
    }

    public ProvisioningSetupState getProvisioningState() {
        return this.provisioningSetupState;
    }

    private boolean isAssociated() {
        PingOneAdminService pingOneAdminService = MgmtFactory.getPingOneAdminService();
        return pingOneAdminService.isAssociated();
    }

    public KerberosAuthenticationState getKerberosState() {
        return this.kerberosAuthenticationState;
    }

    @Override
    public boolean canConfigureKerberos() {
        return this.getParent().isActiveDirectory();
    }

    @Override
    public boolean isPingOneProvisioningEnabled() {
        return this.provisioningSetupState.isConfigureProvisioning();
    }

    @Override
    public boolean isKerberosConfigured() {
        return this.kerberosAuthenticationState.isConfigureKerberos();
    }

    @Override
    public String getRealmName() {
        return this.kerberosAuthenticationState.getRealmName();
    }

    @Override
    public KerberosRealm getKerberosRealm() {
        return this.kerberosAuthenticationState.getKerberosRealm();
    }

    @Override
    public Set<String> getKerberosIpRanges() {
        return this.kerberosAuthenticationState.getIpRanges();
    }

    @Override
    public Set<String> getKdcHostnames() {
        return this.kerberosAuthenticationState.getHostnames();
    }

    @Override
    public boolean isDirectoryConfigured() {
        AbstractPingOneSetupTasklet wizard = this.getParent();
        return wizard.isDirectoryConfigured();
    }

    @Override
    public LdapDataSource getDirectoryDataSource() {
        AbstractPingOneSetupTasklet wizard = this.getParent();
        return wizard.getDirectoryDataSource();
    }

    @Override
    public String getSearchBase() {
        return this.findParent(PingOneSsoWizard.class).getSearchBase();
    }

    @Override
    public String getSearchFilter() {
        return this.findParent(PingOneSsoWizard.class).getSearchFilter();
    }

    @Override
    public String getPingOneProvisioningGroupDn() {
        return this.provisioningSetupState.getGroupDN();
    }

    @Override
    public boolean isPingOneProvisioningNested() {
        return this.provisioningSetupState.isNestedGroups();
    }

    @Override
    public boolean isBridgeMode() {
        return this.getParent().isBridgeMode();
    }

    public Map<String, Object> getCurrentData() {
        HashMap<String, Object> currentData = new HashMap<String, Object>();
        currentData.put(this.kerberosAuthenticationState.getClass().getCanonicalName(), this.kerberosAuthenticationState.getCurrentData());
        currentData.put(this.provisioningSetupState.getClass().getCanonicalName(), this.provisioningSetupState.getCurrentData());
        return currentData;
    }
}

