/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.module.connection.admin;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.module.connection.admin.AdminConnectionModuleManager;
import com.pingidentity.module.connection.admin.ConnectionModuleState;
import com.pingidentity.module.connection.admin.ServerSettingsState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class AdminConnectionModuleSupport {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String ADMIN_DESCRIPTOR_FILE = "PF-INF/connection-module-admin-descriptor";
    private static final String DESCRIPTOR_PROPERTIES_ID = "Module.Id";
    private static final String DESCRIPTOR_PROPERTIES_ROLES = "Roles";
    private static final String DESCRIPTOR_PROPERTIES_ADMIN_MANAGER = "Admin.Manager.Class";
    private static final String DESCRIPTOR_PROPERTIES_CONN_STATE = "Connection.State.Class";
    private static final String DESCRIPTOR_PROPERTIES_SERVER_SETTINGS_STATE = "Server.Settings.State.Class";
    private final List<ModuleDescriptor> adminIdpModuleDescriptors = this.generateModuleDescriptorList(Role.IDP);
    private final List<ModuleDescriptor> adminSpModuleDescriptors = this.generateModuleDescriptorList(Role.SP);
    private static AdminConnectionModuleSupport instance = new AdminConnectionModuleSupport();

    private AdminConnectionModuleSupport() {
    }

    public static AdminConnectionModuleSupport getInstance() {
        return instance;
    }

    public List<ConnectionModuleState> getConnectionStates(ConnectionTasklet connectionTasklet) {
        Role role;
        ArrayList<ConnectionModuleState> connectionModuleStates = new ArrayList<ConnectionModuleState>();
        if (connectionTasklet instanceof IdpConnectionConfigTasklet) {
            role = Role.IDP;
        } else if (connectionTasklet instanceof SpConnectionConfigTasklet) {
            role = Role.SP;
        } else {
            this.log.error((Object)("Invalid ConnectionTasklet : " + connectionTasklet.getClass().getName()));
            return null;
        }
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            AdminConnectionModuleManager manager = moduleDescriptor.createAdminModuleManagerInstance();
            ConnectionModuleState state = manager.createConnectionState(connectionTasklet);
            connectionModuleStates.add(state);
        }
        return connectionModuleStates;
    }

    public List<ServerSettingsState> getServerSettingsStates(Tasklet ownerTasklet) {
        ArrayList<ServerSettingsState> serverSettingsStates = new ArrayList<ServerSettingsState>();
        ArrayList<ModuleDescriptor> moduleDescriptors = new ArrayList<ModuleDescriptor>(this.adminIdpModuleDescriptors);
        moduleDescriptors.addAll(this.adminSpModuleDescriptors);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            AdminConnectionModuleManager manager = moduleDescriptor.createAdminModuleManagerInstance();
            ServerSettingsState state = manager.createServerSettingsState(ownerTasklet);
            serverSettingsStates.add(state);
        }
        return serverSettingsStates;
    }

    public List<AdminConnectionModuleManager> getAdminManagers(Role role) {
        return this.getAdminManagers(role, true);
    }

    public List<AdminConnectionModuleManager> getAdminManagers(Role role, boolean includeModulesWithoutGlobalConfiguration) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        if (moduleDescriptors != null) {
            ArrayList<AdminConnectionModuleManager> connectionModuleManagers = new ArrayList<AdminConnectionModuleManager>();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (!includeModulesWithoutGlobalConfiguration && !ConnectionModuleSupport.getInstance().moduleDefinesGlobalConfiguration(moduleDescriptor.getId(), role)) continue;
                AdminConnectionModuleManager manager = moduleDescriptor.createAdminModuleManagerInstance();
                connectionModuleManagers.add(manager);
            }
            return connectionModuleManagers;
        }
        this.log.error((Object)("Invalid Role passed in when getting a list of " + AdminConnectionModuleManager.class.getName()));
        return null;
    }

    public Class<? extends ConnectionModuleState> getConnectionStateClass(Class<? extends AdminConnectionModuleManager> manager, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            String descriptorMgrName = moduleDescriptor.getAdminManagerClassName();
            if (!manager.getName().equals(descriptorMgrName)) continue;
            return moduleDescriptor.getConnectionModuleStateClass();
        }
        return null;
    }

    public Class<? extends ServerSettingsState> getServerSettingsStateClass(Class<? extends AdminConnectionModuleManager> manager, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            String descriptorMgrName = moduleDescriptor.getAdminManagerClassName();
            if (!manager.getName().equals(descriptorMgrName)) continue;
            return moduleDescriptor.getServerSettingsStateClass();
        }
        return null;
    }

    public Class<? extends ConnectionModuleConfiguration> getConfigurationClassFromConnState(Class<? extends ConnectionModuleState> state, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getConnectionModuleStateClass() != state) continue;
            return ConnectionModuleSupport.getInstance().getConnectionConfigurationClass(moduleDescriptor.getId(), role);
        }
        return null;
    }

    public ConnectionModuleManager getManagerFromState(Class<? extends ConnectionModuleState> state, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getConnectionModuleStateClass() != state) continue;
            return ConnectionModuleSupport.getInstance().getManager(moduleDescriptor.getId(), role);
        }
        return null;
    }

    public Class<? extends ConnectionModuleGlobalConfiguration> getGlobalConfigurationClassFromState(Class<? extends ServerSettingsState> state, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getServerSettingsStateClass() != state) continue;
            return ConnectionModuleSupport.getInstance().getGlobalConfigurationClass(moduleDescriptor.getId(), role);
        }
        return null;
    }

    public AdminConnectionModuleManager getAdminManagerFromConnState(Class<? extends ConnectionModuleState> state, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getConnectionModuleStateClass() != state) continue;
            return moduleDescriptor.createAdminModuleManagerInstance();
        }
        return null;
    }

    public AdminConnectionModuleManager getAdminManagerFromState(Class<? extends ServerSettingsState> state, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getServerSettingsStateClass() != state) continue;
            return moduleDescriptor.createAdminModuleManagerInstance();
        }
        return null;
    }

    private List<ModuleDescriptor> getModuleDescriptors(Role connectionRole) {
        List<ModuleDescriptor> moduleDescriptors = null;
        if (connectionRole == Role.IDP) {
            moduleDescriptors = this.adminIdpModuleDescriptors;
        } else if (connectionRole == Role.SP) {
            moduleDescriptors = this.adminSpModuleDescriptors;
        } else {
            this.log.error((Object)("Invalid connectionRole :" + connectionRole));
        }
        return moduleDescriptors;
    }

    public boolean isModuleInUse(Role role, Class<? extends ServerSettingsState> serverSettingsStateClass) {
        Class<? extends ConnectionModuleConfiguration> moduleConfigurationClass = this.getConfigurationClass(serverSettingsStateClass, role);
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        if (role == Role.IDP) {
            return connectionManager.isIdpConnectionModuleInUse(moduleConfigurationClass);
        }
        return connectionManager.isSpConnectionModuleInUse(moduleConfigurationClass);
    }

    private Class<? extends ConnectionModuleConfiguration> getConfigurationClass(Class<? extends ServerSettingsState> state, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getServerSettingsStateClass() != state) continue;
            return ConnectionModuleSupport.getInstance().getConnectionConfigurationClass(moduleDescriptor.getId(), role);
        }
        return null;
    }

    private List<ModuleDescriptor> generateModuleDescriptorList(Role roleToGenerate) {
        ArrayList<ModuleDescriptor> moduleDescriptorList = new ArrayList<ModuleDescriptor>();
        Enumeration<URL> resources = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> en = resources = classLoader.getResources(ADMIN_DESCRIPTOR_FILE);
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                try {
                    Object content = url.getContent();
                    if (!(content instanceof InputStream)) continue;
                    InputStream is = (InputStream)content;
                    Properties properties = new Properties();
                    properties.load(is);
                    String moduleRoles = properties.getProperty(DESCRIPTOR_PROPERTIES_ROLES).trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(moduleRoles, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        String role = (String)stringTokenizer.nextElement();
                        if (!roleToGenerate.toString().equalsIgnoreCase(role)) continue;
                        String moduleId = properties.getProperty(DESCRIPTOR_PROPERTIES_ID).trim();
                        String adminManagerName = properties.getProperty(DESCRIPTOR_PROPERTIES_ADMIN_MANAGER).trim();
                        String connectionModuleStateName = properties.getProperty(DESCRIPTOR_PROPERTIES_CONN_STATE).trim();
                        String serverSettingsStateName = properties.getProperty(DESCRIPTOR_PROPERTIES_SERVER_SETTINGS_STATE).trim();
                        ModuleDescriptor moduleDescriptor = new ModuleDescriptor(moduleId, adminManagerName, connectionModuleStateName, serverSettingsStateName);
                        moduleDescriptorList.add(moduleDescriptor);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return moduleDescriptorList;
    }

    private static class ModuleDescriptor {
        private String id;
        private String adminManagerClassName;
        private String connectionModuleStateClassName;
        private String serverSettingsStateClassName;

        public ModuleDescriptor(String moduleId, String adminManager, String connectionModuleState, String serverSettingsState) {
            this.id = moduleId;
            this.adminManagerClassName = adminManager;
            this.connectionModuleStateClassName = connectionModuleState;
            this.serverSettingsStateClassName = serverSettingsState;
        }

        public String getId() {
            return this.id;
        }

        public String getAdminManagerClassName() {
            return this.adminManagerClassName;
        }

        public Class<? extends ConnectionModuleState> getConnectionModuleStateClass() {
            return this.getClass(this.connectionModuleStateClassName);
        }

        public Class<? extends ServerSettingsState> getServerSettingsStateClass() {
            return this.getClass(this.serverSettingsStateClassName);
        }

        public String toString() {
            return "Module Id : " + this.id + " , Admin Manager : " + this.adminManagerClassName + ", Connection Module State : " + this.connectionModuleStateClassName + ", Server Settings State : " + this.serverSettingsStateClassName;
        }

        public AdminConnectionModuleManager createAdminModuleManagerInstance() {
            return (AdminConnectionModuleManager)this.createModuleClassInstance(this.adminManagerClassName);
        }

        private Class<?> getClass(String className) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return clazz;
        }

        public Object createModuleClassInstance(String className) {
            Log log = LogFactory.getLog((String)"AdminConnectionModuleSupport");
            Object classFromModule = null;
            try {
                Class<?> moduleClass = Class.forName(className);
                classFromModule = moduleClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Error creating instance of " + className + ".  Class not found."));
            }
            catch (InstantiationException e) {
                log.error((Object)("Error creating instance of " + className + ".  Instantiation exception."));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Error creating instance of " + className + ".  Illegal access exception."));
            }
            return classFromModule;
        }
    }
}

