/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.multipart;

import com.pingidentity.session.LoginTracker;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.multipart.DefaultMultipartDecoder;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.util.license.LicenseValidator;

public class PFMultipartDecoder
extends DefaultMultipartDecoder {
    private int maxLicenseSize;
    private static final Log log = LogFactory.getLog(PFMultipartDecoder.class);
    private final ConfigStore loginConfigStore = ConfigStoreFarm.getConfig(PFMultipartDecoder.class);
    private boolean skipCleanup = false;
    private final LicenseValidator licenseValidator;

    public PFMultipartDecoder() {
        this(new LicenseValidator());
    }

    public PFMultipartDecoder(LicenseValidator licenseValidator) {
        this.licenseValidator = licenseValidator;
        this.maxLicenseSize = this.loginConfigStore.getIntValue("MaxLicenseUploadSize", 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void decode(HttpServletRequest request) {
        if (!this.licenseValidator.hasValidLicense()) {
            if (this.isLicenseSizeValid(request)) {
                super.decode(request);
                return;
            }
            this.skipCleanup = true;
            log.error((Object)("The provided license file size exceeds the max size of " + this.maxLicenseSize + " MB."));
            throw new PageRedirectException("Exception");
        }
        if (this.isRequestLoggedIn(request)) {
            super.decode(request);
            return;
        }
        this.skipCleanup = true;
        log.warn((Object)"Unauthenticated attempt to upload a file detected. Redirecting to the login screen..");
        throw new PageRedirectException("login");
    }

    public void cleanup(HttpServletRequest request) {
        if (!this.skipCleanup) {
            super.cleanup(request);
        }
    }

    private boolean isRequestLoggedIn(HttpServletRequest request) {
        LoginTracker loginTracker = LoginTracker.getInstance();
        return request.getSession() != null && loginTracker.isSessionLoggedIn(request.getSession().getId());
    }

    private boolean isLicenseSizeValid(HttpServletRequest request) {
        return request.getContentLength() <= this.maxLicenseSize * 1024 * 1024;
    }
}

