/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.fsm.state.impl.CertListState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.page.ValidatePage;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.xmlbeans.impl.util.HexBin;

public class CertDetailsPopUp
extends ValidatePage
implements IExternalPage {
    private String alias;
    private String serialNum;
    private String issuerDN;
    private String subjectDN;
    private String subjectAlternativeNames;
    private Date validFrom;
    private Date validUntil;
    private String sigAlgName;
    private Integer version;
    private X509Certificate x509;
    private boolean revoked;
    private String keyDetails;

    public boolean isRevoked() {
        return this.revoked;
    }

    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        Integer index = (Integer)params[0];
        Tasklet tasklet = this.getPingVisit().getCurrentTasklet();
        CertListState certListState = (CertListState)((Object)tasklet.getCurrentState());
        Cert cert = certListState.getCert(index);
        this.x509 = cert.getX509Certificate();
        this.alias = cert.getAlias();
        this.serialNum = cert.getSerialNumberForDisplay();
        this.subjectDN = this.x509.getSubjectDN().getName();
        try {
            this.subjectAlternativeNames = cert.getX509CertificateSubjectAlternativeNames().stream().collect(Collectors.joining(", "));
        }
        catch (CertificateParsingException e) {
            this.subjectAlternativeNames = "(ERROR)";
        }
        this.issuerDN = this.x509.getIssuerDN().getName();
        this.validFrom = this.x509.getNotBefore();
        this.validUntil = this.x509.getNotAfter();
        this.sigAlgName = this.x509.getSigAlgName();
        this.version = this.x509.getVersion();
        this.revoked = CertificateHelper.isKnownToBeRevoked((Cert)cert);
        this.keyDetails = this.retrieveKeyDetails(cert);
    }

    public X509Certificate getX509() {
        return this.x509;
    }

    public void setX509(X509Certificate x509) {
        this.x509 = x509;
    }

    public String getFingerprintSHA1() {
        return this.getFingerprint("SHA1");
    }

    public String getFingerprintSHA256() {
        return this.getFingerprint("SHA-256");
    }

    private String getFingerprint(String algo) {
        String fingerprint;
        try {
            MessageDigest digester = MessageDigest.getInstance(algo);
            byte[] digest = digester.digest(this.x509.getEncoded());
            fingerprint = HexBin.bytesToString((byte[])digest);
        }
        catch (GeneralSecurityException e) {
            fingerprint = "(ERROR)";
        }
        return fingerprint;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public void setSigAlgName(String sigAlgName) {
        this.sigAlgName = sigAlgName;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public String getSerialNum() {
        return this.serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public String getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(String subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    private String retrieveKeyDetails(Cert cert) {
        String keySize = cert.getPublicKeySize() == null ? "" : cert.getPublicKeySize().toString();
        return cert.getPublicKeyAlgorithm() + " " + keySize;
    }

    public String getKeyDetails() {
        return this.keyDetails;
    }
}

