/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.InUsePopUp;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.OidcJwksSet;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.AdminSslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class CertificateInUsePopUp
extends InUsePopUp {
    private final List<InUseItem> serverUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> accessTokenManagementUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> adapterSelectorsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> jwksEndpoint = new LinkedList<InUseItem>();
    private final List<InUseItem> tokenSigningKeySets = new LinkedList<InUseItem>();
    private final List<InUseItem> dataSourcesUsingResource = new LinkedList<InUseItem>();

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        super.activateExternalPage(objs, cycle);
        this.loadClientManagerUsingResource();
        this.loadServerUsingResource();
        this.loadAccessTokenManagementUsingResourceUsingCert();
        this.loadAdapterSelectorsUsingResource();
        this.loadJwksEndpointUsingResource();
        this.loadClientSettingsUsingResource();
        this.loadTokenSigningKeySetsUsingResource();
        this.loadDataSourcesUsingResource();
    }

    private void loadTokenSigningKeySetsUsingResource() {
        List keySets;
        this.tokenSigningKeySets.clear();
        if (StringUtils.isNotBlank((String)this.id) && !(keySets = MgmtFactory.getJWKSSigningKeySetsManager().getAllKeySets()).isEmpty()) {
            for (JwksSigningInstanceSettings keySet : keySets) {
                OidcJwksSet oidcKeySet = keySet.getOidcJWKSSigningKeySet();
                if (oidcKeySet == null || !oidcKeySet.getActiveIds().contains(this.id) && !oidcKeySet.getPreviousIds().contains(this.id)) continue;
                InUseItem item = new InUseItem(keySet.getName(), keySet.getId());
                this.tokenSigningKeySets.add(item);
            }
        }
    }

    @Override
    protected void loadServerSettingsUsingResource() {
        this.serverSettingsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id) && InUseDetectionUtil.getInstance().isCertUsedInServerSettings(this.id)) {
            InUseItem item = new InUseItem("Metadata Signing");
            this.serverSettingsUsingResource.add(item);
        }
    }

    private void loadJwksEndpointUsingResource() {
        this.jwksEndpoint.clear();
        if (StringUtils.isNotBlank((String)this.id) && InUseDetectionUtil.getInstance().isDsigCertInUse(this.id)) {
            Set previousIds;
            Set activeIds = MgmtFactory.getJWKSEndpointManager().getSetting().getActiveIds();
            if (activeIds.contains(this.id)) {
                InUseItem item = new InUseItem("Active Cert");
                this.jwksEndpoint.add(item);
            }
            if ((previousIds = MgmtFactory.getJWKSEndpointManager().getSetting().getPreviousIds()).contains(this.id)) {
                InUseItem item = new InUseItem("Previous Cert");
                this.jwksEndpoint.add(item);
            }
        }
    }

    private void loadClientManagerUsingResource() {
        this.clientManagerUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            SslServerPkCertManager sslServerPcm;
            PkCert sslServerCert;
            LinkedList<Client> clients = new LinkedList<Client>();
            InUseDetectionUtil inUseDetectionUtil = InUseDetectionUtil.getInstance();
            TrustedCAsManager tcm = MgmtFactory.getTrustedCAsManager();
            X509Certificate cert = tcm.getTrustedCaX509(this.id);
            if (cert != null) {
                clients.addAll(inUseDetectionUtil.getClientsWithCertInUse(cert));
            }
            if ((sslServerCert = (sslServerPcm = MgmtFactory.getSslServerPkCertManager()).getPkCert(this.id)) != null) {
                List filteredSslCertClients = inUseDetectionUtil.getClientsWithCertInUse(sslServerCert.getX509Certificate()).stream().filter(sslClient -> clients.stream().noneMatch(client -> sslClient.getClientId() != null && sslClient.getClientId().equals(client.getClientId()))).collect(Collectors.toList());
                clients.addAll(filteredSslCertClients);
            }
            this.clientManagerUsingResource.addAll(this.convertClientToInUseItems(clients));
        }
    }

    private void loadClientSettingsUsingResource() {
        TrustedCAsManager tcm;
        X509Certificate cert;
        this.clientSettingUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id) && (cert = (tcm = MgmtFactory.getTrustedCAsManager()).getTrustedCaX509(this.id)) != null) {
            this.checkDynamicClientDefaultsSettingsForInUse(cert);
        }
    }

    private void checkDynamicClientDefaultsSettingsForInUse(X509Certificate cert) {
        boolean isCertInUseClientRegIssuerDefault = InUseDetectionUtil.getInstance().isCertInUseClientRegIssuerDefault(cert);
        if (isCertInUseClientRegIssuerDefault) {
            this.clientSettingUsingResource.add(new InUseItem("Client Configuration Defaults", "Client Configuration Defaults"));
        }
    }

    private void loadServerUsingResource() {
        SslServerPkCertManager sslServerPcm;
        PkCert cert;
        this.serverUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id) && (cert = (sslServerPcm = MgmtFactory.getSslServerPkCertManager()).getPkCert(this.id)) != null) {
            Set activeCerts = sslServerPcm.getActiveServerPkCerts();
            for (PkCert activeCert : activeCerts) {
                if (!cert.equals((Object)activeCert)) continue;
                InUseItem item = new InUseItem("Active For Runtime");
                this.serverUsingResource.add(item);
            }
            AdminSslServerPkCertManager adminSslServerPcm = MgmtFactory.getAdminSslServerPkCertManager();
            Set activeAdminCerts = adminSslServerPcm.getActiveServerPkCerts();
            for (PkCert activeAdminCert : activeAdminCerts) {
                if (!cert.equals((Object)activeAdminCert)) continue;
                InUseItem item = new InUseItem("Active for Admin Console");
                this.serverUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadIdpConnectionsUsingResource() {
        this.idpConnectionsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            PkCertManager mgr = MgmtFactory.getDsigPkCertManager();
            this.checkCertAgainstIdpConnections((Cert)mgr.getPkCert(this.id));
            mgr = MgmtFactory.getSslAuthPkCertManager();
            this.checkCertAgainstIdpConnections((Cert)mgr.getPkCert(this.id));
        }
    }

    private void checkCertAgainstIdpConnections(Cert cert) {
        if (cert != null) {
            List idpConnections = InUseDetectionUtil.getInstance().getIdpConnectionsWithCertInUse(cert);
            for (IdpConnection idpConnection : idpConnections) {
                String name = idpConnection.getName();
                if (this.currentItemsContains(name, this.idpConnectionsUsingResource)) continue;
                InUseItem item = new InUseItem(name, idpConnection.getEntityId());
                this.idpConnectionsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadSpConnectionsUsingResource() {
        this.spConnectionsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            PkCertManager mgr = MgmtFactory.getDsigPkCertManager();
            this.checkCertAgainstSpConnections((Cert)mgr.getPkCert(this.id));
            mgr = MgmtFactory.getSslAuthPkCertManager();
            this.checkCertAgainstSpConnections((Cert)mgr.getPkCert(this.id));
        }
    }

    private void checkCertAgainstSpConnections(Cert cert) {
        if (cert != null) {
            List spConnections = InUseDetectionUtil.getInstance().getSpConnectionsWithCertInUse(cert);
            for (SpConnection spConnection : spConnections) {
                String name = spConnection.getName();
                if (this.currentItemsContains(name, this.spConnectionsUsingResource)) continue;
                InUseItem item = new InUseItem(name, spConnection.getEntityId());
                this.spConnectionsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadIdpAdaptersUsingResource() {
        this.idpAdaptersUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getIdpAdaptersWithCertInUse(this.id)) {
                String instanceId;
                String name = instance.getName();
                if (this.currentItemsContains(name, instanceId = instance.getId(), this.idpAdaptersUsingResource)) continue;
                InUseItem item = new InUseItem(name, instanceId);
                this.idpAdaptersUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadSpAdaptersUsingResource() {
        this.spAdaptersUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getSpAdaptersWithCertInUse(this.id)) {
                String instanceId;
                String name = instance.getName();
                if (this.currentItemsContains(name, instanceId = instance.getId(), this.spAdaptersUsingResource)) continue;
                InUseItem item = new InUseItem(name, instanceId);
                this.spAdaptersUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadTokenGeneratorsUsingResource() {
        this.tokenGeneratorsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getTokenGeneratorsWithCertInUse(this.id)) {
                String instanceId;
                String name = instance.getName();
                if (this.currentItemsContains(name, instanceId = instance.getId(), this.tokenGeneratorsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instanceId);
                this.tokenGeneratorsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadTokenProcessorsUsingResource() {
        this.tokenProcessorsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getTokenProcessorsWithCertInUse(this.id)) {
                String instanceId;
                String name = instance.getName();
                if (this.currentItemsContains(name, instanceId = instance.getId(), this.tokenProcessorsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instanceId);
                this.tokenProcessorsUsingResource.add(item);
            }
        }
    }

    private void loadAdapterSelectorsUsingResource() {
        this.adapterSelectorsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getAdapterSelectorInstancesWithCertInUse(this.id)) {
                String name = instance.getName();
                if (this.currentItemsContains(name, this.adapterSelectorsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.adapterSelectorsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadPCVsUsingResource() {
        this.pcvsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getCredentialValidatorInstancesWithCertInUse(this.id)) {
                String name = instance.getName();
                if (this.currentItemsContains(name, this.pcvsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.pcvsUsingResource.add(item);
            }
        }
    }

    private void loadAccessTokenManagementUsingResourceUsingCert() {
        this.accessTokenManagementUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getBearerAccessTokenMgmtPluginsWithCertInUse(this.id)) {
                InUseItem item = new InUseItem(instance.getName());
                this.accessTokenManagementUsingResource.add(item);
            }
        }
    }

    private void loadDataSourcesUsingResource() {
        this.dataSourcesUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (DataSource dataSourceInstance : InUseDetectionUtil.getInstance().getDataSourcesWithCertInUse(this.id)) {
                String dsName = dataSourceInstance instanceof CustomDataSource ? dataSourceInstance.getDescription() : dataSourceInstance.getDsName();
                InUseItem item = new InUseItem(dsName, dataSourceInstance.getId());
                this.dataSourcesUsingResource.add(item);
            }
        }
    }

    public boolean isShowAccessTokenManagementUsingResource() {
        return !this.accessTokenManagementUsingResource.isEmpty();
    }

    public boolean isShowServerUsingResource() {
        return !this.serverUsingResource.isEmpty();
    }

    public boolean isShowAdapterSelectorsUsingResource() {
        return !this.adapterSelectorsUsingResource.isEmpty();
    }

    @Override
    public boolean isShowOauthManagersUsingResource() {
        return this.isShowClientManagerUsingResource() || this.isShowAccessTokenManagementUsingResource();
    }

    public List<InUseItem> getAccessTokenManagementUsingResource() {
        return this.accessTokenManagementUsingResource;
    }

    public List<InUseItem> getServerUsingResource() {
        return this.serverUsingResource;
    }

    public List<InUseItem> getAdapterSelectorsUsingResource() {
        return this.adapterSelectorsUsingResource;
    }

    public boolean isShowJwksEndpointUsingResource() {
        return !this.jwksEndpoint.isEmpty();
    }

    public List<InUseItem> getJwksEndpointUsingResource() {
        return this.jwksEndpoint;
    }

    public boolean isShowTokenSigningKeySetsUsingResource() {
        return !this.tokenSigningKeySets.isEmpty();
    }

    public List<InUseItem> getTokenSigningKeySetsUsingResource() {
        return this.tokenSigningKeySets;
    }

    public boolean isDataSourcesUsingResource() {
        return !this.dataSourcesUsingResource.isEmpty();
    }

    public List<InUseItem> getDataSourcesUsingResource() {
        return this.dataSourcesUsingResource;
    }
}

