/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.InUsePopUp;
import java.util.LinkedList;
import java.util.List;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.TargetSessionId;

public class ConnectionInUsePopUp
extends InUsePopUp {
    private final List<InUseItem> spAffiliationsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> dnToIdpMappingsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> targetUrlUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> authnSelectionTreesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> authnSelectorsUsingResource = new LinkedList<InUseItem>();
    private ConnectionBase connection;

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        String role;
        this.spAffiliationsUsingResource.clear();
        this.dnToIdpMappingsUsingResource.clear();
        this.targetUrlUsingResource.clear();
        this.authnSelectionTreesUsingResource.clear();
        this.authnSelectorsUsingResource.clear();
        super.activateExternalPage(objs, cycle);
        switch (role = (String)objs[1]) {
            case "SP": {
                this.connection = MgmtFactory.getConnectionManager().getSpConnectionBySystemId(this.id);
                this.loadSpAffiliationsUsingResource();
                this.loadTargetUrlUsingResource();
                break;
            }
            case "IdP": {
                this.connection = MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(this.id);
                this.loadDNtoIdpMappings();
                this.loadAuthnSelectionTreesUsingResource();
                this.loadAuthnSelectorsUsingResource();
                break;
            }
            default: {
                throw new RuntimeException("invalid role parameter: " + role);
            }
        }
    }

    private void loadSpAffiliationsUsingResource() {
        for (Affiliation affiliation : InUseDetectionUtil.getInstance().getSpAffiliationsWithInstanceInUse(this.connection.getEntityId())) {
            InUseItem item = new InUseItem(affiliation.getAffiliationId());
            this.spAffiliationsUsingResource.add(item);
        }
    }

    private void loadDNtoIdpMappings() {
        List dnList = InUseDetectionUtil.getInstance().getDNWithIdpConnectionInUse((IdpConnection)this.connection);
        for (String dn : dnList) {
            InUseItem item = new InUseItem(dn);
            this.dnToIdpMappingsUsingResource.add(item);
        }
    }

    private void loadTargetUrlUsingResource() {
        LocalSettingsManager localSettingsMgr;
        List urlToAdapterMapping;
        if (this.connection.getRoleType() == Role.SP && (urlToAdapterMapping = (localSettingsMgr = MgmtFactory.getLocalSettingsManager()).getUrlToAdapterMapping().getMappings()) != null) {
            for (UrlToTargetMapping targetUrlItem : urlToAdapterMapping) {
                String name;
                String sysId = targetUrlItem.getTargetId();
                TargetSessionId.TargetSessionType targetType = targetUrlItem.getTargetType();
                if (targetType != TargetSessionId.TargetSessionType.SP_CONN || !sysId.equals(this.id) || this.currentItemsContains(name = targetUrlItem.getUrl(), this.targetUrlUsingResource)) continue;
                InUseItem item = new InUseItem(name);
                this.targetUrlUsingResource.add(item);
            }
        }
    }

    private void loadAuthnSelectionTreesUsingResource() {
        if (this.connection.getRoleType() == Role.IDP) {
            List trees = InUseDetectionUtil.getInstance().getAuthnSelectionTreesWithConnectionInUse(this.id);
            for (AuthnSelectionTree tree : trees) {
                String name = this.getNameForAuthnSelectionTree(tree);
                if (this.currentItemsContains(name, this.authnSelectionTreesUsingResource)) continue;
                InUseItem item = new InUseItem(name);
                this.authnSelectionTreesUsingResource.add(item);
            }
            if (InUseDetectionUtil.getInstance().isDefaultConnectionForAuthnSelection(this.id)) {
                InUseItem item = new InUseItem("Default Authentication Source");
                this.authnSelectionTreesUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadFragmentsUsingResource() {
        this.fragmentsUsingResource.clear();
        List fragments = InUseDetectionUtil.getInstance().getFragmentsWithConnectionInUse(this.id);
        for (PolicyFragment fragment : fragments) {
            String name = fragment.getName();
            if (this.currentItemsContains(name, this.fragmentsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.fragmentsUsingResource.add(item);
        }
    }

    private void loadAuthnSelectorsUsingResource() {
        for (AuthnSelectorInstance selector : MgmtFactory.getAuthnSelectorManager().getSelectorsUsingAuthnSource((AuthnSourceKey)new IdpConnAuthnSourceKey(this.id))) {
            this.authnSelectorsUsingResource.add(new InUseItem(selector.getName(), selector.getId()));
        }
    }

    public boolean isShowSpAffiliationsUsingResource() {
        return this.connection.getRoleType() == Role.SP && !this.spAffiliationsUsingResource.isEmpty();
    }

    public boolean isShowDNtoIdpMappings() {
        return this.connection.getRoleType() == Role.IDP && !this.dnToIdpMappingsUsingResource.isEmpty();
    }

    public boolean isShowTargetUrlUsingResource() {
        return !this.targetUrlUsingResource.isEmpty();
    }

    public boolean isShowAuthnSelectionTreesUsingResource() {
        return !this.authnSelectionTreesUsingResource.isEmpty();
    }

    public boolean isShowAuthnSelectorsUsingResource() {
        return !this.authnSelectorsUsingResource.isEmpty();
    }

    public List<InUseItem> getSpAffiliationsUsingResource() {
        return this.spAffiliationsUsingResource;
    }

    public List<InUseItem> getDnToIdpMappingsUsingResource() {
        return this.dnToIdpMappingsUsingResource;
    }

    public List<InUseItem> getTargetUrlUsingResource() {
        return this.targetUrlUsingResource;
    }

    public List<InUseItem> getAuthnSelectionTreesUsingResource() {
        return this.authnSelectionTreesUsingResource;
    }

    public List<InUseItem> getAuthnSelectorsUsingResource() {
        return this.authnSelectorsUsingResource;
    }
}

