/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.fsm.state.impl.SelectDataSourceTypeState;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.page.InUsePopUp;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class DataSourceInUsePopUp
extends InUsePopUp {
    private final List<InUseItem> openIdConnectPoliciesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> accountLinkingServiceUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> accessGrantManagerUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> accessTokenMappingsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> token2TokenMappingsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> tokenExchangePoliciesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> tokenGeneratorMappingsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> kerberosRealmsUsingResource = new LinkedList<InUseItem>();
    private SelectDataSourceTypeState.DSType type;
    private final AccessGrantManager accessGrantManager;
    private final Apc2SpAdapterManager apc2SpAdapterManager;
    private final AuthnSelectionConfigManager authnSelectionConfigManager;
    private final AuthzServerManager authzServerManager;
    private final C2cContractManager c2cContractManager;
    private final ClientManager clientManager;
    private final ConnectionManager connectionManager;
    private final DataSourceManager dataSourceManager;
    private final KerberosRealmManager kerberosRealmManager;
    private final LocalIdentityManager localIdentityManager;
    private final PolicyFragmentManager policyFragmentManager;
    private final ProcessorPolicy2TokenGeneratorManager processorPolicy2TokenGeneratorManager;
    private final TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager;

    public DataSourceInUsePopUp() {
        this(MgmtFactory.getAccessGrantManager(), MgmtFactory.getApc2SpAdapterManager(), MgmtFactory.getAuthnSelectionConfigManager(), MgmtFactory.getAuthzServerManager(), MgmtFactory.getC2cContractManager(), MgmtFactory.getClientManager(), MgmtFactory.getConnectionManager(), MgmtFactory.getDataSourceManager(), MgmtFactory.getKerberosRealmManager(), MgmtFactory.getLocalIdentityProfileManager(), MgmtFactory.getPolicyFragmentManager(), MgmtFactory.getProcessorPolicy2TokenGeneratorManager(), MgmtFactory.getTokenExchangeProcessorPolicyManager());
    }

    public DataSourceInUsePopUp(AccessGrantManager accessGrantManager, Apc2SpAdapterManager apc2SpAdapterManager, AuthnSelectionConfigManager authnSelectionConfigManager, AuthzServerManager authzServerManager, C2cContractManager c2cContractManager, ClientManager clientManager, ConnectionManager connectionManager, DataSourceManager dataSourceManager, KerberosRealmManager kerberosRealmManager, LocalIdentityManager localIdentityManager, PolicyFragmentManager policyFragmentManager, ProcessorPolicy2TokenGeneratorManager processorPolicy2TokenGeneratorManager, TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager) {
        this.accessGrantManager = accessGrantManager;
        this.apc2SpAdapterManager = apc2SpAdapterManager;
        this.authnSelectionConfigManager = authnSelectionConfigManager;
        this.authzServerManager = authzServerManager;
        this.c2cContractManager = c2cContractManager;
        this.clientManager = clientManager;
        this.connectionManager = connectionManager;
        this.dataSourceManager = dataSourceManager;
        this.kerberosRealmManager = kerberosRealmManager;
        this.localIdentityManager = localIdentityManager;
        this.policyFragmentManager = policyFragmentManager;
        this.processorPolicy2TokenGeneratorManager = processorPolicy2TokenGeneratorManager;
        this.tokenExchangeProcessorPolicyManager = tokenExchangeProcessorPolicyManager;
    }

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        this.type = (SelectDataSourceTypeState.DSType)((Object)objs[1]);
        super.activateExternalPage(objs, cycle);
        this.loadSpConnectionModules();
        this.loadAccessGrantManagerUsingResource();
        this.loadClientManagerUsingResource();
        this.loadSessionStorageManagersUsingResource();
        this.loadAccountLinkingServiceUsingResource();
        this.loadOpenIdConnectPoliciesUsingResource();
        this.loadAccessTokenMappingsUsingResource();
        this.loadToken2TokenMappingsUsingResource();
        this.loadResourceOwnerCredentialMappingsUsingResource();
        this.loadAuthnPoliciesUsingResource();
        this.loadTeppUsingResource();
        this.loadTokenGeneratorMappingsUsingResource();
        this.loadKerberosRealmsUsingResource();
    }

    private void loadKerberosRealmsUsingResource() {
        List items = this.kerberosRealmManager.getKerberosRealms().stream().filter(KerberosRealm::isLdapGatewayConnection).filter(kerberosRealm -> this.id != null && this.id.equals(kerberosRealm.getLdapGatewayDatastoreId())).map(realm -> new InUseItem(realm.getKerberosRealmName())).collect(Collectors.toList());
        this.kerberosRealmsUsingResource.clear();
        this.kerberosRealmsUsingResource.addAll(items);
    }

    private void loadTokenGeneratorMappingsUsingResource() {
        List items = this.processorPolicy2TokenGeneratorManager.getMappingsUsingDataSource(this.id).stream().map(mapping -> new InUseItem(mapping.buildMappingName())).collect(Collectors.toList());
        this.tokenGeneratorMappingsUsingResource.clear();
        this.tokenGeneratorMappingsUsingResource.addAll(items);
    }

    private void loadTeppUsingResource() {
        List items = this.tokenExchangeProcessorPolicyManager.getPoliciesUsingDataSource(this.id).stream().map(policy -> new InUseItem(policy.getName())).collect(Collectors.toList());
        this.tokenExchangePoliciesUsingResource.clear();
        this.tokenExchangePoliciesUsingResource.addAll(items);
    }

    private void loadOpenIdConnectPoliciesUsingResource() {
        this.openIdConnectPoliciesUsingResource.clear();
        List policyGroups = InUseDetectionUtil.getInstance().getOpenIdConnectPolicyGroupsWithDSInUse(this.id);
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policyGroups) {
            String name = policyGroup.getName();
            if (this.currentItemsContains(name, this.openIdConnectPoliciesUsingResource)) continue;
            InUseItem item = new InUseItem(name, policyGroup.getPolicyId());
            this.openIdConnectPoliciesUsingResource.add(item);
        }
    }

    @Override
    protected void loadCibaRequestHandlingPoliciesUsingResource() {
        this.cibaRequestHandlingPoliciesUsingResource.clear();
        List policies = InUseDetectionUtil.getInstance().getCibaRequestHandlingPoliciesWithDSInUse(this.id);
        for (CibaServerPolicy.RequestHandlingPolicy policy : policies) {
            String name = policy.getName();
            if (this.currentItemsContains(name, this.cibaRequestHandlingPoliciesUsingResource)) continue;
            InUseItem item = new InUseItem(name, policy.getId());
            this.cibaRequestHandlingPoliciesUsingResource.add(item);
        }
    }

    @Override
    protected void loadIdpConnectionsUsingResource() {
        this.idpConnectionsUsingResource.clear();
        List idpConnections = InUseDetectionUtil.getInstance().getIdpConnectionsWithDSInUse(this.id);
        for (IdpConnection idpConnection : idpConnections) {
            String name = idpConnection.getName();
            if (this.currentItemsContains(name, this.idpConnectionsUsingResource)) continue;
            InUseItem item = new InUseItem(idpConnection.getName(), idpConnection.getEntityId());
            this.idpConnectionsUsingResource.add(item);
        }
    }

    @Override
    protected void loadSpConnectionsUsingResource() {
        this.spConnectionsUsingResource.clear();
        List spConnections = InUseDetectionUtil.getInstance().getSpConnectionsWithDSInUse(this.id);
        for (SpConnection spConnection : spConnections) {
            String name = spConnection.getName();
            if (this.currentItemsContains(name, this.spConnectionsUsingResource)) continue;
            InUseItem item = new InUseItem(name, spConnection.getEntityId());
            this.spConnectionsUsingResource.add(item);
        }
    }

    private void loadSpConnectionModules() {
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        Collection spConnections = this.connectionManager.getAllSpConnections();
        for (SpConnection sp : spConnections) {
            ProvisionerConfig provConfig = (ProvisionerConfig)sp.getModuleConfiguration(ProvisionerConfig.class);
            if (provConfig == null) continue;
            List configurations = moduleSupport.getConfigurations(sp.getEntityId(), Role.SP);
            for (ConnectionModuleConfiguration configuration : configurations) {
                String moduleId = configuration.getModuleId();
                if (!moduleId.equals(provConfig.getModuleId())) continue;
                for (String dataSourceId : provConfig.getDataSourceIdsInUse()) {
                    String name;
                    if (!this.id.equals(dataSourceId) || this.currentItemsContains(name = sp.getName(), this.spConnectionsUsingResource)) continue;
                    InUseItem item = new InUseItem(name, sp.getEntityId());
                    this.spConnectionsUsingResource.add(item);
                }
            }
        }
    }

    @Override
    protected void loadServerSettingsUsingResource() {
        InUseItem item;
        String serverSettingsDescription = "Outbound Provisioning";
        this.serverSettingsUsingResource.clear();
        DataSource ds = this.getDataSource(this.id);
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        ConnectionModuleManager moduleManager = moduleSupport.getManager(ProvisionerConfig.class, Role.SP);
        if (moduleManager != null && moduleManager.isInternalDataSource(ds) && !this.currentItemsContains(serverSettingsDescription, this.serverSettingsUsingResource)) {
            item = new InUseItem(serverSettingsDescription);
            this.serverSettingsUsingResource.add(item);
        }
        if ((moduleManager = moduleSupport.getManager(ProvisionerConfig.class, Role.IDP)) != null && moduleManager.isInternalDataSource(ds) && !this.currentItemsContains(serverSettingsDescription, this.serverSettingsUsingResource)) {
            item = new InUseItem(serverSettingsDescription);
            this.serverSettingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadIdpAdaptersUsingResource() {
        this.idpAdaptersUsingResource.clear();
        List idpAdapters = InUseDetectionUtil.getInstance().getIdpAdaptersWithDSInUse(this.id);
        this.addInUseAdapters(idpAdapters);
    }

    @Override
    protected void loadSpAdaptersUsingResource() {
        this.spAdaptersUsingResource.clear();
        List spAdapters = InUseDetectionUtil.getInstance().getSpAdaptersWithDSInUse(this.id);
        for (AuthnAdapterInstance instance : spAdapters) {
            String instanceId;
            String name = instance.getName();
            if (this.currentItemsContains(name, instanceId = instance.getId(), this.spAdaptersUsingResource)) continue;
            InUseItem item = new InUseItem(name, instanceId);
            this.spAdaptersUsingResource.add(item);
        }
    }

    @Override
    protected void loadTokenGeneratorsUsingResource() {
        this.tokenGeneratorsUsingResource.clear();
        List tokenGenerators = InUseDetectionUtil.getInstance().getTokenPluginsWithDSInUseString(this.id, TokenGeneratorManager.class);
        for (ConfigurablePluginInstance instance : tokenGenerators) {
            String instanceId;
            String name = instance.getName();
            if (this.currentItemsContains(name, instanceId = instance.getId(), this.tokenGeneratorsUsingResource)) continue;
            InUseItem item = new InUseItem(name, instanceId);
            this.tokenGeneratorsUsingResource.add(item);
        }
    }

    @Override
    protected void loadTokenProcessorsUsingResource() {
        this.tokenProcessorsUsingResource.clear();
        List tokenProcessors = InUseDetectionUtil.getInstance().getTokenPluginsWithDSInUseString(this.id, TokenProcessorManager.class);
        for (ConfigurablePluginInstance instance : tokenProcessors) {
            String instanceId;
            String name = instance.getName();
            if (this.currentItemsContains(name, instanceId = instance.getId(), this.tokenProcessorsUsingResource)) continue;
            InUseItem item = new InUseItem(name, instanceId);
            this.tokenProcessorsUsingResource.add(item);
        }
    }

    @Override
    protected void loadAdapter2AdapterMappingsUsingResource() {
        this.adapter2AdapterMappingsUsingResource.clear();
        List mappings = InUseDetectionUtil.getInstance().getAdapter2AdapterMappingsWithDSInUse(this.id);
        for (Direct2SpAdapterMapping mapping : mappings) {
            String name = this.buildAdapter2AdapterMappingName((Source2TargetMapping)mapping);
            if (this.currentItemsContains(name, this.adapter2AdapterMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.adapter2AdapterMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadApc2SpAdapterMappingsUsingResource() {
        this.apc2SpAdapterMappingsUsingResource.clear();
        List mappings = this.apc2SpAdapterManager.getMappingsUsingDataSource(this.id);
        for (Direct2SpAdapterMapping mapping : mappings) {
            String name = this.buildApc2SpAdapterMappingName((Source2TargetMapping)mapping);
            if (this.currentItemsContains(name, this.apc2SpAdapterMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.apc2SpAdapterMappingsUsingResource.add(item);
        }
    }

    private void loadToken2TokenMappingsUsingResource() {
        this.token2TokenMappingsUsingResource.clear();
        List mappings = InUseDetectionUtil.getInstance().getToken2TokenMappingsWithDSInUse(this.id);
        for (Token2TokenMapping mapping : mappings) {
            String name = this.buildToken2TokenMappingName(mapping);
            if (this.currentItemsContains(name, this.token2TokenMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.token2TokenMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadPCVsUsingResource() {
        this.pcvsUsingResource.clear();
        List instances = InUseDetectionUtil.getInstance().getPCVsWithDSInUse(this.id);
        for (ConfigurablePluginInstance instance : instances) {
            String instanceId;
            String name = instance.getName();
            if (this.currentItemsContains(name, instanceId = instance.getId(), this.pcvsUsingResource)) continue;
            InUseItem item = new InUseItem(name, instanceId);
            this.pcvsUsingResource.add(item);
        }
    }

    @Override
    protected void loadResourceOwnerCredentialMappingsUsingResource() {
        this.resourceOwnerCredentialMappingsUsingResource.clear();
        Map mappings = this.authzServerManager.getValidatorIdToUserKeyMappingsWithDSInUse(this.id);
        for (Map.Entry m : mappings.entrySet()) {
            String name = this.buildResourceOwnerMappingName((String)m.getKey());
            if (this.currentItemsContains(name, this.resourceOwnerCredentialMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.resourceOwnerCredentialMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadIdpAdapterMappingsUsingResource() {
        this.oauthIdpAdapterToUserKeyMappingsUsingResource.clear();
        Map mappings = this.authzServerManager.getAdapterIdToUserKeyMappingsWithDSInUse(this.id);
        for (Map.Entry m : mappings.entrySet()) {
            String name = this.buildIdpAdapterMappingName((String)m.getKey());
            if (this.currentItemsContains(name, this.oauthIdpAdapterToUserKeyMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.oauthIdpAdapterToUserKeyMappingsUsingResource.add(item);
        }
    }

    private void loadAuthnPoliciesUsingResource() {
        this.authnPoliciesUsingResource.clear();
        List authnSelectionTrees = this.authnSelectionConfigManager.getAuthnSelectionTrees();
        for (AuthnSelectionTree tree : authnSelectionTrees) {
            ArrayList<String> inUseAuthnPolicyPaths = new ArrayList<String>();
            this.loadInUseAuthnPolicyPaths((Tree.Node<AuthnSelectionAction>)tree.getRootNode(), "", inUseAuthnPolicyPaths);
            for (String inUsePath : inUseAuthnPolicyPaths) {
                this.authnPoliciesUsingResource.add(new InUseItem(tree.getName(), inUsePath));
            }
        }
    }

    private void loadInUseAuthnPolicyPaths(Tree.Node<AuthnSelectionAction> root, String basePath, List<String> inUseAuthnPolicyPaths) {
        if (root != null) {
            LocalIdentityMappingAction mappingAction;
            boolean inUse;
            String nodeId = this.getNodeId(root);
            if (nodeId != null) {
                this.loadInUseAuthnPolicyPathsForFragmentMapping(root, basePath, inUseAuthnPolicyPaths);
                for (Tree.Node child : root.getChildren()) {
                    this.loadInUseAuthnPolicyPaths((Tree.Node<AuthnSelectionAction>)child, (String)("".equals(basePath) ? "" : basePath + " -> ") + nodeId, inUseAuthnPolicyPaths);
                }
            } else if (root.getData() instanceof ApcMappingAction) {
                ApcMappingAction mappingAction2 = (ApcMappingAction)root.getData();
                boolean inUse2 = mappingAction2.getAttributeMapping().getAttributeSources().stream().anyMatch(source -> source.getDataSourceId().equals(this.id));
                if (inUse2) {
                    inUseAuthnPolicyPaths.add(basePath + " -> " + this.c2cContractManager.getContract(mappingAction2.getApcId()).getName() + " mapping");
                }
            } else if (root.getData() instanceof LocalIdentityMappingAction && (inUse = Stream.concat((mappingAction = (LocalIdentityMappingAction)root.getData()).getAttributeMapping().getAttributeSources().stream(), Stream.concat(mappingAction.getInboundAttributeMapping().getAttributeSources().stream(), mappingAction.getOutboundAttributeMapping().getAttributeSources().stream())).anyMatch(attributeSource -> attributeSource.getDataSourceId().equals(this.id)))) {
                inUseAuthnPolicyPaths.add(basePath + " -> " + this.localIdentityManager.getProfile(mappingAction.getLipId()).getName() + " mapping");
            }
        }
    }

    private void loadInUseAuthnPolicyPathsForFragmentMapping(Tree.Node<AuthnSelectionAction> root, String basePath, List<String> inUseAuthnPolicyPaths) {
        FragmentAction mappingAction;
        boolean inUse;
        if (root.getData() instanceof FragmentAction && (inUse = (mappingAction = (FragmentAction)root.getData()).getAttributeMapping().getAttributeSources().stream().anyMatch(source -> source.getDataSourceId().equals(this.id)))) {
            inUseAuthnPolicyPaths.add((String)("".equals(basePath) ? "" : basePath + " -> ") + this.policyFragmentManager.getFragment(mappingAction.getFragmentId()).getName() + " mapping");
        }
    }

    private String getNodeId(Tree.Node<AuthnSelectionAction> node) {
        if (node != null) {
            if (node.getData() instanceof AuthnSourceAction) {
                return ((AuthnSourceAction)node.getData()).getAuthnSourceKey().getId();
            }
            if (node.getData() instanceof AuthnSelectorAction) {
                return ((AuthnSelectorAction)node.getData()).getAuthnSelectorId();
            }
            if (node.getData() instanceof FragmentAction) {
                return ((FragmentAction)node.getData()).getFragmentId();
            }
        }
        return null;
    }

    @Override
    protected void loadFragmentsUsingResource() {
        this.fragmentsUsingResource.clear();
        List fragments = InUseDetectionUtil.getInstance().getFragmentsWithDataSourceInUse(this.id);
        for (PolicyFragment fragment : fragments) {
            String name = fragment.getName();
            if (this.currentItemsContains(name, this.fragmentsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.fragmentsUsingResource.add(item);
        }
    }

    private void loadAccessTokenMappingsUsingResource() {
        this.accessTokenMappingsUsingResource.clear();
        Map mappings = this.authzServerManager.getUserKeyToAccessTokenMappingsWithDSInUse(this.id);
        for (Map.Entry m : mappings.entrySet()) {
            String name = this.buildAccessTokenMappingName((String)m.getKey());
            if (this.currentItemsContains(name, this.accessTokenMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.accessTokenMappingsUsingResource.add(item);
        }
    }

    private void loadAccessGrantManagerUsingResource() {
        this.accessGrantManagerUsingResource.clear();
        if (this.accessGrantManager.isDataSourceInUse(this.id)) {
            InUseItem item = new InUseItem("OAuth Access Grant Manager");
            this.accessGrantManagerUsingResource.add(item);
        }
    }

    private void loadAccountLinkingServiceUsingResource() {
        this.accountLinkingServiceUsingResource.clear();
        if (((AccountLinkingService)GlobalRegistry.getService(AccountLinkingService.class)).isDataSourceInUse(this.id)) {
            InUseItem item = new InUseItem("Account Linking Service");
            this.accountLinkingServiceUsingResource.add(item);
        }
    }

    private void loadClientManagerUsingResource() {
        this.clientManagerUsingResource.clear();
        if (this.clientManager.isDataSourceInUse(this.id)) {
            InUseItem item = new InUseItem("OAuth Client Manager");
            this.clientManagerUsingResource.add(item);
        }
    }

    private void loadSessionStorageManagersUsingResource() {
        this.sessionStorageManagersUsingResource.clear();
        if (StateMgmtFactory.getSessionStorageManager().isDataSourceInUse(this.id)) {
            InUseItem item = new InUseItem("Session Storage Manager");
            this.sessionStorageManagersUsingResource.add(item);
        }
    }

    @Override
    protected void loadApcToUserKeyMappingsUsingResource() {
        this.oauthApcToUserKeyMappingsUsingResource.clear();
        Map mappings = this.authzServerManager.getApcToUserKeyMappingsWithDSInUse(this.id);
        for (Map.Entry m : mappings.entrySet()) {
            String name = this.buildApcToUserKeyName((String)m.getKey());
            if (this.currentItemsContains(name, this.oauthApcToUserKeyMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.oauthApcToUserKeyMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadTeppToUserKeyMappingsUsingResource() {
        this.oauthTeppToUserKeyMappingsUsingResource.clear();
        Map mappings = this.authzServerManager.getTeppToUserKeyMappingsWithDSInUse(this.id);
        for (Map.Entry m : mappings.entrySet()) {
            String name = this.buildTeppToUserKeyName((String)m.getKey());
            if (this.currentItemsContains(name, this.oauthTeppToUserKeyMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.oauthTeppToUserKeyMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadLocalIdentityProfilesUsingResource() {
        List policies = this.localIdentityManager.getProfiles();
        this.lipsUsingResource.clear();
        policies.forEach(policy -> {
            if (policy.getDataStoreConfig() != null && policy.getDataStoreConfig().getAttributeSource().getDataSourceId().equals(this.id) && !this.currentItemsContains(policy.getName(), this.lipsUsingResource)) {
                InUseItem item = new InUseItem(policy.getName(), policy.getId());
                this.lipsUsingResource.add(item);
            }
        });
    }

    public boolean isShowOpenIdConnectPoliciesUsingResource() {
        return !this.openIdConnectPoliciesUsingResource.isEmpty();
    }

    public boolean isShowTeppUsingResource() {
        return !this.tokenExchangePoliciesUsingResource.isEmpty();
    }

    public boolean isShowTokenExchangeMappingsUsingResource() {
        return !this.tokenGeneratorMappingsUsingResource.isEmpty();
    }

    public boolean isShowKerberosRealmUsingResource() {
        return !this.kerberosRealmsUsingResource.isEmpty();
    }

    @Override
    public boolean isShowOauthManagersUsingResource() {
        return this.isShowIdpAdapterMappingsUsingResource() || this.isShowApcToUserKeyMappingsUsingResource() || this.isShowTeppToUserKeyMappingsUsingResource() || this.isShowAccessTokenMappingsUsingResource() || this.isShowResourceOwnerCredentialMappingsUsingResource() || this.isShowAccessGrantManagerUsingResource() || this.isShowClientManagerUsingResource() || this.isShowOpenIdConnectPoliciesUsingResource() || this.isShowCibaRequestHandlingPoliciesUsingResource();
    }

    public boolean isShowAccessGrantManagerUsingResource() {
        return !this.accessGrantManagerUsingResource.isEmpty();
    }

    public boolean isShowAccountLinkingServiceUsingResource() {
        return !this.accountLinkingServiceUsingResource.isEmpty();
    }

    public boolean isShowAccessTokenMappingsUsingResource() {
        return !this.accessTokenMappingsUsingResource.isEmpty();
    }

    public boolean isShowToken2TokenMappingsUsingResource() {
        return !this.token2TokenMappingsUsingResource.isEmpty();
    }

    public List<InUseItem> getOpenIdConnectPoliciesUsingResource() {
        return this.openIdConnectPoliciesUsingResource;
    }

    public List<InUseItem> getAccessGrantManagerUsingResource() {
        return this.accessGrantManagerUsingResource;
    }

    public List<InUseItem> getPolicyContractsUsingResource() {
        return this.policyContractUsingResource;
    }

    @Override
    public List<InUseItem> getAccessTokenMappingsUsingResource() {
        return this.accessTokenMappingsUsingResource;
    }

    public List<InUseItem> getAccountLinkingServiceUsingResource() {
        return this.accountLinkingServiceUsingResource;
    }

    public List<InUseItem> getToken2TokenMappingsUsingResource() {
        return this.token2TokenMappingsUsingResource;
    }

    public List<InUseItem> getTokenExchangePoliciesUsingResource() {
        return this.tokenExchangePoliciesUsingResource;
    }

    public List<InUseItem> getTokenGeneratorMappingsUsingResource() {
        return this.tokenGeneratorMappingsUsingResource;
    }

    public List<InUseItem> getKerberosRealmsUsingResource() {
        return this.kerberosRealmsUsingResource;
    }

    private DataSource getDataSource(String id) {
        JdbcDataSource ds = null;
        switch (this.type) {
            case Database: {
                ds = this.dataSourceManager.getJdbcDataSource(id);
                break;
            }
            case LDAP: 
            case LDAP_GATEWAY: {
                ds = this.dataSourceManager.getLdapDataSource(id);
                break;
            }
            case Other: {
                ds = this.dataSourceManager.getCustomDataSource(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data source type: " + this.type);
            }
        }
        return ds;
    }
}

