/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.ValidatePage;
import com.pingidentity.util.documentation.DocumentationHelper;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.oauth20.domain.AbstractClientManagerImpl;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;

public abstract class InUsePopUp
extends ValidatePage
implements IExternalPage {
    private static final Log log = LogFactory.getLog(InUsePopUp.class);
    protected List<InUseItem> serverSettingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> idpConnectionsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> spConnectionsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> idpAdaptersUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> spAdaptersUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> tokenGeneratorsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> tokenProcessorsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> adapter2AdapterMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> apc2SpAdapterMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> pcvsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> resourceOwnerCredentialMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> oauthIdpAdapterToUserKeyMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> oauthApcToUserKeyMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> oauthTeppToUserKeyMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> clientManagerUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> sessionStorageManagersUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> clientSettingUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> accessTokenManagersUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> accessTokenMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> samlGrantMappingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> policyContractUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> lipsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> authnPoliciesUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> authnApiApplicationsSettingsUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> cibaRequestHandlingPoliciesUsingResource = new LinkedList<InUseItem>();
    protected List<InUseItem> mappingsUsingProcessorPolicy = new LinkedList<InUseItem>();
    protected List<InUseItem> clientsUsingProcessorPolicy = new LinkedList<InUseItem>();
    protected List<InUseItem> fragmentsUsingResource = new LinkedList<InUseItem>();
    protected String id;

    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        this.id = (String)objs[0];
        this.loadIdpConnectionsUsingResource();
        this.loadSpConnectionsUsingResource();
        this.loadIdpAdaptersUsingResource();
        this.loadSpAdaptersUsingResource();
        this.loadTokenGeneratorsUsingResource();
        this.loadTokenProcessorsUsingResource();
        this.loadAdapter2AdapterMappingsUsingResource();
        this.loadApc2SpAdapterMappingsUsingResource();
        this.loadPCVsUsingResource();
        this.loadResourceOwnerCredentialMappingsUsingResource();
        this.loadIdpAdapterMappingsUsingResource();
        this.loadApcToUserKeyMappingsUsingResource();
        this.loadTeppToUserKeyMappingsUsingResource();
        this.loadServerSettingsUsingResource();
        this.loadFragmentsUsingResource();
        this.loadPolicyContractUsingResource();
        this.loadLocalIdentityProfilesUsingResource();
        this.loadCibaRequestHandlingPoliciesUsingResource();
    }

    protected void loadServerSettingsUsingResource() {
    }

    protected void loadIdpConnectionsUsingResource() {
    }

    protected void loadSpConnectionsUsingResource() {
    }

    protected void loadIdpAdaptersUsingResource() {
    }

    protected void loadSpAdaptersUsingResource() {
    }

    protected void loadTokenGeneratorsUsingResource() {
    }

    protected void loadTokenProcessorsUsingResource() {
    }

    protected void loadAdapter2AdapterMappingsUsingResource() {
    }

    protected void loadApc2SpAdapterMappingsUsingResource() {
    }

    protected void loadPCVsUsingResource() {
    }

    protected void loadResourceOwnerCredentialMappingsUsingResource() {
    }

    protected void loadIdpAdapterMappingsUsingResource() {
    }

    protected void loadApcToUserKeyMappingsUsingResource() {
    }

    protected void loadTeppToUserKeyMappingsUsingResource() {
    }

    protected void loadPolicyContractUsingResource() {
    }

    protected void loadLocalIdentityProfilesUsingResource() {
    }

    protected void loadFragmentsUsingResource() {
    }

    protected void loadCibaRequestHandlingPoliciesUsingResource() {
    }

    protected void loadMappingsUsingProcessorPolicy() {
    }

    protected void loadClientsUsingProcessorPolicy() {
    }

    public boolean isShowOauthManagersUsingResource() {
        return false;
    }

    public boolean isShowServerSettingsUsingResource() {
        return !this.serverSettingsUsingResource.isEmpty();
    }

    public boolean isShowIdpConnectionsUsingResource() {
        return !this.idpConnectionsUsingResource.isEmpty();
    }

    public boolean isShowPolicyContractUsingResource() {
        return !this.policyContractUsingResource.isEmpty();
    }

    public boolean isShowSpConnectionsUsingResource() {
        return !this.spConnectionsUsingResource.isEmpty();
    }

    public boolean isShowIdpAdaptersUsingResource() {
        return !this.idpAdaptersUsingResource.isEmpty();
    }

    public boolean isShowSpAdaptersUsingResource() {
        return !this.spAdaptersUsingResource.isEmpty();
    }

    public boolean isShowTokenGeneratorsUsingResource() {
        return !this.tokenGeneratorsUsingResource.isEmpty();
    }

    public boolean isShowTokenProcessorsUsingResource() {
        return !this.tokenProcessorsUsingResource.isEmpty();
    }

    public boolean isShowAdapter2AdapterMappingsUsingResource() {
        return !this.adapter2AdapterMappingsUsingResource.isEmpty();
    }

    public boolean isShowApc2SpAdapterMappingsUsingResource() {
        return !this.apc2SpAdapterMappingsUsingResource.isEmpty();
    }

    public boolean isShowPCVsUsingResource() {
        return !this.pcvsUsingResource.isEmpty();
    }

    public boolean isShowResourceOwnerCredentialMappingsUsingResource() {
        return !this.resourceOwnerCredentialMappingsUsingResource.isEmpty();
    }

    public boolean isShowLocalIdentityProfilesUsingResource() {
        return !this.lipsUsingResource.isEmpty();
    }

    public boolean isShowAuthnPoliciesUsingResource() {
        return !this.authnPoliciesUsingResource.isEmpty();
    }

    public boolean isShowAuthnPoliciesSettingsUsingResource() {
        return !this.authnApiApplicationsSettingsUsingResource.isEmpty();
    }

    public boolean isShowIdpAdapterMappingsUsingResource() {
        return !this.oauthIdpAdapterToUserKeyMappingsUsingResource.isEmpty();
    }

    public boolean isShowApcToUserKeyMappingsUsingResource() {
        return !this.oauthApcToUserKeyMappingsUsingResource.isEmpty();
    }

    public boolean isShowTeppToUserKeyMappingsUsingResource() {
        return !this.oauthTeppToUserKeyMappingsUsingResource.isEmpty();
    }

    public boolean isShowClientManagerUsingResource() {
        return !this.clientManagerUsingResource.isEmpty();
    }

    public boolean isShowSessionStorageManagersUsingResource() {
        return !this.sessionStorageManagersUsingResource.isEmpty();
    }

    public boolean isShowClientSettingUsingResource() {
        return !this.clientSettingUsingResource.isEmpty();
    }

    public boolean isShowProvisionerDS() {
        return "ProvisionerDS".equals(this.id);
    }

    public boolean isShowCibaRequestHandlingPoliciesUsingResource() {
        return !this.cibaRequestHandlingPoliciesUsingResource.isEmpty();
    }

    public boolean isShowMappingsUsingProcessorPolicy() {
        return !this.mappingsUsingProcessorPolicy.isEmpty();
    }

    public boolean isShowClientsUsingProcessorPolicy() {
        return !this.clientsUsingProcessorPolicy.isEmpty();
    }

    public boolean isShowFragmentsUsingResource() {
        return !this.fragmentsUsingResource.isEmpty();
    }

    protected void addInUseAdapters(List<IdpAuthnAdapterInstance> idpAdapters) {
        for (IdpAuthnAdapterInstance instance : idpAdapters) {
            String instanceId;
            String name = instance.getName();
            if (this.currentItemsContains(name, instanceId = instance.getId(), this.idpAdaptersUsingResource)) continue;
            InUseItem item = new InUseItem(name, instanceId);
            this.idpAdaptersUsingResource.add(item);
        }
    }

    public List<InUseItem> getServerSettingsUsingResource() {
        return this.serverSettingsUsingResource;
    }

    public List<InUseItem> getIdpConnectionsUsingResource() {
        return this.idpConnectionsUsingResource;
    }

    public List<InUseItem> getPolicyContractUsingResource() {
        return this.policyContractUsingResource;
    }

    public List<InUseItem> getSpConnectionsUsingResource() {
        return this.spConnectionsUsingResource;
    }

    public List<InUseItem> getIdpAdaptersUsingResource() {
        return this.idpAdaptersUsingResource;
    }

    public List<InUseItem> getSpAdaptersUsingResource() {
        return this.spAdaptersUsingResource;
    }

    public List<InUseItem> getTokenGeneratorsUsingResource() {
        return this.tokenGeneratorsUsingResource;
    }

    public List<InUseItem> getTokenProcessorsUsingResource() {
        return this.tokenProcessorsUsingResource;
    }

    public List<InUseItem> getAdapter2AdapterMappingsUsingResource() {
        return this.adapter2AdapterMappingsUsingResource;
    }

    public List<InUseItem> getApc2SpAdapterMappingsUsingResource() {
        return this.apc2SpAdapterMappingsUsingResource;
    }

    public List<InUseItem> getPCVsUsingResource() {
        return this.pcvsUsingResource;
    }

    public List<InUseItem> getIdpAdapterMappingsUsingResource() {
        return this.oauthIdpAdapterToUserKeyMappingsUsingResource;
    }

    public List<InUseItem> getApcToUserKeyMappingsUsingResource() {
        return this.oauthApcToUserKeyMappingsUsingResource;
    }

    public List<InUseItem> getTeppToUserKeyMappingsUsingResource() {
        return this.oauthTeppToUserKeyMappingsUsingResource;
    }

    public List<InUseItem> getClientManagerUsingResource() {
        return this.clientManagerUsingResource;
    }

    public List<InUseItem> getSessionStorageManagersUsingResource() {
        return this.sessionStorageManagersUsingResource;
    }

    public List<InUseItem> getClientSettingUsingResource() {
        return this.clientSettingUsingResource;
    }

    public List<InUseItem> getAccessTokenManagersUsingResource() {
        return this.accessTokenManagersUsingResource;
    }

    public List<InUseItem> getAccessTokenMappingsUsingResource() {
        return this.accessTokenMappingsUsingResource;
    }

    public List<InUseItem> getSAMLGrantMappingsUsingResource() {
        return this.samlGrantMappingsUsingResource;
    }

    public List<InUseItem> getResourceOwnerCredentialMappingsUsingResource() {
        return this.resourceOwnerCredentialMappingsUsingResource;
    }

    public List<InUseItem> getLocalIdentityProfilesUsingResource() {
        return this.lipsUsingResource;
    }

    public List<InUseItem> getAuthnPoliciesUsingResource() {
        return this.authnPoliciesUsingResource;
    }

    public List<InUseItem> getAuthnApiAppSettingsUsingResource() {
        return this.authnApiApplicationsSettingsUsingResource;
    }

    public List<InUseItem> getCibaRequestHandlingPoliciesUsingResource() {
        return this.cibaRequestHandlingPoliciesUsingResource;
    }

    public List<InUseItem> getMappingsUsingProcessorPolicy() {
        return this.mappingsUsingProcessorPolicy;
    }

    public List<InUseItem> getClientsUsingProcessorPolicy() {
        return this.clientsUsingProcessorPolicy;
    }

    public List<InUseItem> getFragmentsUsingResource() {
        return this.fragmentsUsingResource;
    }

    protected boolean currentItemsContains(String name, List<InUseItem> currentItems) {
        for (InUseItem item : currentItems) {
            if (!name.equals(item.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean currentItemsContains(String name, String id, List<InUseItem> currentItems) {
        for (InUseItem item : currentItems) {
            if (!name.equals(item.getName()) || id == null || !id.equals(item.getId())) continue;
            return true;
        }
        return false;
    }

    protected String buildAdapter2AdapterMappingName(Source2TargetMapping mapping) {
        StringBuilder sb = new StringBuilder();
        IdpAuthnAdapterInstance idp = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(mapping.getSourceId());
        AuthnAdapterInstance sp = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(mapping.getTargetId());
        sb.append("'");
        sb.append(idp != null ? idp.getName() : mapping.getSourceId());
        sb.append("' to '");
        sb.append(sp != null ? sp.getName() : mapping.getTargetId());
        sb.append("'");
        return sb.toString();
    }

    protected String buildApc2SpAdapterMappingName(Source2TargetMapping mapping) {
        StringBuilder sb = new StringBuilder();
        C2cContract apc = MgmtFactory.getC2cContractManager().getContract(mapping.getSourceId());
        AuthnAdapterInstance sp = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(mapping.getTargetId());
        sb.append("'");
        sb.append(apc != null ? apc.getName() : mapping.getSourceId());
        sb.append("' to '");
        sb.append(sp != null ? sp.getName() : mapping.getTargetId());
        sb.append("'");
        return sb.toString();
    }

    protected String buildToken2TokenMappingName(Token2TokenMapping mapping) {
        TokenPluginSupport tokenPluginSupport = new TokenPluginSupport();
        TokenProcessorInstance processorInstance = tokenPluginSupport.getProcessorInstanceFromId(mapping.getSourceId());
        TokenGeneratorInstance generatorInstance = tokenPluginSupport.getGeneratorInstanceFromId(mapping.getTargetId(), "");
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(processorInstance != null ? processorInstance.getName() : mapping.getSourceId());
        sb.append("' to '");
        sb.append(generatorInstance != null ? generatorInstance.getName() : mapping.getTargetId());
        sb.append("'");
        return sb.toString();
    }

    protected String buildResourceOwnerMappingName(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(name);
        sb.append("' to Persistent Grant Contract");
        return sb.toString();
    }

    protected String buildIdpAdapterMappingName(String name) {
        IdpAdapterManager mgr = MgmtFactory.getIdpAdapterManager();
        IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)mgr.getInstance(name);
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(instance.getName());
        sb.append("' to Persistent Grant Contract");
        return sb.toString();
    }

    protected String buildApcToUserKeyName(String apcId) {
        StringBuilder sb = new StringBuilder();
        C2cContract apc = MgmtFactory.getC2cContractManager().getContract(apcId);
        if (apc == null) {
            return null;
        }
        sb.append("'");
        sb.append(apc.getName());
        sb.append("' to Persistent Grant Contract");
        return sb.toString();
    }

    protected String buildTeppToUserKeyName(String teppId) {
        StringBuilder sb = new StringBuilder();
        TokenExchangeProcessorPolicy policy = MgmtFactory.getTokenExchangeProcessorPolicyManager().getPolicyById(teppId);
        if (policy == null) {
            return null;
        }
        sb.append("'");
        sb.append(policy.getName());
        sb.append("' to Persistent Grant Contract");
        return sb.toString();
    }

    public String getOnlineHelpBaseURL() {
        return DocumentationHelper.getDocumentationUrl();
    }

    protected String getNameForAuthnSelectionTree(AuthnSelectionTree tree) {
        if (StringUtils.isNotBlank((String)tree.getName())) {
            return "Authentication Policy '" + tree.getName() + "'";
        }
        AuthnSelectionAction action = (AuthnSelectionAction)tree.getRootNode().getData();
        String actionName = "";
        if (action instanceof AuthnSelectorAction) {
            AuthnSelectorManager mgr = MgmtFactory.getAuthnSelectorManager();
            AuthnSelectorInstance instance = (AuthnSelectorInstance)mgr.getInstance(((AuthnSelectorAction)action).getAuthnSelectorId());
            actionName = instance.getName();
        } else if (action instanceof AuthnSourceAction) {
            AuthnSourceKey key = ((AuthnSourceAction)action).getAuthnSourceKey();
            if (key.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                IdpAdapterManager mgr = MgmtFactory.getIdpAdapterManager();
                IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)mgr.getInstance(key.getId());
                if (adapter != null) {
                    actionName = adapter.getName();
                }
            } else if (key.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                MetadataDirectory mdd = MetaDataFactory.getMetadataDirectory();
                ConnectionBase conn = mdd.getConnection(key.getId());
                actionName = conn.getName();
            }
        }
        if (actionName != null) {
            return "Authentication Policy starting with '" + actionName + "'";
        }
        return actionName;
    }

    protected String buildAccessTokenMappingName(String name) {
        Object mappingName = "";
        String contextId = UserKeyToAccessTokenMapping.getContextId((String)name);
        if ("default".equals(contextId)) {
            mappingName = "'Default'";
        } else if ("client_credentials".equals(contextId)) {
            mappingName = "'Client Credentials'";
        } else {
            String ctxQualifier;
            switch (ctxQualifier = StringUtils.substringBefore((String)contextId, (String)"|")) {
                case "authz_req": {
                    MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
                    String ctxId = StringUtils.substringAfter((String)contextId, (String)"|");
                    OAuthSourceId sourceId = OAuthSourceId.fromString((String)ctxId, (String)ctxQualifier);
                    if (sourceId.getType() == OAuthSourceId.Type.IDP_CONNECTION) {
                        IdpConnection idp = metadataDirectory.getIdpConnectionBySystemId(sourceId.getRealId(), false);
                        if (idp == null) break;
                        mappingName = "'IdP Connection: " + idp.getName() + "'";
                        break;
                    }
                    if (sourceId.getType() == OAuthSourceId.Type.APC) {
                        C2cContract apc = MgmtFactory.getC2cContractManager().getContract(sourceId.getRealId());
                        if (apc == null) break;
                        mappingName = "'Authentication Policy Contract: " + apc.getName() + "'";
                        break;
                    }
                    IdpAdapterManager mgr = MgmtFactory.getIdpAdapterManager();
                    IdpAuthnAdapterInstance instance = (IdpAuthnAdapterInstance)mgr.getInstance(ctxId);
                    mappingName = "'IdP Adapter: " + instance.getName() + "'";
                    break;
                }
                case "password": {
                    PasswordCredentialValidatorManager validatorManager = MgmtFactory.getCredentialValidatorManager();
                    ConfigurablePluginInstance instance = validatorManager.getInstance(StringUtils.substringAfter((String)contextId, (String)"|"));
                    StringBuilder sb = new StringBuilder();
                    sb.append("'Validator: ");
                    sb.append(instance.getName());
                    sb.append("'");
                    mappingName = sb.toString();
                    break;
                }
                case "urn:ietf:params:oauth:grant-type:token-exchange": {
                    TokenExchangeProcessorPolicyManager tokenExchangeProcessorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
                    TokenExchangeProcessorPolicy policy = tokenExchangeProcessorPolicyManager.getTokenExchangeProcessorPolicies().getPolicy(StringUtils.substringAfter((String)contextId, (String)"|"));
                    mappingName = "'Token Exchange Processor Policy: " + policy.getName() + "'";
                    break;
                }
            }
        }
        String tokenManagerId = UserKeyToAccessTokenMapping.getTokenManagerId((String)name);
        BearerAccessTokenMgmtPluginInstance tokenManager = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(tokenManagerId);
        if (tokenManager != null) {
            mappingName = (String)mappingName + " to '" + tokenManager.getName() + "'";
        }
        return mappingName;
    }

    protected List<InUseItem> convertClientToInUseItems(List<Client> clients) {
        int numberOfClientsFound = clients.size();
        int clientSearchCount = this.getClientCount();
        LinkedList<InUseItem> items = new LinkedList<InUseItem>();
        if (clientSearchCount >= 0) {
            clients = clients.stream().limit(clientSearchCount).collect(Collectors.toList());
        }
        for (Client client : clients) {
            InUseItem item = new InUseItem(client.getName(), client.getClientId());
            items.add(item);
        }
        if (clientSearchCount >= 0 && numberOfClientsFound > 0 && items.size() < numberOfClientsFound) {
            items.add(new InUseItem("More clients exist in datastore with reference."));
        }
        return items;
    }

    private int getClientCount() {
        ClientManager clientManager = MgmtFactory.getClientManager();
        try {
            return (Integer)Proxy.getInvocationHandler(clientManager).invoke(clientManager, AbstractClientManagerImpl.class.getMethod("getDatastoreSearchClientCount", new Class[0]), null);
        }
        catch (Throwable e) {
            log.warn((Object)"Defaulting getDatastoreSearchClientCount to -1.");
            return -1;
        }
    }
}

