/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.UserMgmtState;
import com.pingidentity.fsm.tasklet.impl.UsersTasklet;
import com.pingidentity.page.ValidatePage;
import com.pingidentity.session.AdminSessionTracker;
import com.pingidentity.session.LoginTracker;
import com.pingidentity.sso.OIDCAdminAuthenticationHandler;
import com.pingidentity.sso.OIDCAuthenticationResult;
import com.pingidentity.sso.PingOneSsoHelper;
import com.pingidentity.util.AdminBaseUrlUtil;
import com.pingidentity.util.UIPaths;
import com.pingidentity.validator.PFValidationDelegate;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageValidateListener;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;
import org.sourceid.util.license.LicenseManager;

public abstract class Login
extends ValidatePage
implements PageValidateListener {
    public static final String DIRECT_LOGIN_PAGE = "directLogin";
    public static final String HOMEPAGE = "Home";
    private static final Log log = LogFactory.getLog(Login.class);
    private String username = "";
    private String password = "";
    private String radiusState;
    private String radiusUsername;
    private String radiusChallenge;
    private final AdminUserManager adminUserManager;

    public Login() {
        this(MgmtFactory.getAdminUserManager());
    }

    public Login(AdminUserManager adminUserManager) {
        this.adminUserManager = adminUserManager;
    }

    public void attach(IEngine engine) {
        super.attach(engine);
        this.username = "";
        this.password = "";
        this.radiusState = null;
        this.radiusUsername = null;
        this.radiusChallenge = null;
    }

    public boolean hasValidLicense() {
        return LicenseManager.isValidForGui();
    }

    @Override
    public void pageValidate(PageEvent event) {
        boolean setupNeeded;
        this.setupCSRFToken();
        if (!this.hasValidLicense() && this.isSetupWizardDone()) {
            throw new PageRedirectException("LicenseImport");
        }
        Visit visit = this.getPingVisit();
        if ((visit != null && visit.isUserAuthenticated() || AdminAuthManager.getInstance().isNative()) && (setupNeeded = this.isInitialSetupDone()) && !this.doSso()) {
            throw new PageRedirectException(HOMEPAGE);
        }
        if (this.isDirectLoginPage() && AdminAuthManager.getInstance().isNullAuthnMethod()) {
            throw new PageRedirectException("DirectLoginDisabled");
        }
        if (this.doSso()) {
            if (!new PingOneSsoHelper().checkCanInitiateSso(this.getRequestCycle())) {
                throw new PageRedirectException("SingleSignOnError");
            }
            if (visit != null && visit.getOIDCAuthenticationResult() != null) {
                this.login(this.getRequestCycle(), false);
            }
        } else if (this.isOidcAuth()) {
            if (visit != null && visit.getOIDCAuthenticationResult() != null) {
                this.login(this.getRequestCycle(), false);
            }
        } else if (this.isCertAuth()) {
            this.login(this.getRequestCycle(), false);
        }
    }

    public void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Visit visit = this.getPingVisit();
        if (this.doSso() && (visit == null || visit.getOIDCAuthenticationResult() == null)) {
            log.debug((Object)"Sending OIDC SSO authentication request to PingOne");
            PingOneSsoHelper ssoHelper = new PingOneSsoHelper();
            ssoHelper.sendAuthnRequest(cycle);
        } else if (this.isOidcAuth() && (visit == null || !visit.isUserAuthenticated())) {
            log.debug((Object)"Sending OIDC SSO authentication request to the configured OIDC Partner");
            OIDCAdminAuthenticationHandler oidcAuthHandler = new OIDCAdminAuthenticationHandler(this.adminUserManager);
            oidcAuthHandler.sendAuthnRequest(cycle);
        } else {
            super.renderComponent(writer, cycle);
        }
    }

    public void onFormLogin(IRequestCycle cycle) {
        Visit visit = this.getPingVisit();
        if (visit != null && visit.getCurrentUser() != null) {
            visit.clearUserSteps();
        }
        this.validateCSRFToken(cycle);
        this.login(cycle, true);
    }

    protected boolean doSso() {
        return this.isSsoEnabled() && !this.isDirectLoginPage();
    }

    protected boolean isDirectLoginPage() {
        return this.getPageName().equals(DIRECT_LOGIN_PAGE);
    }

    private AdminUserManager getAdminUserManager() {
        AdminUserManager adminUserManager = null;
        try {
            adminUserManager = MgmtFactory.getAdminUserManager();
        }
        catch (RuntimeException e) {
            String msg = "Unexpected error: See log for details";
            this.logEvent(msg);
            log.error((Object)"Error encountered obtaining an AdminUserManager", (Throwable)e);
            PFValidationDelegate delegate = (PFValidationDelegate)((Object)this.getBeans().getBean("delegate"));
            delegate.record(msg, ValidationConstraint.REQUIRED);
        }
        return adminUserManager;
    }

    private void login(IRequestCycle cycle, boolean formLogin) {
        Mediator mediator = MgmtFactory.getMediator();
        if (!mediator.isConsole()) {
            IPage messagePage = this.getRequestCycle().getPage("nonAdminConsole");
            throw new PageRedirectException(messagePage);
        }
        PFValidationDelegate delegate = (PFValidationDelegate)((Object)this.getBeans().getBean("delegate"));
        AdminUserManager adminUserManager = this.getAdminUserManager();
        AdministrativeUser user = null;
        boolean pingOneSso = false;
        LoginTracker loginTracker = LoginTracker.getInstance();
        try {
            HttpServletRequest request;
            HttpSession oldSession;
            String userIpAddress = cycle.getRequestContext().getRequest().getRemoteAddr();
            AdminAuditLogger.setIpAddress((String)userIpAddress);
            if (formLogin) {
                if (this.containsRadiusChallenge() && StringUtils.isNotEmpty((String)this.radiusUsername)) {
                    this.username = this.radiusUsername;
                }
                user = adminUserManager.authenticate(this.username, this.password, cycle.getRequestContext().getRequest());
            } else {
                user = this.getUserFromSso(cycle);
                if (user == null) {
                    user = adminUserManager.authenticate(cycle.getRequestContext().getRequest());
                } else if (this.isSsoEnabled()) {
                    pingOneSso = true;
                }
            }
            if (!(user.isAdmin() || user.isAdminManager() || user.isCryptoManager() || user.isAuditor())) {
                throw new AdminUserException(AdminUserException.Code.PERMISSIONS);
            }
            if ("single".equalsIgnoreCase(PropertyInfo.getConsoleLoginMode())) {
                loginTracker.logOutPrevSession(user);
            }
            if ((oldSession = (request = cycle.getRequestContext().getRequest()).getSession(false)) != null && !oldSession.isNew()) {
                ConcurrentHashMap<String, Object> temp = new ConcurrentHashMap<String, Object>();
                Enumeration e = oldSession.getAttributeNames();
                while (e != null && e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Object value = oldSession.getAttribute(name);
                    temp.put(name, value);
                }
                oldSession.invalidate();
                HttpSession newSession = request.getSession(true);
                for (Map.Entry stringObjectEntry : temp.entrySet()) {
                    newSession.setAttribute((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            }
        }
        catch (AdminUserException e) {
            this.password = "";
            switch (e.getCode()) {
                case USER: {
                    this.logEvent(this.getMessage("Unknown_user"));
                    delegate.record(this.getMessage("Invalid_username_or_password"), ValidationConstraint.REQUIRED);
                    break;
                }
                case PASSWORD: {
                    this.logEvent(this.getMessage("Incorrect_password"));
                    delegate.record(this.getMessage("Invalid_username_or_password"), ValidationConstraint.REQUIRED);
                    break;
                }
                case PERMISSIONS: {
                    this.logEvent(this.getMessage("Not_permitted"));
                    delegate.record(this.getMessage("Not_permitted"), ValidationConstraint.REQUIRED);
                    break;
                }
                case LDAP_AVAILABILITY: {
                    this.logEvent(this.getMessage("LDAP_Service_unavailable"));
                    delegate.record(this.getMessage("LDAP_Service_unavailable"), ValidationConstraint.REQUIRED);
                    break;
                }
                case RADIUS_AVAILABILITY: {
                    this.logEvent(this.getMessage("RADIUS_Service_unavailable"));
                    delegate.record(this.getMessage("RADIUS_Service_unavailable"), ValidationConstraint.REQUIRED);
                    break;
                }
                case RADIUS_ACCESS_CHALLENGE: {
                    RadiusAdminUserException ace = (RadiusAdminUserException)e;
                    this.username = ace.getUsername();
                    this.radiusState = B64.encode((byte[])ace.getState());
                    this.logEvent(this.getMessage("Challenge-Response"));
                    this.radiusChallenge = StringUtils.defaultIfEmpty((String)ace.getReplyMessage(), (String)this.getMessage("RADIUS_Challenge"));
                    break;
                }
                case RADIUS_ACCESS_REJECT: {
                    this.logEvent(this.getMessage("Access-Reject"));
                    RadiusAdminUserException are = (RadiusAdminUserException)e;
                    String errorMessage = StringUtils.defaultIfEmpty((String)are.getReplyMessage(), (String)this.getMessage("Not_permitted"));
                    delegate.record(errorMessage, ValidationConstraint.REQUIRED);
                    break;
                }
                case LOCKED: {
                    this.logEvent(this.getMessage("Locked_ip").replaceAll("xx", "1"));
                    delegate.record(this.getMessage("Locked_ip"), ValidationConstraint.REQUIRED);
                    break;
                }
                case CERT_NOT_FOUND: {
                    this.logEvent(this.getMessage("Cert_not_found"));
                    delegate.record(this.getMessage("Cert_not_found"), ValidationConstraint.REQUIRED);
                    break;
                }
                case CERT_NOT_TRUSTED: {
                    this.logEvent(this.getMessage("Cert_not_trusted"));
                    delegate.record(this.getMessage("Cert_not_trusted"), ValidationConstraint.REQUIRED);
                    break;
                }
                case CERT_INVALID: {
                    this.logEvent(this.getMessage("Cert_invalid"));
                    delegate.record(this.getMessage("Cert_invalid"), ValidationConstraint.REQUIRED);
                    break;
                }
                case SSO_ERROR: {
                    this.logEvent(this.getMessage("Sso_error"));
                    if (this.doSso()) {
                        throw new PageRedirectException("SingleSignOnError");
                    }
                    delegate.record(this.getMessage("Sso_error"), ValidationConstraint.REQUIRED);
                    break;
                }
                default: {
                    this.logEvent(this.getMessage("Unknown_user") + " or " + this.getMessage("Incorrect_password"));
                    delegate.record(this.getMessage("Invalid_username_or_password"), ValidationConstraint.REQUIRED);
                }
            }
            if (!this.doSso() && this.isOidcAuth() && delegate.getHasErrors()) {
                throw new PageRedirectException("OIDCAuthError");
            }
            return;
        }
        if (user.isActive()) {
            Visit visit = this.getPingVisit(true);
            if (loginTracker.logInUser(cycle.getRequestContext().getRequest(), user)) {
                visit.setUserAuthenticated(true);
                visit.setCurrentUser(user);
                visit.setPingOneSso(pingOneSso);
                this.setupCSRFToken(true);
                HttpSession session = cycle.getRequestContext().getRequest().getSession();
                if (session != null) {
                    AdminSessionTracker.getInstance().addAdminSession(session, user);
                }
                AdminAuditLogger.setUser((String)user.getUserName());
                AdminAuditLogger.setRoles((String)new String(user.describeUser(true)));
                AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)this.getMessage("Login_success"));
                if (MgmtFactory.getMediator().getDataArchiveBackup().isBackupOnAdminLogin()) {
                    try {
                        MgmtFactory.getMediator().getDataArchiveBackup().backupDataArchive();
                    }
                    catch (IOException e) {
                        log.error((Object)"Backup creation failed", (Throwable)e);
                    }
                }
                if (user.getChangeRequired()) {
                    UsersTasklet usersTasklet = new UsersTasklet(visit, true);
                    usersTasklet.setCancelAvailable(false);
                    usersTasklet.setTaskletName("UsersTasklet");
                    usersTasklet.setMenuName("Change Password");
                    usersTasklet.setHelpName("UsersTasklet");
                    usersTasklet.setInitialState(new UserMgmtState(usersTasklet));
                    visit.addStep(usersTasklet);
                }
                this.addMainMenuStep(visit);
                if (cycle.getRequestContext() == null || cycle.getRequestContext().getRequest() == null) {
                    throw new IllegalArgumentException("Invalid request context on Login cycle");
                }
                StringBuilder basePath = AdminBaseUrlUtil.getAdminBaseUrlFromServletRequest((HttpServletRequest)cycle.getRequestContext().getRequest());
                Object homePage = UIPaths.getAdminReactHomePage(cycle.getRequestContext().getRequest());
                if (formLogin) {
                    boolean isChangePasswordNeeded = user.getChangeRequired();
                    if (isChangePasswordNeeded) {
                        ILink homeLink = this.getEngine().getService("page").getLink(cycle, null, (Object[])new String[]{HOMEPAGE});
                        throw new RedirectException(homeLink.getURL());
                    }
                    throw new RedirectException((String)homePage);
                }
                if (visit.getCurrentTasklet() != null && "Setup".equals(visit.getCurrentTasklet().getMenuName())) {
                    homePage = basePath + "/render/pingfederate/app";
                }
                if (cycle.getRequestContext() != null && cycle.getRequestContext().getResponse() != null) {
                    HttpServletResponse resp = cycle.getRequestContext().getResponse();
                    resp.setStatus(307);
                    resp.setHeader("Location", (String)homePage);
                    return;
                }
                throw new PageRedirectException(HOMEPAGE);
            }
            visit.logout(cycle.getRequestContext().getRequest().getSession(false));
            IPage messagePage = this.getRequestCycle().getPage("LoginNotAvailable");
            throw new PageRedirectException(messagePage);
        }
        this.logEvent("Deactivated user");
        delegate.record(this.getMessage("User_inactive"), ValidationConstraint.REQUIRED);
    }

    private void logEvent(String messageId) {
        AdminAuditLogger.setUser((String)this.username);
        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)messageId);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRadiusState() {
        return this.radiusState;
    }

    public void setRadiusState(String radiusState) {
        this.radiusState = radiusState;
    }

    public String getRadiusUsername() {
        return this.radiusUsername;
    }

    public void setRadiusUsername(String radiusUsername) {
        this.radiusUsername = radiusUsername;
    }

    public boolean isCertAuth() {
        return AdminAuthManager.getInstance().isCert();
    }

    public boolean isRadiusAuth() {
        return AdminAuthManager.getInstance().isRadius();
    }

    public boolean isOidcAuth() {
        return AdminAuthManager.getInstance().isOidc();
    }

    public String getRadiusChallenge() {
        return this.radiusChallenge;
    }

    public boolean containsRadiusChallenge() {
        return this.radiusChallenge != null;
    }

    public boolean isSsoEnabled() {
        return new PingOneSsoHelper().isSsoEnabled();
    }

    protected AdministrativeUser getUserFromSso(IRequestCycle cycle) throws AdminUserException {
        if (this.doSso()) {
            return this.getUserFromOIDCResult(new PingOneSsoHelper(), cycle);
        }
        if (this.isOidcAuth()) {
            return this.getUserFromOIDCResult(new OIDCAdminAuthenticationHandler(this.adminUserManager), cycle);
        }
        return null;
    }

    private AdministrativeUser getUserFromOIDCResult(OIDCAdminAuthenticationHandler authenticationHandler, IRequestCycle cycle) throws AdminUserException {
        Visit visit = this.getPingVisit();
        if (visit != null && visit.getOIDCAuthenticationResult() != null) {
            OIDCAuthenticationResult oldResult = visit.getOIDCAuthenticationResult();
            visit.setOIDCAuthenticationResult(null);
            return authenticationHandler.processAuthenticationResult(oldResult, cycle);
        }
        return null;
    }
}

