/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.InUsePopUp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ProcessorPolicyInUsePopUp
extends InUsePopUp {
    private final transient AuthzServerManager authzServerManager;
    private final transient ClientManager clientManager;
    private final transient ProcessorPolicy2TokenGeneratorManager policy2TokenGeneratorManager;
    private boolean clientSettingsUsingPolicy;
    private final List<InUseItem> atmsUsingResource = new LinkedList<InUseItem>();

    public ProcessorPolicyInUsePopUp() {
        this(MgmtFactory.getAuthzServerManager(), MgmtFactory.getClientManager(), MgmtFactory.getProcessorPolicy2TokenGeneratorManager());
    }

    public ProcessorPolicyInUsePopUp(AuthzServerManager authzServerManager, ClientManager clientManager, ProcessorPolicy2TokenGeneratorManager policy2TokenGeneratorManager) {
        this.authzServerManager = authzServerManager;
        this.clientManager = clientManager;
        this.policy2TokenGeneratorManager = policy2TokenGeneratorManager;
    }

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        this.id = (String)objs[0];
        this.loadMappingsUsingProcessorPolicy();
        this.loadClientsUsingProcessorPolicy();
        this.loadAccessTokenMappingsUsingPolicy();
        this.loadTeppToUserKeyMappingsUsingResource();
        this.checkClientSettings();
    }

    private void checkClientSettings() {
        this.clientSettingsUsingPolicy = false;
        ClientSetting clientSettings = MgmtFactory.getClientSettingManager().getClientSetting();
        if (clientSettings != null && this.id.equals(clientSettings.getTokenExchangeProcessorPolicyId())) {
            this.clientSettingsUsingPolicy = true;
        }
    }

    @Override
    protected void loadMappingsUsingProcessorPolicy() {
        List mappingsUsingPolicy = this.policy2TokenGeneratorManager.getMappings().stream().filter(mapping -> this.id.equals(mapping.getSourceId())).map(mapping -> new InUseItem(mapping.buildMappingName())).collect(Collectors.toList());
        this.mappingsUsingProcessorPolicy.clear();
        this.mappingsUsingProcessorPolicy.addAll(mappingsUsingPolicy);
    }

    @Override
    protected void loadClientsUsingProcessorPolicy() {
        ArrayList<Client> clientsUsingPolicy = new ArrayList<Client>(this.clientManager.getClientsByTeppId(this.id));
        String defaultProcessorPolicy = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies().getDefaultInstanceId();
        if (Objects.equals(this.id, defaultProcessorPolicy)) {
            clientsUsingPolicy.addAll(this.clientManager.getClientsByTeppId(null));
        }
        this.clientsUsingProcessorPolicy.clear();
        this.clientsUsingProcessorPolicy.addAll(this.convertClientToInUseItems(clientsUsingPolicy));
    }

    @Override
    protected void loadTeppToUserKeyMappingsUsingResource() {
        this.oauthTeppToUserKeyMappingsUsingResource.clear();
        TeppToUserKeyAttrMapping mapping = this.authzServerManager.getTeppToUserKeyMapping(this.id);
        if (mapping != null) {
            String name = this.buildTeppToUserKeyName(mapping.getTeppId());
            InUseItem item = new InUseItem(name);
            this.oauthTeppToUserKeyMappingsUsingResource.add(item);
        }
    }

    private void loadAccessTokenMappingsUsingPolicy() {
        String contextId = new ContextUtil().buildQualifiedId("urn:ietf:params:oauth:grant-type:token-exchange", new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, this.id));
        List items = this.authzServerManager.getAccessTokenMappings().stream().filter(mapping -> contextId.equals(mapping.getContextId())).map(mapping -> new InUseItem(this.buildAccessTokenMappingName(mapping.getId()))).collect(Collectors.toList());
        this.atmsUsingResource.clear();
        this.atmsUsingResource.addAll(items);
    }

    public List<InUseItem> getAtmsUsingResource() {
        return this.atmsUsingResource;
    }

    public boolean isShowAtmsUsingResource() {
        return !this.atmsUsingResource.isEmpty();
    }

    public boolean isClientSettingsUsingPolicy() {
        return this.clientSettingsUsingPolicy;
    }
}

