/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.plugins.PluginBuilder;
import java.util.Set;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class CidrSelectorBuilder
extends PluginBuilder<AuthnSelectorInstance> {
    private static final String TABLE_NETWORKS = "Networks";
    private static final String FIELD_NETWORKS = "Network Range (CIDR notation)";

    public CidrSelectorBuilder(Set<String> ipRanges) {
        Table table = this.addTable(TABLE_NETWORKS);
        for (String range : ipRanges) {
            this.addFieldToTable(table, FIELD_NETWORKS, range);
        }
    }

    @Override
    protected String getPluginDescriptorClass() {
        return "com.pingidentity.pf.selectors.cidr.CIDRAdapterSelector";
    }

    @Override
    protected PluginManager<?, AuthnSelectorInstance> getPluginManager() {
        return MgmtFactory.getAuthnSelectorManager();
    }

    @Override
    protected String getDefaultName() {
        return "cidr-selector";
    }
}

