/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.plugins.PluginBuilder;
import java.util.Collections;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class KerberosAdapterBuilder
extends PluginBuilder<IdpAuthnAdapterInstance> {
    private static final String REALM_NAME_FIELD = "Domain/Realm Name";

    public KerberosAdapterBuilder(String kerbRealmId) {
        this.addField(REALM_NAME_FIELD, kerbRealmId);
        this.setUniqueKeyField("Username");
    }

    @Override
    protected String getPluginDescriptorClass() {
        return "com.pingidentity.adapters.kerberos.idp.KerberosAuthenticationAdapter";
    }

    @Override
    protected PluginManager<?, IdpAuthnAdapterInstance> getPluginManager() {
        return MgmtFactory.getIdpAdapterManager();
    }

    @Override
    protected String getDefaultName() {
        return "kerberos-adapter";
    }

    private void setUniqueKeyField(String key) {
        ((IdpAuthnAdapterInstance)this.plugin).setOwnUniqueKeyFields(Collections.singletonList(key));
    }
}

