/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.google.common.collect.ImmutableMap;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.plugins.CidrSelectorBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public class KerberosSelectorBuilder {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_CIDR_SELECTOR_NAME = "Internal Network  Selector";
    private static final String DEFAULT_POLICY_NAME = "PingOne";
    private static final String DEFAULT_POLICY_TREE_DESCRIPTION = "The authentication policy for SSO into PingOne.";
    private static final Map<String, String> SYNONYM_LIST = ImmutableMap.builder().put((Object)"Username", (Object)"username").build();
    private final AuthnSelectionTree policyTree;
    private final CidrSelectorBuilder cidrSelector;
    private final AdapterAuthnSourceKey htmlFormAdapterSource;
    private final AdapterAuthnSourceKey kerberosAdapter;

    public KerberosSelectorBuilder(IdpAuthnAdapterInstance kerbAdapter, IdpAuthnAdapterInstance htmlForm, Set<String> cidrRanges) {
        this(kerbAdapter, htmlForm, cidrRanges, DEFAULT_POLICY_NAME, DEFAULT_POLICY_TREE_DESCRIPTION);
    }

    public KerberosSelectorBuilder(IdpAuthnAdapterInstance kerbAdapter, IdpAuthnAdapterInstance htmlForm, Set<String> cidrRanges, String policyName, String policyDescription) {
        this.cidrSelector = new CidrSelectorBuilder(cidrRanges);
        this.cidrSelector.setNameAndId(this.getCidrSelectorName());
        this.kerberosAdapter = new AdapterAuthnSourceKey(kerbAdapter.getId());
        this.htmlFormAdapterSource = new AdapterAuthnSourceKey(htmlForm.getId());
        this.policyTree = this.createAuthenticationPolicy(policyName, policyDescription);
    }

    private AuthnSelectionTree createAuthenticationPolicy(String policyName, String policyDescription) {
        Tree.Node[] leafs;
        AuthnSelectorAction cidrAction = new AuthnSelectorAction(((AuthnSelectorInstance)this.cidrSelector.getPlugin()).getId());
        AuthnSourceAction kerberosAction = new AuthnSourceAction((AuthnSourceKey)this.kerberosAdapter);
        kerberosAction.setContext("Yes");
        AuthnSourceAction cidrHtmlFormAction = new AuthnSourceAction((AuthnSourceKey)this.htmlFormAdapterSource);
        cidrHtmlFormAction.setContext("No");
        AuthnSourceAction kerberosHtmlFormAction = new AuthnSourceAction((AuthnSourceKey)this.htmlFormAdapterSource);
        kerberosHtmlFormAction.setContext("Fail");
        AuthnSelectionTree policyTree = new AuthnSelectionTree((AuthnSelectionAction)cidrAction);
        Tree.Node cidrNode = policyTree.getRootNode();
        Tree.Node cidrHtmlNode = cidrNode.addChildData((Object)cidrHtmlFormAction);
        Tree.Node kerberosNode = cidrNode.addChildData((Object)kerberosAction);
        Tree.Node kerberosHtmlNode = kerberosNode.addChildData((Object)kerberosHtmlFormAction);
        for (Tree.Node leaf : leafs = new Tree.Node[]{cidrHtmlNode, kerberosHtmlNode}) {
            NoOpAction failDoneAction = this.getDoneNodeForAction("Fail");
            NoOpAction successDoneAction = this.getDoneNodeForAction("Success");
            leaf.addChildData((Object)failDoneAction);
            leaf.addChildData((Object)successDoneAction);
        }
        NoOpAction successDoneAction = this.getDoneNodeForAction("Success");
        kerberosNode.addChildData((Object)successDoneAction);
        policyTree.setId(AuthnPolicyUtil.getDefault().generateId());
        policyTree.setName(this.getValidPolicyTreeName(policyName));
        policyTree.setDescription(policyDescription);
        return policyTree;
    }

    private NoOpAction getDoneNodeForAction(String branchAction) {
        NoOpAction failDoneAction = new NoOpAction(NoOpAction.Type.DONE);
        failDoneAction.setContext(branchAction);
        return failDoneAction;
    }

    private String getValidPolicyTreeName(String preferredName) {
        Object policyName = preferredName;
        int i = 1;
        while (this.isPolicyNameInUse((String)policyName)) {
            policyName = preferredName + "-" + i++;
        }
        return policyName;
    }

    private boolean isPolicyNameInUse(String policyName) {
        for (AuthnSelectionTree tree : MgmtFactory.getAuthnSelectionConfigManager().getAuthnSelectionTrees()) {
            if (!tree.getName().equals(policyName)) continue;
            return true;
        }
        return false;
    }

    public void save() {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.log.debug((Object)"Saving Authentication selectors.");
            this.cidrSelector.save();
            this.saveAuthenticationMappings();
            auditLoggerScope.log(AdminAuditLogger.Component.AUTH_SELECTION_POLICY, AdminAuditLogger.Event.MODIFY);
        }
    }

    private void saveAuthenticationMappings() {
        this.log.debug((Object)"Saving Authentication mappings selectors.");
        AuthnSelectionConfigManager adapterSelectorConfigManager = MgmtFactory.getAuthnSelectionConfigManager();
        ArrayList<AuthnSelectionTree> trees = new ArrayList<AuthnSelectionTree>(adapterSelectorConfigManager.getAuthnSelectionTrees());
        trees.add(this.policyTree);
        ArrayList<AdapterAuthnSourceKey> defaultSourceKeys = new ArrayList<AdapterAuthnSourceKey>(adapterSelectorConfigManager.getDefaultAuthnSourceKeys());
        defaultSourceKeys.add(this.htmlFormAdapterSource);
        adapterSelectorConfigManager.setDefaultAuthnSourceKeys(defaultSourceKeys);
        adapterSelectorConfigManager.setAuthnSelectionTrees(trees);
        adapterSelectorConfigManager.setEnableIdpAuthnSelection(true);
    }

    public AuthnSelectorInstance getCidrSelector() {
        return (AuthnSelectorInstance)this.cidrSelector.getPlugin();
    }

    protected String getCidrSelectorName() {
        return DEFAULT_CIDR_SELECTOR_NAME;
    }
}

