/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.plugins.PluginBuilder;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.LDAPUsernamePasswordCredentialValidator;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class LdapPcvBuilder
extends PluginBuilder<PasswordCredentialValidatorInstance> {
    public static final String LDAP_DATASTORE_FIELD = "LDAP Datastore";
    public static final String LDAP_SEARCH_BASE_FIELD = "Search Base";
    public static final String LDAP_SEARCH_FILTER_FIELD = "Search Filter";
    public static final String LDAP_SEARCH_SCOPE_FIELD = "Scope of Search";

    public LdapPcvBuilder(String dsName, String searchBase, String searchFilter, Set<String> extendedAttrs) {
        HashSet<String> attributes = new HashSet<String>(extendedAttrs);
        this.filterCoreAttributes(attributes);
        ((PasswordCredentialValidatorInstance)this.plugin).setExtendedContractAttributes(attributes);
        this.addDataStoreName(dsName);
        this.addSearchBase(searchBase);
        this.addSearchFilter(searchFilter);
    }

    @Override
    protected String getPluginDescriptorClass() {
        return LDAPUsernamePasswordCredentialValidator.class.getCanonicalName();
    }

    protected PasswordCredentialValidatorManager getPluginManager() {
        return MgmtFactory.getCredentialValidatorManager();
    }

    @Override
    protected String getDefaultName() {
        return "LDAP PCV";
    }

    public void addDataStoreName(String dsName) {
        this.addField(LDAP_DATASTORE_FIELD, dsName);
    }

    public void addSearchFilter(String searchFilter) {
        this.addField(LDAP_SEARCH_FILTER_FIELD, searchFilter);
    }

    public void addSearchBase(String searchBase) {
        this.addField(LDAP_SEARCH_BASE_FIELD, searchBase);
    }

    public void addSearchScope(String searchScope) {
        this.addField(LDAP_SEARCH_SCOPE_FIELD, searchScope);
    }
}

