/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.plugins.PluginBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.SimpleUsernamePasswordCredentialValidator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class SimplePCVBuilder
extends PluginBuilder<PasswordCredentialValidatorInstance> {
    private static final Map<String, String> testAccounts = new HashMap<String, String>();

    public SimplePCVBuilder() {
        for (Map.Entry<String, String> entry : testAccounts.entrySet()) {
            this.addUserRow(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected String getPluginDescriptorClass() {
        return SimpleUsernamePasswordCredentialValidator.class.getCanonicalName();
    }

    protected PasswordCredentialValidatorManager getPluginManager() {
        return MgmtFactory.getCredentialValidatorManager();
    }

    @Override
    protected String getDefaultName() {
        return "Simple PCV";
    }

    private void addRow(String tableName, String fieldName, String fieldValue) {
        Table table = this.addTable(tableName);
        Field ipField = new Field(fieldName, fieldValue);
        this.addRowToTable(table, Arrays.asList(ipField));
    }

    private void addUserRow(String uname, String password) {
        Table radiusTables = this.addTable("Users");
        Field usernameField = new Field("Username", uname);
        String value = HashedPassword.fromClearText((String)password).toEncodedText();
        HashedField passwordField = new HashedField("Password", value, null);
        HashedField confirmPasswordField = new HashedField("Confirm Password", value, null);
        this.addRowToTable(radiusTables, Arrays.asList(usernameField, passwordField, confirmPasswordField));
    }

    public String getTestUsersForSummary() {
        StringBuilder users = new StringBuilder();
        if (testAccounts != null && !testAccounts.isEmpty()) {
            Iterator<Map.Entry<String, String>> it = testAccounts.entrySet().iterator();
            Map.Entry<String, String> first = it.next();
            users.append(first.getKey() + " / " + first.getValue());
            while (it.hasNext()) {
                users.append(", ");
                Map.Entry<String, String> entry = it.next();
                users.append(entry.getKey() + " / " + entry.getValue());
            }
        }
        return users.toString();
    }

    static {
        testAccounts.put("joe", "2Federate");
        testAccounts.put("sarah", "2Federate");
    }
}

