/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.fsm.Visit;
import com.pingidentity.session.AdminConsoleApiAccessToken;
import com.pingidentity.session.SessionValidator;
import com.pingidentity.util.JsonUtil;
import com.pingidentity.util.PingAbstractService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;
import org.sourceid.oauth20.token.AdminConsoleTokenManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ApiTokenService
extends PingAbstractService {
    private static final Log log = LogFactory.getLog(ApiTokenService.class);
    public static final String SERVICE_NAME = "apitoken";
    private final SessionValidator sessionValidator;
    private final AdminConsoleTokenManager adminConsoleTokenManager;
    private final ObjectMapper objectMapper;

    public ApiTokenService() {
        this(new SessionValidator(), MgmtFactory.getAdminConsoleTokenManager(), JsonUtil.buildObjectMapper());
    }

    public ApiTokenService(SessionValidator sessionValidator, AdminConsoleTokenManager adminConsoleTokenManager, ObjectMapper objectMapper) {
        this.sessionValidator = sessionValidator;
        this.adminConsoleTokenManager = adminConsoleTokenManager;
        this.objectMapper = objectMapper;
    }

    public ILink getLink(IRequestCycle requestCycle, IComponent iComponent, Object[] parameters) {
        return this.constructLink(requestCycle, SERVICE_NAME, new String[0], parameters, true);
    }

    public void service(IEngineServiceView engineServiceView, IRequestCycle requestCycle, ResponseOutputStream responseOutputStream) throws ServletException, IOException {
        Visit pingVisit = this.getPingVisit(requestCycle);
        ObjectNode node = this.objectMapper.createObjectNode();
        if (this.sessionValidator.checkSessionValidity(requestCycle, pingVisit)) {
            HttpSession session = requestCycle.getRequestContext().getRequest().getSession();
            AdminConsoleApiAccessToken accessToken = this.adminConsoleTokenManager.createAccessToken(pingVisit.getCurrentUser(), session);
            node.put("access_token", accessToken.getId());
            node.put("token_type", "Bearer");
        } else {
            node.put("error_description", "Invalid request to the token api endpoint.");
            requestCycle.getRequestContext().getResponse().setStatus(400);
        }
        responseOutputStream.setContentType("application/json");
        responseOutputStream.write(this.objectMapper.writeValueAsString((Object)node).getBytes(StandardCharsets.UTF_8));
    }

    public String getName() {
        return SERVICE_NAME;
    }
}

