/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.impl.MainMenuTasklet;
import com.pingidentity.session.AdminSessionTracker;
import com.pingidentity.session.LoginTracker;
import com.pingidentity.util.JsonUtil;
import com.pingidentity.util.PingAbstractService;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class LoginService
extends PingAbstractService {
    private static final Log log = LogFactory.getLog(LoginService.class);
    public static final String SERVICE_NAME = "login";
    private static final String CSRF_COOKIE = "PFCSRF";
    private final ObjectMapper jsonObjectMapper;

    public LoginService() {
        this(JsonUtil.buildObjectMapper());
    }

    public LoginService(ObjectMapper objectMapper) {
        this.jsonObjectMapper = objectMapper;
    }

    public ILink getLink(IRequestCycle requestCycle, IComponent iComponent, Object[] parameters) {
        return this.constructLink(requestCycle, SERVICE_NAME, new String[0], parameters, true);
    }

    public void service(IEngineServiceView engineServiceView, IRequestCycle requestCycle, ResponseOutputStream responseOutputStream) throws IOException {
        block11: {
            log.debug((Object)"The login service endpoint was invoked.");
            HttpServletRequest request = requestCycle.getRequestContext().getRequest();
            CredentialsInfo credentialsInfo = (CredentialsInfo)this.jsonObjectMapper.readValue((Reader)request.getReader(), CredentialsInfo.class);
            LoginTracker loginTracker = LoginTracker.getInstance();
            String userIpAddress = requestCycle.getRequestContext().getRequest().getRemoteAddr();
            AdminAuditLogger.setIpAddress((String)userIpAddress);
            AdminUserManager adminUserManager = this.getAdminUserManager();
            try {
                AdministrativeUser user = adminUserManager.authenticate(credentialsInfo.getUsername(), credentialsInfo.getPassword(), request);
                if (user.isActive()) {
                    Visit visit = this.getPingVisit(requestCycle);
                    if (!loginTracker.logInUser(requestCycle.getRequestContext().getRequest(), user)) break block11;
                    visit.setUserAuthenticated(true);
                    visit.setCurrentUser(user);
                    visit.setPingOneSso(false);
                    this.setupCSRFToken(true, requestCycle);
                    AdminSessionTracker.getInstance().addAdminSession(requestCycle.getRequestContext().getRequest().getSession(), user);
                    AdminAuditLogger.setUser((String)user.getUserName());
                    AdminAuditLogger.setRoles((String)new String(user.describeUser(true)));
                    AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)"Login was successful");
                    if (MgmtFactory.getMediator().getDataArchiveBackup().isBackupOnAdminLogin()) {
                        try {
                            MgmtFactory.getMediator().getDataArchiveBackup().backupDataArchive();
                        }
                        catch (IOException e) {
                            log.error((Object)"Backup creation failed", (Throwable)e);
                        }
                    }
                    this.addMainMenuStep(visit);
                    requestCycle.getRequestContext().getResponse().setStatus(200);
                    break block11;
                }
                throw new AdminUserException(AdminUserException.Code.USER);
            }
            catch (AdminUserException e) {
                AdminAuditLogger.setUser((String)credentialsInfo.getUsername());
                switch (e.getCode()) {
                    case USER: {
                        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)"Unknown user");
                        break;
                    }
                    case PERMISSIONS: {
                        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)"You do not have permission to access this product");
                        break;
                    }
                    case LOCKED: {
                        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)"Your account has been temporarily locked. Please contact your system administrator.");
                        break;
                    }
                    default: {
                        AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)"Incorrect password");
                    }
                }
                requestCycle.getRequestContext().getSession().invalidate();
                requestCycle.getRequestContext().getResponse().setStatus(403);
            }
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    private void addMainMenuStep(Visit visit) {
        MainMenuTasklet tasklet = new MainMenuTasklet(visit);
        visit.addStep(tasklet);
        visit.setInitialTasklet(tasklet);
    }

    protected void setupCSRFToken(boolean forceUpdate, IRequestCycle requestCycle) {
        if (forceUpdate || requestCycle.getRequestContext().getCookie(CSRF_COOKIE) == null) {
            String cSRFToken = IDGenerator.rndAlphaNumeric((int)20);
            Cookie csfrCookie = new Cookie(CSRF_COOKIE, cSRFToken);
            csfrCookie.setSecure(true);
            csfrCookie.setHttpOnly(true);
            requestCycle.getRequestContext().addCookie(csfrCookie);
        }
    }

    private AdminUserManager getAdminUserManager() {
        AdminUserManager adminUserManager = null;
        try {
            adminUserManager = MgmtFactory.getAdminUserManager();
        }
        catch (RuntimeException e) {
            String msg = "Unexpected error: See log for details";
            AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.LOGIN_ATTEMPT, (String)msg);
            log.error((Object)"Error encountered obtaining an AdminUserManager", (Throwable)e);
        }
        return adminUserManager;
    }

    private static class CredentialsInfo {
        @JsonProperty(value="username")
        protected String username;
        @JsonProperty(value="password")
        protected String password;

        private CredentialsInfo() {
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

