/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.admin.api.model.AdministrativeRoleType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.session.SessionValidator;
import com.pingidentity.util.JsonUtil;
import com.pingidentity.util.PingAbstractService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class SessionService
extends PingAbstractService {
    public static final String SERVICE_NAME = "session";
    private final SessionValidator sessionValidator;
    private final ObjectMapper objectMapper;

    public SessionService() {
        this(new SessionValidator(), JsonUtil.buildObjectMapper());
    }

    public SessionService(SessionValidator sessionValidator, ObjectMapper objectMapper) {
        this.sessionValidator = sessionValidator;
        this.objectMapper = objectMapper;
    }

    public ILink getLink(IRequestCycle requestCycle, IComponent iComponent, Object[] parameters) {
        return this.constructLink(requestCycle, SERVICE_NAME, new String[0], parameters, true);
    }

    public void service(IEngineServiceView engineServiceView, IRequestCycle requestCycle, ResponseOutputStream responseOutputStream) throws IOException {
        Visit pingVisit = this.getPingVisit(requestCycle);
        responseOutputStream.setContentType("application/json");
        if (this.sessionValidator.checkNonTempUserSessionValidity(requestCycle, pingVisit)) {
            requestCycle.getRequestContext().getResponse().setStatus(200);
            CurrentSession currentSession = new CurrentSession.Builder().build(pingVisit);
            responseOutputStream.write(this.objectMapper.writeValueAsString((Object)currentSession).getBytes(StandardCharsets.UTF_8));
        } else if (!this.sessionValidator.isSetupWizardDone()) {
            requestCycle.getRequestContext().getResponse().setStatus(200);
            CurrentSession currentSession = new CurrentSession.IncompleteSetupBuilder().build();
            responseOutputStream.write(this.objectMapper.writeValueAsString((Object)currentSession).getBytes(StandardCharsets.UTF_8));
        } else {
            ObjectNode node = this.objectMapper.createObjectNode();
            requestCycle.getRequestContext().getResponse().setStatus(400);
            requestCycle.getRequestContext().getSession().invalidate();
            node.put("error_description", "Invalid or expired session.");
            responseOutputStream.write(this.objectMapper.writeValueAsString((Object)node).getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    private static class CurrentSession {
        private final String username;
        private final boolean auditor;
        private final boolean localAccount;
        private final List<AdministrativeRoleType> roles;
        private final boolean initialSetupComplete;

        public CurrentSession(String username, boolean auditor, boolean localAccount, List<AdministrativeRoleType> roles) {
            this.username = username;
            this.auditor = auditor;
            this.localAccount = localAccount;
            this.roles = roles;
            this.initialSetupComplete = true;
        }

        public CurrentSession(boolean initialSetupComplete) {
            this.username = null;
            this.auditor = false;
            this.localAccount = false;
            this.roles = null;
            this.initialSetupComplete = initialSetupComplete;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isAuditor() {
            return this.auditor;
        }

        public boolean isLocalAccount() {
            return this.localAccount;
        }

        public List<AdministrativeRoleType> getRoles() {
            return this.roles;
        }

        public boolean isInitialSetupComplete() {
            return this.initialSetupComplete;
        }

        private static class IncompleteSetupBuilder {
            private IncompleteSetupBuilder() {
            }

            public CurrentSession build() {
                return new CurrentSession(false);
            }
        }

        private static class Builder {
            private Builder() {
            }

            public CurrentSession build(Visit pingVisit) {
                AdministrativeUser adminUser = pingVisit.getCurrentUser();
                String username = adminUser.getUserName();
                ArrayList<AdministrativeRoleType> roles = new ArrayList<AdministrativeRoleType>();
                boolean auditor = adminUser.isAuditor();
                boolean localAccount = adminUser.isLocalAccount();
                if (!adminUser.isAuditor()) {
                    if (adminUser.isAdmin()) {
                        roles.add(AdministrativeRoleType.ADMINISTRATOR);
                    }
                    if (adminUser.isAdminManager()) {
                        roles.add(AdministrativeRoleType.USER_ADMINISTRATOR);
                    }
                    if (adminUser.isCryptoManager()) {
                        roles.add(AdministrativeRoleType.CRYPTO_ADMINISTRATOR);
                    }
                    if (adminUser.isExpressionAdmin()) {
                        roles.add(AdministrativeRoleType.EXPRESSION_ADMINISTRATOR);
                    }
                }
                return new CurrentSession(username, auditor, localAccount, roles);
            }
        }
    }
}

