/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.session;

import com.pingidentity.fsm.Visit;
import com.pingidentity.session.LoginTracker;
import com.pingidentity.util.InitialSetupConfigStore;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class SessionValidator {
    private final InitialSetupConfigStore configStore = new InitialSetupConfigStore();

    public boolean checkSessionValidity(IRequestCycle requestCycle, Visit visit) {
        if (visit != null && !this.isStillActive(visit)) {
            visit.logout(requestCycle.getRequestContext().getSession());
            return false;
        }
        return visit != null && visit.isUserAuthenticated() && (!this.isSetupWizardDone() || !visit.getCurrentUser().isTempUser());
    }

    private boolean isStillActive(Visit visit) {
        LoginTracker loginTracker = LoginTracker.getInstance();
        if (visit != null && visit.getCurrentUser() != null) {
            for (AdministrativeUser aUser : loginTracker.getCurrentLoggedInAdmins(null)) {
                if (!aUser.getUserName().equals(visit.getCurrentUser().getUserName())) continue;
                if (visit.isPingOneSso() || visit.getCurrentUser().isTempUser()) {
                    return aUser.isActive();
                }
                return this.isUserStillActive(aUser);
            }
        }
        return true;
    }

    private boolean isUserStillActive(AdministrativeUser user) {
        AdminAuthManager adminAuthManager = AdminAuthManager.getInstance();
        if (adminAuthManager.isNative()) {
            AdministrativeUser actualUser = adminAuthManager.getAdminUserManager().getUser(user.getUserName());
            return actualUser != null && actualUser.isActive();
        }
        return user.isActive();
    }

    public boolean isSetupWizardDone() {
        return this.configStore.isInitialSetupDone();
    }

    public boolean checkNonTempUserSessionValidity(IRequestCycle requestCycle, Visit visit) {
        if (this.checkSessionValidity(requestCycle, visit)) {
            return visit != null && visit.getCurrentUser() != null && !visit.getCurrentUser().isTempUser();
        }
        return false;
    }
}

