/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sso;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.fsm.Visit;
import com.pingidentity.sso.OIDCAuthenticationResult;
import com.pingidentity.util.AdminBaseUrlUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.apache.tapestry.IRequestCycle;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.oauth20.bindings.OAuthClientBinding;
import org.sourceid.oauth20.bindings.PushedAuthorizationRequestBinding;
import org.sourceid.oauth20.client.AuthorizationResponseException;
import org.sourceid.oauth20.validate.admin.auth.OIDCAdminAuthValidator;
import org.sourceid.openid.connect.bindings.OIDCCodeBinding;
import org.sourceid.openid.connect.domain.OIDCConnectionForBinding;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.openid.connect.rp.OIDCAuthenticationResponse;
import org.sourceid.openid.connect.rp.OIDCProtocolAuthProcessor;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.LoggingInterceptor;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.AdminAuthUtil;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.state.State;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class OIDCAdminAuthenticationHandler {
    private static final Log log = LogFactory.getLog(OIDCAdminAuthenticationHandler.class);
    private static final String APPLICATION_JWT = "application/JWT";
    private static final String OIDC_NONCE_BASE_VALUE = "OIDC_NONCE_BASE_VALUE";
    private final AdminUserManager adminUserManager;
    protected static final OIDCAdminAuthValidator validator = new OIDCAdminAuthValidator();
    private final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();

    public OIDCAdminAuthenticationHandler(AdminUserManager adminUserManager) {
        this.adminUserManager = adminUserManager;
    }

    public void sendAuthnRequest(IRequestCycle requestCycle) {
        if (!validator.validateClientSecret()) {
            throw new RuntimeException("Invalid OIDC configuration for PingFederate Administrator console login.");
        }
        HttpServletRequest request = requestCycle.getRequestContext().getRequest();
        HttpServletResponse response = requestCycle.getRequestContext().getResponse();
        OIDCProtocolAuthProcessor protocolProcessor = this.makeProtocolProcessor();
        String ssoRedirectUri = this.makeSsoRedirectUri(request);
        String oidcNonceBaseValue = this.createOidcNonceBaseValue(requestCycle);
        String nonce = this.makeNonce(oidcNonceBaseValue);
        OIDCConnectionForBinding oidcConnectionForBinding = this.getOidcConnectionForBinding(requestCycle, nonce);
        OIDCProviderConnection oidcProviderConnection = oidcConnectionForBinding.getOidcProviderConnection();
        try {
            OutMessageContext outContext = protocolProcessor.makeAuthnRequest(ssoRedirectUri, nonce, nonce, oidcProviderConnection.getRequestParamSettings(), request.getParameterMap());
            State state = new State();
            state.setOutMsgCtx(outContext);
            Visit visit = (Visit)requestCycle.getPage().getVisit();
            if (visit != null) {
                visit.setOidcAuthenticationRequestState(nonce, state);
            }
            if (StringUtils.isNotEmpty((String)oidcProviderConnection.getPushedAuthorizationRequestEndpoint())) {
                PushedAuthorizationRequestBinding pushedAuthorizationRequestBinding = new PushedAuthorizationRequestBinding(oidcProviderConnection.getAuthorizationEndpoint(), oidcConnectionForBinding.getOIDCSettings());
                pushedAuthorizationRequestBinding.transportRequest(request, response, outContext);
            } else {
                LoggingInterceptor binding = new LoggingInterceptor((Binding)new OAuthClientBinding(false));
                binding.transportRequest(request, response, outContext);
            }
        }
        catch (IOException | BindingException | RedirectException | RenderPageException e) {
            throw new RuntimeException("Unexpected error generating OIDC authentication request: " + (Exception)e, e);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public OIDCAuthenticationResult validateAuthnResponse(IRequestCycle requestCycle) {
        try {
            InMessageContext inContext;
            HttpServletRequest request = requestCycle.getRequestContext().getRequest();
            HttpServletResponse response = requestCycle.getRequestContext().getResponse();
            if (request.getParameter("error") != null) {
                throw new AuthorizationResponseException(request.getParameter("error") + ":" + request.getParameter("error_description"));
            }
            OIDCConnectionForBinding oidcConnectionForBinding = this.getOidcConnectionForBinding(requestCycle, request.getParameter("state"));
            LoggingInterceptor binding = new LoggingInterceptor((Binding)new OIDCCodeBinding(oidcConnectionForBinding));
            try {
                inContext = binding.receive(request, response, Role.IDP);
            }
            catch (IOException | BindingException | HttpStatusCodeException | RedirectException | RenderPageException e) {
                throw new AuthorizationResponseException("Unexpected error receiving authentication response: " + (Exception)e, e);
            }
            OIDCProtocolAuthProcessor protocolProcessor = this.makeProtocolProcessor();
            OIDCAuthenticationResponse authResponse = protocolProcessor.validateAuthnResponse(inContext);
            String accessToken = inContext.getParam("access_token");
            AdminAuditLogger.setCurrentAccessTokenHash((String)accessToken);
            try {
                if (authResponse.getClaims().getJwtId() != null) {
                    AdminAuditLogger.setCurrentIdTokenJti((String)authResponse.getClaims().getJwtId());
                }
            }
            catch (MalformedClaimException e) {
                log.error((Object)("Unable to get jti from ID token. Jti will not be included in the security audit log record for this transaction: " + e.getMessage()));
                log.debug((Object)e);
            }
            if (!this.hasAllRequiredAttributes(authResponse.getClaims())) {
                if (StringUtils.isEmpty((String)this.getOIDCProviderConnection().getUserInfoEndpoint())) {
                    throw new AuthorizationResponseException("The User Information Endpoint is required as the ID Token does not have all the required attributes.");
                }
                HttpGet getRequest = new HttpGet(this.getOIDCProviderConnection().getUserInfoEndpoint());
                getRequest.setHeader("Authorization", "Bearer " + accessToken);
                Map userInfoClaims = null;
                try (CloseableHttpResponse userInfoResp = HttpConnectionPoolingManager.getInstance().doRequestWithResponse((HttpRequestBase)getRequest);){
                    String responseContentType = userInfoResp.getEntity().getContentType().getValue();
                    String responseString = EntityUtils.toString((HttpEntity)userInfoResp.getEntity(), (Charset)Consts.UTF_8);
                    if (responseString != null) {
                        if (StringUtils.containsIgnoreCase((String)responseContentType, (String)APPLICATION_JWT)) {
                            JwtClaims jwtClaims;
                            log.debug((Object)("Processing JWT response from UserInfo endpoint: " + this.getOIDCProviderConnection().getUserInfoEndpoint()));
                            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireSubject().setExpectedIssuer(this.getOIDCProviderConnection().getIssuer()).setExpectedAudience(new String[]{this.getOIDCProviderConnection().getClientId()}).setSkipSignatureVerification().build();
                            try {
                                jwtClaims = jwtConsumer.processToClaims(responseString);
                            }
                            catch (InvalidJwtException e) {
                                throw new AuthorizationResponseException("Unexpected error processing UserInfo endpoint JWT response from: " + this.getOIDCProviderConnection().getUserInfoEndpoint() + " " + e, (Throwable)e);
                            }
                            userInfoClaims = jwtClaims.getClaimsMap();
                        } else {
                            try {
                                userInfoClaims = (Map)this.mapper.readValue(responseString, (TypeReference)new TypeReference<Map<String, Object>>(){});
                            }
                            catch (IOException e) {
                                throw new AuthorizationResponseException("Unexpected error processing UserInfo endpoint JSON response from: " + this.getOIDCProviderConnection().getUserInfoEndpoint() + " " + e, (Throwable)e);
                            }
                        }
                    }
                    this.hasRequiredClaim(authResponse, userInfoClaims, this.adminUserManager.getUsernameAttributeName());
                    this.hasRequiredClaim(authResponse, userInfoClaims, this.adminUserManager.getRoleAttributeName());
                    authResponse.setAdditionalUserInfo(userInfoClaims);
                }
                catch (IOException e) {
                    throw new AuthorizationResponseException("Unexpected error receiving UserInfo endpoint response from: " + this.getOIDCProviderConnection().getUserInfoEndpoint() + " " + e, (Throwable)e);
                }
            }
            return new OIDCAuthenticationResult(authResponse);
        }
        catch (AuthorizationResponseException e) {
            return new OIDCAuthenticationResult(e);
        }
    }

    private OIDCConnectionForBinding getOidcConnectionForBinding(IRequestCycle requestCycle, String state) {
        State requestState = null;
        Visit visit = (Visit)requestCycle.getEngine().getVisit();
        if (visit != null && state != null) {
            requestState = visit.getOidcAuthenticationRequestState(state);
        }
        return new OIDCConnectionForBinding(this.getOIDCProviderConnection(), this.makeSsoRedirectUri(null), OIDCProfile.BASIC, requestState);
    }

    private void hasRequiredClaim(OIDCAuthenticationResponse authResponse, Map<String, Object> userInfo, String claimName) throws AuthorizationResponseException {
        if (!authResponse.getClaims().hasClaim(claimName) && !userInfo.containsKey(claimName)) {
            throw new AuthorizationResponseException("Neither the id_token nor the user info endpoint has the required claim: '" + claimName + "'.");
        }
    }

    protected String makeSsoRedirectUri(HttpServletRequest request) {
        return this.getRedirectUri();
    }

    private String getRedirectUri() {
        StringBuilder basePath = AdminBaseUrlUtil.getAdminBaseUrl((String)"/pingfederate/app");
        basePath.append("?service=").append("finishsso");
        return basePath.toString();
    }

    protected OIDCProtocolAuthProcessor makeProtocolProcessor() {
        return new OIDCProtocolAuthProcessor(this.getOIDCProviderConnection());
    }

    String makeNonce(String csrfToken) {
        byte[] bytes = HashUtil.hashToBytes((String)csrfToken, (HashAlgorithm)HashAlgorithm.SHA256);
        return Base64Url.encode((byte[])ArrayUtils.subarray((byte[])bytes, (int)0, (int)16));
    }

    private OIDCProviderConnection getOIDCProviderConnection() {
        return (OIDCProviderConnection)this.adminUserManager.getConnection();
    }

    public AdministrativeUser processAuthenticationResult(OIDCAuthenticationResult result, IRequestCycle cycle) throws AdminUserException {
        if (result.getAuthzResponseException() != null) {
            log.error((Object)"An error occurred during OIDC authentication", (Throwable)result.getAuthzResponseException());
            throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
        }
        OIDCAuthenticationResponse response = result.getAuthnResponse();
        Optional<String> oidcNonceBaseValue = this.getOidcNonceBaseValue(cycle);
        String expectedNonce = oidcNonceBaseValue.map(this::makeNonce).orElse("");
        try {
            if (!expectedNonce.equals(response.getNonce())) {
                log.error((Object)("OIDC authentication response has missing or incorrect nonce: " + response.getNonce()));
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            if (!expectedNonce.equals(response.getState())) {
                log.error((Object)("OIDC authentication response has missing or incorrect state: " + response.getState()));
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            String subject = response.getClaims().getSubject();
            if (subject == null) {
                log.error((Object)"OIDC authentication response does not contain subject");
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
        }
        catch (MalformedClaimException e) {
            log.error((Object)"Malformed claim in OIDC authentication response", (Throwable)e);
            throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
        }
        JwtClaims claims = result.getAuthnResponse().getClaims();
        Map additionalUserInfo = result.getAuthnResponse().getAdditionalUserInfo();
        String username = this.getAttributeValues(this.adminUserManager.getUsernameAttributeName(), claims, additionalUserInfo, true);
        return AdminAuthUtil.createActiveAdminUser((String)username, (Map)claims.getClaimsMap(), (Map)additionalUserInfo, (String)this.adminUserManager.getRoleAttributeName(), (Map)this.adminUserManager.getRoleMap());
    }

    private String getAttributeValues(String attributeName, JwtClaims claims, Map<String, Object> additionalUserInfo, boolean isRequired) throws AdminUserException {
        if (claims.hasClaim(attributeName)) {
            return claims.getClaimValueAsString(attributeName);
        }
        if (additionalUserInfo != null && additionalUserInfo.containsKey(attributeName)) {
            return additionalUserInfo.get(attributeName).toString();
        }
        if (isRequired) {
            throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
        }
        return null;
    }

    private boolean hasAllRequiredAttributes(JwtClaims claims) {
        String usernameAttributeName = this.adminUserManager.getUsernameAttributeName();
        String rolesSearchAttributeName = this.adminUserManager.getRoleAttributeName();
        return claims.hasClaim(usernameAttributeName) && claims.hasClaim(rolesSearchAttributeName);
    }

    String createOidcNonceBaseValue(IRequestCycle cycle) {
        String oidcNonceBaseValue = IDGenerator.rndAlphaNumeric((int)20);
        cycle.getRequestContext().getRequest().getSession(true).setAttribute(OIDC_NONCE_BASE_VALUE, (Object)oidcNonceBaseValue);
        return oidcNonceBaseValue;
    }

    Optional<String> getOidcNonceBaseValue(IRequestCycle cycle) {
        String oidcNonceBaseValue = (String)cycle.getRequestContext().getRequest().getSession().getAttribute(OIDC_NONCE_BASE_VALUE);
        if (StringUtils.isEmpty((String)oidcNonceBaseValue)) {
            return Optional.empty();
        }
        cycle.getRequestContext().getRequest().getSession().removeAttribute(OIDC_NONCE_BASE_VALUE);
        return Optional.of(oidcNonceBaseValue);
    }
}

