/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sso;

import com.pingidentity.pingone.AdminUserRoleMapping;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.pingone.PingOneAdminServiceSettings;
import com.pingidentity.sso.FinishSsoService;
import com.pingidentity.sso.OIDCAdminAuthenticationHandler;
import com.pingidentity.sso.OIDCAuthenticationResult;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.jose4j.jwt.MalformedClaimException;
import org.sourceid.oauth20.bindings.OAuthClientBinding;
import org.sourceid.oauth20.client.AuthorizationResponseException;
import org.sourceid.openid.connect.rp.OIDCAuthenticationResponse;
import org.sourceid.openid.connect.rp.OIDCProtocolAuthProcessor;
import org.sourceid.openid.connect.rp.PingOneOIDCProtocolProcessor;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.LoggingInterceptor;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PingOneSsoHelper
extends OIDCAdminAuthenticationHandler {
    private static final String USER_ROLES_CLAIM = "user_roles";
    private static final String CUSTOMER_UUID_CLAIM = "customer_uuid";
    private static final Log log = LogFactory.getLog(PingOneSsoHelper.class);
    private final PingOneAdminService adminService;

    public PingOneSsoHelper() {
        this(MgmtFactory.getAdminUserManager(), MgmtFactory.getPingOneAdminService());
    }

    public PingOneSsoHelper(AdminUserManager adminUserManager, PingOneAdminService adminService) {
        super(adminUserManager);
        this.adminService = adminService;
    }

    public boolean isSsoEnabled() {
        return this.adminService.isAssociated() && this.adminService.getSettings().isEnableAdminConsoleSso();
    }

    public boolean checkCanInitiateSso(IRequestCycle requestCycle) {
        HttpServletRequest request = requestCycle.getRequestContext().getRequest();
        PingOneAdminServiceSettings settings = this.adminService.getSettings();
        if (!settings.isValidateSsoRedirectUri()) {
            return true;
        }
        try {
            String requestHostname = new URI(request.getRequestURL().toString()).getHost();
            validator.validateURI(request, settings.getAdminConsoleHostname(), "SSO ERROR: request hostname " + requestHostname + " not recognized, for SSO to proceed, this hostname must be entered in server/default/data/config-store/admin-console-endpoint-config.xml");
            if (this.adminService.getOIDCProviderConnection().getSigningKeyPair() == null) {
                log.error((Object)"SSO ERROR: An invalid KeyPairAlias was specified in server/default/data/config-store/p1-admin-service-state.xml");
                return false;
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failed to obtain hostname from request, invalid URI: " + request.getRequestURL()));
            return false;
        }
        return true;
    }

    @Override
    public void sendAuthnRequest(IRequestCycle requestCycle) {
        HttpServletRequest request = requestCycle.getRequestContext().getRequest();
        HttpServletResponse response = requestCycle.getRequestContext().getResponse();
        OIDCProtocolAuthProcessor protocolProcessor = this.makeProtocolProcessor();
        String ssoRedirectUri = this.makeSsoRedirectUri(request);
        String oidcNonceBaseValue = this.createOidcNonceBaseValue(requestCycle);
        String nonce = this.makeNonce(oidcNonceBaseValue);
        OutMessageContext outContext = protocolProcessor.makeAuthnRequest(ssoRedirectUri, nonce, nonce);
        LoggingInterceptor binding = new LoggingInterceptor((Binding)new OAuthClientBinding());
        try {
            binding.transportRequest(request, response, outContext);
        }
        catch (IOException | BindingException | RedirectException | RenderPageException e) {
            throw new RuntimeException("Unexpected error generating OIDC authentication request: " + (Exception)e, e);
        }
    }

    @Override
    public OIDCAuthenticationResult validateAuthnResponse(IRequestCycle requestCycle) {
        try {
            HttpServletRequest request = requestCycle.getRequestContext().getRequest();
            HttpServletResponse response = requestCycle.getRequestContext().getResponse();
            LoggingInterceptor binding = new LoggingInterceptor((Binding)new OAuthClientBinding());
            InMessageContext inContext = null;
            try {
                inContext = binding.receive(request, response, Role.IDP);
            }
            catch (IOException | BindingException | HttpStatusCodeException | RedirectException | RenderPageException e) {
                throw new AuthorizationResponseException("Unexpected error receiving authentication response: " + (Exception)e, e);
            }
            OIDCProtocolAuthProcessor protocolProcessor = this.makeProtocolProcessor();
            return new OIDCAuthenticationResult(protocolProcessor.validateAuthnResponse(inContext));
        }
        catch (AuthorizationResponseException e) {
            return new OIDCAuthenticationResult(e);
        }
    }

    @Override
    public AdministrativeUser processAuthenticationResult(OIDCAuthenticationResult result, IRequestCycle cycle) throws AdminUserException {
        if (result.getAuthzResponseException() != null) {
            log.error((Object)"An error occurred during OIDC authentication", (Throwable)result.getAuthzResponseException());
            throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
        }
        OIDCAuthenticationResponse response = result.getAuthnResponse();
        Optional<String> oidcNonceBaseValue = this.getOidcNonceBaseValue(cycle);
        String expectedNonce = oidcNonceBaseValue.map(this::makeNonce).orElse("");
        String subject = null;
        List<String> userRoles = null;
        try {
            if (!expectedNonce.equals(response.getNonce())) {
                log.error((Object)("OIDC authentication response has missing or incorrect nonce: " + response.getNonce()));
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            if (!expectedNonce.equals(response.getState())) {
                log.error((Object)("OIDC authentication response has missing or incorrect state: " + response.getState()));
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            String customerUuid = response.getClaims().getStringClaimValue(CUSTOMER_UUID_CLAIM);
            if (customerUuid == null) {
                log.error((Object)"OIDC authentication response does not contain customer_uuid claim");
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            if (!customerUuid.equals(this.adminService.getMetadata().getPingOneAccountId())) {
                log.error((Object)("OIDC authentication response has incorrect customer_uuid: " + customerUuid));
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            subject = response.getClaims().getSubject();
            if (subject == null) {
                log.error((Object)"OIDC authentication response does not contain subject");
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
            if (response.getClaims().isClaimValueString(USER_ROLES_CLAIM)) {
                userRoles = Arrays.asList(response.getClaims().getStringClaimValue(USER_ROLES_CLAIM));
            } else if (response.getClaims().isClaimValueStringList(USER_ROLES_CLAIM)) {
                userRoles = response.getClaims().getStringListClaimValue(USER_ROLES_CLAIM);
            }
            if (userRoles == null) {
                log.error((Object)"OIDC authentication response does not contain claim user_roles");
                throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
            }
        }
        catch (MalformedClaimException e) {
            log.error((Object)"Malformed claim in OIDC authentication response", (Throwable)e);
            throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
        }
        AdministrativeUser user = new AdministrativeUser();
        user.setUserName(subject);
        user.setEmailAddress(subject);
        user.setActive(true);
        boolean foundRole = false;
        AdminUserRoleMapping mapping = this.adminService.getAdminUserRoleMapping();
        if (mapping.hasAdminRole(userRoles)) {
            foundRole = true;
            user.setAdmin(true);
        }
        if (mapping.hasCryptoManagerRole(userRoles)) {
            foundRole = true;
            user.setCryptoManager(true);
        }
        if (mapping.hasUserManagerRole(userRoles)) {
            foundRole = true;
            user.setAdminManager(true);
        }
        if (mapping.hasAuditorRole(userRoles)) {
            foundRole = true;
            user.setAuditor(true);
        }
        if (mapping.hasExpressionRole(userRoles)) {
            foundRole = true;
            user.setExpressionAdmin(true);
        }
        if (!foundRole) {
            log.error((Object)("No local roles found for partner roles " + userRoles));
            throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
        }
        return user;
    }

    @Override
    protected String makeSsoRedirectUri(HttpServletRequest request) {
        PingOneAdminServiceSettings settings = this.adminService.getSettings();
        if (settings.isValidateSsoRedirectUri()) {
            return FinishSsoService.getEndpoint();
        }
        return FinishSsoService.getEndpoint(request);
    }

    @Override
    protected OIDCProtocolAuthProcessor makeProtocolProcessor() {
        return new PingOneOIDCProtocolProcessor(this.adminService.getOIDCProviderConnection());
    }
}

