/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.templates.connection;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.apache.xmlbeans.XmlException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.api.ConnectionDeserializer;

public class ConnectionTemplateUtil {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SysDirInfo sysDirInfo = (SysDirInfo)GlobalRegistry.getService(SysDirInfo.class);
    private static final String SALESFORCE_IDP_CONNECTION = "salesforce-idp-connection.xml";

    public void loadSalesforceIdpConnection(String spEntityId, List<String> spVirtualEntityIds, String spConnectionName, Visit visit, IRequestCycle cycle) {
        File salesforceIdpXML = new File(this.sysDirInfo.getConnectionTemplateDirectory(), SALESFORCE_IDP_CONNECTION);
        try {
            FileInputStream salesforceInputStream = new FileInputStream(salesforceIdpXML);
            ConnectionDeserializer deserializer = new ConnectionDeserializer((InputStream)salesforceInputStream);
            List problems = deserializer.getProblems();
            if (problems.isEmpty()) {
                IdpConnection salesforceIdp = (IdpConnection)deserializer.getConnection();
                if (spVirtualEntityIds.isEmpty()) {
                    salesforceIdp.setEntityId(spEntityId);
                } else {
                    salesforceIdp.setEntityId(spVirtualEntityIds.get(0));
                    List virtualIdentities = salesforceIdp.getVirtualIdentities();
                    for (String virtualEntityId : spVirtualEntityIds) {
                        VirtualIdentity virtualIdentity = new VirtualIdentity();
                        virtualIdentity.setVirtualEntityId(virtualEntityId, DomainMode.CONFIGTIME);
                        virtualIdentities.add(virtualIdentity);
                    }
                }
                salesforceIdp.setName(spConnectionName);
                LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
                String serverBaserUrl = localSettings.getBaseUrl();
                URL connectionBaseUrl = new URL(serverBaserUrl);
                salesforceIdp.setBaseUrl(connectionBaseUrl);
                ContactInfo contactInfo = new ContactInfo();
                contactInfo.setCompany(spConnectionName);
                salesforceIdp.setContactInfo(contactInfo);
                Tasklet tasklet = new Tasklet();
                tasklet.setSystemVisit(visit);
                IdpConnectionConfigTasklet idpTasklet = (IdpConnectionConfigTasklet)tasklet.loadNewTasklet(IdpConnectionConfigTasklet.class);
                idpTasklet.populate(salesforceIdp);
                idpTasklet.markProtocolImgAvailable(true);
                idpTasklet.setSummaryStateClickable(false);
                idpTasklet.setExistingConnection(true);
                idpTasklet.gotoGeneralInfoState(cycle);
                idpTasklet.saveDraft(null);
            } else {
                this.log.error((Object)("Unable to load Salesforce IdP Connection Template: " + problems.toString()));
            }
        }
        catch (InvalidXmlException | FileNotFoundException | MalformedURLException | XmlException e) {
            this.log.error((Object)("Unable to load Salesforce IdP Connection Template: " + e.getMessage()));
        }
    }
}

