/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.pingidentity.util.JsonUtil;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.request.RequestContext;

public final class ScopeSelectionModalUtil {
    private static final Log LOG = LogFactory.getLog(ScopeSelectionModalUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonUtil.buildObjectMapper();

    private ScopeSelectionModalUtil() {
    }

    public static void setScopesForModal(RequestContext requestContext, Consumer<Set<String>> restrictedScopesSetter, Consumer<Set<String>> allowedExclusiveScopesSetter) {
        String scopeType = requestContext.getParameter("scopeType");
        if (scopeType != null) {
            String scopesString = requestContext.getParameter("selectedScopes");
            try {
                Set selectedScopes = (Set)OBJECT_MAPPER.readValue(scopesString, (JavaType)TypeFactory.defaultInstance().constructCollectionType(Set.class, String.class));
                if ("commonScope".equals(scopeType)) {
                    restrictedScopesSetter.accept(selectedScopes);
                } else if ("exclusiveScope".equals(scopeType)) {
                    allowedExclusiveScopesSetter.accept(selectedScopes);
                }
            }
            catch (IOException e) {
                String errorMessage = "Unable to read selected scopes for: " + scopeType;
                LOG.error((Object)errorMessage);
                LOG.debug((Object)errorMessage, (Throwable)e);
            }
        }
    }
}

