/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import java.util.HashMap;
import java.util.Map;
import org.sourceid.wstrust.generator.saml.Saml11TokenGenerator;
import org.sourceid.wstrust.generator.saml.Saml20TokenGenerator;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;
import org.sourceid.wstrust.plugin.process.TokenProcessor;
import org.sourceid.wstrust.processor.oauth.BearerAccessTokenTokenProcessor;
import org.sourceid.wstrust.processor.saml.Saml11TokenProcessor;
import org.sourceid.wstrust.processor.saml.Saml20TokenProcessor;

public class TokenExchangeTokenTypeLookupUtil {
    private Map<String, String> tokenProcessorTypeMap = new HashMap<String, String>();
    private Map<String, String> tokenGeneratorTypeMap = new HashMap<String, String>();

    public TokenExchangeTokenTypeLookupUtil() {
        this.tokenProcessorTypeMap.put(BearerAccessTokenTokenProcessor.class.getCanonicalName(), "urn:ietf:params:oauth:token-type:access_token");
        this.tokenProcessorTypeMap.put(Saml11TokenProcessor.class.getCanonicalName(), "urn:ietf:params:oauth:token-type:saml1");
        this.tokenProcessorTypeMap.put(Saml20TokenProcessor.class.getCanonicalName(), "urn:ietf:params:oauth:token-type:saml2");
        this.tokenProcessorTypeMap.put("org.sourceid.wstrust.processor.jwt.JWTTokenProcessor", "urn:ietf:params:oauth:token-type:jwt");
        this.tokenProcessorTypeMap.put("com.pingidentity.pf.tokenprocessors.jwt.JwtTokenProcessor", "urn:ietf:params:oauth:token-type:jwt");
        this.tokenGeneratorTypeMap.put(Saml11TokenGenerator.class.getCanonicalName(), "urn:ietf:params:oauth:token-type:saml1");
        this.tokenGeneratorTypeMap.put(Saml20TokenGenerator.class.getCanonicalName(), "urn:ietf:params:oauth:token-type:saml2");
    }

    public String getTokenProcessorTokenExchangeTokenType(String id, TokenProcessorManager tokenProcessorMgr) {
        TokenProcessor tokenProcessor = tokenProcessorMgr.getTokenProcessor(id);
        String canonicalName = tokenProcessor.getClass().getCanonicalName();
        return this.tokenProcessorTypeMap.get(canonicalName);
    }

    public String getTokenGeneratorTokenExchangeTokenType(String id, TokenGeneratorManager tokenGeneratorMgr) {
        TokenGenerator tokenGenerator = tokenGeneratorMgr.getTokenGenerator(id);
        String canonicalName = tokenGenerator.getClass().getCanonicalName();
        return this.tokenGeneratorTypeMap.get(canonicalName);
    }
}

