/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.LinkedList;
import java.util.List;

public final class TreeHelper {
    private TreeHelper() {
    }

    public static <T> List<NodeWrapper<T>> treeToList(Tree<T> tree) {
        LinkedList<NodeWrapper<T>> result = new LinkedList<NodeWrapper<T>>();
        Tree.Node rootNode = tree.getRootNode();
        if (rootNode != null) {
            result.add(new NodeWrapper(rootNode, NodeWrapperType.DATA));
            if (rootNode.hasChildren()) {
                result.add(new NodeWrapper(NodeWrapperType.START_INDENT));
                TreeHelper.childrenToList(rootNode, result);
                result.add(new NodeWrapper(NodeWrapperType.END_INDENT));
            }
        }
        return result;
    }

    private static <T> void childrenToList(Tree.Node<T> node, List<NodeWrapper<T>> result) {
        List children = node.getChildren();
        for (Tree.Node child : children) {
            result.add(new NodeWrapper(NodeWrapperType.START_INDENT_CONTENT));
            result.add(new NodeWrapper(child, NodeWrapperType.DATA));
            if (child.hasChildren()) {
                result.add(new NodeWrapper(NodeWrapperType.START_INDENT));
                TreeHelper.childrenToList(child, result);
                result.add(new NodeWrapper(NodeWrapperType.END_INDENT));
            }
            result.add(new NodeWrapper(NodeWrapperType.END_INDENT_CONTENT));
        }
    }

    public static class NodeWrapper<Node> {
        private final NodeWrapperType type;
        private Tree.Node<Node> node;

        NodeWrapper(Tree.Node<Node> node, NodeWrapperType type) {
            this.node = node;
            this.type = type;
        }

        NodeWrapper(NodeWrapperType type) {
            this.type = type;
        }

        public NodeWrapperType getType() {
            return this.type;
        }

        public Tree.Node<Node> getNode() {
            return this.node;
        }

        public boolean isOperational() {
            return this.node == null;
        }
    }

    public static enum NodeWrapperType {
        DATA,
        START_INDENT,
        END_INDENT,
        START_INDENT_CONTENT,
        END_INDENT_CONTENT;

    }
}

