<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE script PUBLIC

    "-//Apache Software Foundation//Tapestry Script Specification 3.0//EN"

    "http://jakarta.apache.org/tapestry/dtd/Script_3_0.dtd">

<script>
  <body>
  <unique>
<![CDATA[
/*********************************
 * Module: action links drop down box
 *********************************
 * Handle drop down box events
 *********************************/

$(document).ready(function() {
    var menuOpen = false;

    // on clicking outside Select Action drop down container
    $(document).on('click', function(e) {
        var $clicked = $(e.target);
        // check to make sure item clicked wasn't .select-action link
        // && check if menu is open
        if ((!$clicked.hasClass('select-action'))
            && (menuOpen === true)) {
                // close currently open menu
                $('.action-links-container').find('.input-menu-dropdown').removeClass('open');
                $('.action-links-container').find('.tooltip-menu').removeClass('show');
                $('#content-container').removeClass('extra-height');
                menuOpen = false;
        }
    });

    // click on arrow next to Select Action
    $('.select-action .select-arrow').on('click',function(e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).parent().trigger('click');
    });
    $('.select-action .hover').on('click',function(e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).parent().trigger('click');
    });

    // on clicking Select Action drop down
    $('.select-action').on('click',function(e) {
        e.preventDefault();

        // don't allow disabled links to be clickable
        if ($(this).parent().find('.tooltip-menu').hasClass('disabled')) {
            return false;
        }
        // close or open this menu if no other menus are open
        if ($(this).parent().hasClass('open') ||
                (menuOpen === false)) {
            $(this).parent().toggleClass('open');
            $(this).parent().find('.tooltip-menu').toggleClass('show');
            menuOpen = !menuOpen;
        }
        // if another menu is open, close that one before opening a new menu
        if (!$(this).parent().hasClass('open') &&
                (menuOpen === true)) {
                // close currently open menu
                $('.action-links-container').find('.input-menu-dropdown').removeClass('open');
                $('.action-links-container').find('.tooltip-menu').removeClass('show');
                // open new menu
                $(this).parent().toggleClass('open');
                $(this).parent().find('.tooltip-menu').toggleClass('show');
        }

        // Add extra padding before the buttons to make sure this popup doesn't get cut off
        if($('.action-links-container').find('.input-menu-dropdown.open').length > 0)
            $('#content-container').addClass('extra-height');
        else
            $('#content-container').removeClass('extra-height');

    });

    // on clicking action item, close menu
    $('.tooltip-menu-option').on('click',function(e) {
        $(this).parent().parent().removeClass('show');
        $(this).parent().parent().parent().removeClass('open');
        menuOpen = false;
        $('#content-container').removeClass('extra-height');
    });
});
]]>
  </unique>
  </body>
  <initialization>
  </initialization>
</script>
