<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE script PUBLIC

    "-//Apache Software Foundation//Tapestry Script Specification 3.0//EN"

    "http://jakarta.apache.org/tapestry/dtd/Script_3_0.dtd">

<script>
  <body>
  <unique>
<![CDATA[
 var UserIdDialog = {
     errors: [],
     showUserId : function(id, nodeId) {
        if(!this.$dialog) {
            this.$dialog = $('#dialogDiv2').dialog({
                               autoOpen: false,
                               modal: true,
                               title: 'Incoming User ID',
                               width: 800,
                               resizable: false,
                               position: { my: 'top', at: 'top+150' }
                           });
        }
        var self = this;
        this.$dialog.load('/render/pages/UserIdsPopup.html', function() {
            self.initListeners();
            self.$dialog.dialog('open');
        });
        this.setSelectedId(id);
        this.setNodeId(nodeId);
     },

      initListeners: function(){
         $('#userIdsCancel').focus();
         $('.ui-button-text:contains(Close)').remove();
         $('#submitUserIds').click($.proxy(UserIdDialog.submitUserIds, UserIdDialog));
         $('#userIdsCancel').click($.proxy(UserIdDialog.closeUserIdsDialog, UserIdDialog));
         $('#userIdTable tbody').on('click', 'input[name=clearRow]', function (e) {
                          e.preventDefault();
                          var rowToDelete = $(this).closest('tr');
                          //reset all values to null
                          var $tds = rowToDelete.find('td');
                          $tds.find('select[name=userInputSourceNameToAdd]').val("");
                          $tds.find('select[name=userInputAttributeContractToAdd]').val(""); //clear input texts
                      });

         var nodeId = UserIdDialog.getNodeId();
         var idsToNames = jQuery.parseJSON($('span#idsToNames').html());

         var jsonString = $('p#attributeContracts').html();
         var attributes = jQuery.parseJSON(jsonString);
         var availableSourceIds = jQuery.parseJSON($('#availableSourceIds').html());
         if(availableSourceIds[UserIdDialog.getNodeId()]) {
            $.each(availableSourceIds[UserIdDialog.getNodeId()], function(key, item){
                if (attributes[item].length > 0)
                {
                    $('select[name=userInputSourceNameToAdd]').append($('<option>', {
                        value: item,
                        text : idsToNames[item].value
                    }));
                }
            });
         }
         $('#userIdTable tbody').on('change', 'select[name=userInputSourceNameToAdd]', function() {
             var selectedVal = $(this).find(':selected').val();
             //populate the 2nd dropdown with its attributes
             var selectedRow = $(this).closest('tr');
             var $tds = selectedRow.find('td');
             var $select = $tds.find('select[name=userInputAttributeContractToAdd]');
             $select.find('option:gt(0)').remove();
             $.each(attributes[selectedVal], function (i, item) {
                 $select.append($('<option>', {
                      value: item,
                      text : item
                  }));
              });
         });

         var nodeIdToTypeStr = $('p#nodeIdToType').html();
         if(nodeIdToTypeStr && nodeIdToTypeStr.trim().length > 0) {
            var nodeIdToTypeMappings = jQuery.parseJSON(nodeIdToTypeStr);
            var authnSourceType = nodeIdToTypeMappings[UserIdDialog.getNodeId()];
            var isAdapterMapping = ("ADAPTER" === authnSourceType);
            var inputUserIdMappingsStr = $('p#inputUserIdMappings').html();
                 if(inputUserIdMappingsStr && inputUserIdMappingsStr.trim().length > 0) {
                     var inputUserIdMappings = jQuery.parseJSON(inputUserIdMappingsStr);
                     var userIdMappings = inputUserIdMappings[UserIdDialog.getNodeId()];
                     if(userIdMappings) {
                         //populate dropdown with attribute contract values
                         UserIdDialog.populateRow(userIdMappings, isAdapterMapping);
                         UserIdDialog.validate();
                     }
                 }
                 else
                 {
                    UserIdDialog.populateUserAuthenticated(isAdapterMapping);
                    UserIdDialog.validate();
                 }
            }
      },
      populateUserAuthenticated: function(isAdapterMapping) {
        var headingRow = $( "#userIdTable thead tr:first" );
        var lastRow = $( "#userIdTable tbody tr:last" );
        if(!isAdapterMapping)
        {
            $("#userIdAuthenticatedMessage").hide();
            //hide the heading and the row for non Adapter Mappings
            lastRow.find("td[name=userAuthenticatedTab]").hide();
            headingRow.find("td[name=userIdAuthenticationHeading]").hide();
        }
      },

      populateRow: function(data, isAdapterMapping) {
         var headingRow = $( "#userIdTable thead tr:first" );
         var lastRow = $( "#userIdTable tbody tr:last" );
         if(!data.sourceId) {
            data.sourceId = "userIdContext";
         }
         lastRow.find("select[name=userInputSourceNameToAdd]").val(UserIdDialog.getAttributeContractMapKey(data.sourceId, data.sourceType));
         //populate 2nd row based on source type
         var jsonString = $('p#attributeContracts').html();
         var attributes = jQuery.parseJSON(jsonString);
         var $select = lastRow.find('select[name=userInputAttributeContractToAdd]');
         $select.find('option:gt(0)').remove();
         $.each(attributes[UserIdDialog.getAttributeContractMapKey(data.sourceId, data.sourceType)], function (i, item) {
             $select.append($('<option>', {
                  value: item,
                  text : item
              }));
         });
         lastRow.find("select[name=userInputAttributeContractToAdd]").val(data.attributeContract);
          if(isAdapterMapping)
          {
             lastRow.find("input[name=isUserAuthenticated]").prop('checked', data.userIdAuthenticated);
          }
          else
          {
            //hide the heading and the row for non Adapter Mappings
            lastRow.find("td[name=userAuthenticatedTab]").hide();
            headingRow.find("td[name=userIdAuthenticationHeading]").hide();
            $("#userIdAuthenticatedMessage").hide();
          }
      },
      reset: function() {
         //reset data
         this.errors = [];
         $("#userIdErrorList").html("");
      },
      setSelectedId: function(id) {
         this.selectedId = id;
      },
      getSelectedId: function() {
         return this.selectedId;
      },
      setNodeId: function(nodeId) {
        this.nodeId = nodeId;
      },
      getNodeId: function() {
        return this.nodeId;
      },
      closeUserIdsDialog: function() {
        this.reset();
        this.$dialog.dialog('close');
      },

      submitUserIds: function() {
          if(this.validate())
          {
              var userContract;
              var form = $( "#wrapperForm" );
              $('#userIdTable tbody').find('tr').each(function (i, el) {
                                             sourceIdStr = $(this).find('select[name=userInputSourceNameToAdd] option:selected').val();
                                             contract = $(this).find('select[name="userInputAttributeContractToAdd"] option:selected' ).val();
                                             var sourceId = "";
                                             var type = "";
                                             if(sourceIdStr) {
                                                 var deliminatorIndex = sourceIdStr.lastIndexOf("|");
                                                 sourceId = sourceIdStr.substring(0, deliminatorIndex);
                                                 type = sourceIdStr.substring(deliminatorIndex + 1);
                                             }
                                             var isAuthenticated = $('#isUserAuthenticated').is(':checked');
                                             userContract = new AttributeContractHolder(type, sourceId, contract, isAuthenticated);
                                         });
              var input = $("<input>")
                                .attr("type", "hidden")
                                .attr("name", "submittedContracts").val(JSON.stringify(userContract));
              var inputId = $("<input>")
                                .attr("type", "hidden")
                                .attr("name", "submittedRowId").val(UserIdDialog.getNodeId());
              form.append($(input));
              form.append($(inputId));
              form.submit();
          }
       },

      validate: function() {
         this.reset();
         var valid = true;
        $('#userIdTable tbody').find('tr').each(function (i, el) {
             userInputSourceNameToAdd = $(this).find('select[name=userInputSourceNameToAdd] option:selected').val();
             userInputAttributeContractToAdd = $(this).find('select[name="userInputAttributeContractToAdd"] option:selected' ).val();
             if((userInputSourceNameToAdd && !userInputAttributeContractToAdd) || (!userInputSourceNameToAdd && userInputAttributeContractToAdd)) {
                 if(!userInputSourceNameToAdd) {
                   UserIdDialog.addError("Source");
                   valid = false;
                 }
                 if(!userInputAttributeContractToAdd) {
                   UserIdDialog.addError("Attribute Value");
                   $(this).find('select[name="userInputAttributeContractToAdd"] option')[0].selected = true;
                   valid = false;
                 }
             }
          });
          return valid;
       },
       addError: function(name) {
         if($.inArray(name, this.errors) === -1)
         {
             this.errors.push(name);
             $("#userIdErrorList").append("<li>" + name + " is required</li>");
         }
       },
       getAttributeContractMapKey: function (sourceId, sourceType) {
         return sourceId + "|" + sourceType;
       }
     }
    function AttributeContractHolder(t, sourceIdStr, contract, isAuthenticated) {
        this.sourceType = t;
        this.sourceId = sourceIdStr;
        this.attributeContract = contract;
        this.userIdAuthenticated = isAuthenticated;
     }
]]>
  </unique>
  </body>
  <initialization>
  </initialization>
</script>

