/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class PFRequestLogWriterProxy
extends AbstractLifeCycle
implements RequestLog.Writer {
    private RequestLog.Writer requestLogWriter;
    private String filename;
    private boolean append;
    private int retainDays;
    private String timeZone;
    private String filenameDateFormat;
    private String loggerName;
    private boolean useLog4j2Logger = false;

    public void doStart() throws Exception {
        if (this.useLog4j2Logger) {
            Slf4jRequestLogWriter slf4jWriter = new Slf4jRequestLogWriter();
            slf4jWriter.setLoggerName(this.loggerName);
            slf4jWriter.start();
            this.requestLogWriter = slf4jWriter;
        } else {
            RequestLogWriter legacyWriter = new RequestLogWriter();
            legacyWriter.setFilename(this.filename);
            legacyWriter.setAppend(this.append);
            legacyWriter.setRetainDays(this.retainDays);
            legacyWriter.setTimeZone(this.timeZone);
            legacyWriter.setFilenameDateFormat(this.filenameDateFormat);
            legacyWriter.start();
            this.requestLogWriter = legacyWriter;
        }
    }

    public void write(String requestEntry) throws IOException {
        this.requestLogWriter.write(requestEntry);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setRetainDays(int retainDays) {
        this.retainDays = retainDays;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setFilenameDateFormat(String filenameDateFormat) {
        this.filenameDateFormat = filenameDateFormat;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void setUseLog4j2Logger(boolean useLog4j2Logger) {
        this.useLog4j2Logger = useLog4j2Logger;
    }
}

