/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty;

import com.pingidentity.appserver.jetty.ProxyAuthenticator;
import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.access.ExecutionContext;
import com.pingidentity.common.util.access.ExecutionContextManager;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.CertPathValidatorProvider;
import com.pingidentity.crypto.JCEManagerBase;
import com.pingidentity.crypto.PFSSLContextProvider;
import com.pingidentity.crypto.PFTrustManagerFactoryProvider;
import com.pingidentity.crypto.PasswordFile;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.hsm.HSMStarter;
import com.pingidentity.jdbc.WarningsForHsqlDb;
import com.pingidentity.jetty.JettyXMLConfigRegistry;
import com.pingidentity.pingcommons.log.LoggerPrintStream;
import com.pingidentity.util.LegacyDecryptionUtil;
import java.io.File;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.mgmt.DataUpgradeManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProvider;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.adminstate.AdminNodeRole;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.SystemUtil;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class PingFederateInit {
    private static final Log log = LogFactory.getLog(PingFederateInit.class);
    private static final String PF_AUTHENTICATION_ADMIN_API_PROPERTY = "pf.admin.api.authentication";
    private static final String DATA_UPGRADE_FAIL_ERROR = "Data upgrade on startup failed. Please check the logs for more information. Exiting.";
    private static final String TLS_V_1_2 = "TLSv1.2";
    private static final String TLS_V_1_3 = "TLSv1.3";
    private static boolean tls13Disabled = false;

    public static void main(String[] args) throws Exception {
        ConsoleUtils.disableWarning();
        MgmtFactory.getLogSettingsManager().applyCategorySettings();
        ExecutionContextManager.setCurrentExecutionContext((ExecutionContext)ExecutionContext.STARTUP);
        PrintWriter printWriter = SystemUtil.getPrintWriterInstance();
        Logger systemOutLog = LoggerFactory.getLogger((String)"SystemOut");
        Logger systemErrLog = LoggerFactory.getLogger((String)"SystemErr");
        LoggerPrintStream.setSystemOutToLogger((Logger)systemOutLog);
        LoggerPrintStream.setSystemErrToLogger((Logger)systemErrLog);
        long before = System.currentTimeMillis();
        Security.setProperty("keystore.type", "jks");
        String jettyHome = System.getProperty("jetty.home");
        boolean workingDirExists = false;
        if (jettyHome != null) {
            File homeDir = new File(jettyHome);
            File workDir = new File(jettyHome = homeDir.getAbsolutePath(), "work");
            workingDirExists = workDir.exists() ? workDir.canRead() && workDir.canWrite() : workDir.mkdir();
        }
        if (!workingDirExists) {
            log.warn((Object)"Unable to create Jetty working directory. Defaulting to Java temp dir");
        }
        new EncryptedPrivateKeyInfo("PBEWithSHA1AndDESede", new byte[]{0});
        PingFederateInit.hsmInitialization();
        PingFederateInit.installCustomSecurityProviders();
        PingFederateInit.httpClientProtocolInitialization();
        PingFederateInit.performDataUpgradeIfNeeded();
        PingFederateInit.generateStartupLogMessages();
        SSLContext tlsContext = SSLContext.getInstance("TLS");
        tlsContext.init(null, new TrustManager[]{PingSslClientTrustManager.getInstance()}, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(tlsContext.getSocketFactory());
        Authenticator.setDefault(new ProxyAuthenticator());
        Map idMap = XmlConfiguration.main((String[])args);
        JettyXMLConfigRegistry.getInstance().register(idMap);
        long after = System.currentTimeMillis();
        long startupTimeInSeconds = (after - before) / 1000L;
        long remainder = (after - before) % 1000L;
        log.info((Object)("PingFederate started in " + startupTimeInSeconds + "s:" + remainder + "ms"));
        printWriter.println("PingFederate running...");
        printWriter.flush();
        System.setProperty("pf.jetty.started", Boolean.TRUE.toString());
    }

    private static void httpClientProtocolInitialization() {
        String jdkTlsClientProtocols = System.getProperty("pf.tls.client.protocols");
        if (jdkTlsClientProtocols != null) {
            String[] jdkTlsClientProtocolArray = (String[])Stream.of(jdkTlsClientProtocols.split(",")).map(String::trim).toArray(String[]::new);
            if (Arrays.asList(jdkTlsClientProtocolArray).contains(TLS_V_1_3) && tls13Disabled) {
                String message = "PingFederate cannot make use of TLSv1.3 protocol since it is not supported in the current HSM mode. Removing TLSv1.3 from the 'jdk.tls.client.protocols' list.";
                log.debug((Object)message);
                jdkTlsClientProtocols = Stream.of(jdkTlsClientProtocolArray).filter(s -> !s.equals(TLS_V_1_3)).collect(Collectors.joining(","));
            }
            System.setProperty("jdk.tls.client.protocols", jdkTlsClientProtocols);
        } else if (System.getProperty("jdk.tls.client.protocols") == null) {
            System.setProperty("jdk.tls.client.protocols", TLS_V_1_2);
        }
    }

    private static void installCustomSecurityProviders() {
        if (PropertyInfo.isInstallRevocationCheckerGlobally()) {
            if (PropertyInfo.isBCFIPSMode()) {
                Security.insertProviderAt((Provider)new PFTrustManagerFactoryProvider(), 1);
                Security.insertProviderAt((Provider)new PFSSLContextProvider(), 1);
            } else {
                System.setProperty("com.sun.net.ssl.checkRevocation", "true");
                Security.insertProviderAt((Provider)new CertPathValidatorProvider(), 1);
            }
            System.setProperty("pi.masterKeyEncryptor.checkRevocation", "false");
            System.setProperty("pi.masterKeyEncryptor.useCustomCredentialProvider", "true");
        }
    }

    private static void performDataUpgradeIfNeeded() {
        if (!PropertyInfo.isDataUpgradeOnStartupEnabled()) {
            log.debug((Object)"data upgrade on startup is disabled.");
            return;
        }
        DataUpgradeManager.UpgradeResult upgradeResult = MgmtFactory.getDataUpgradeManager().performUpgrade();
        switch (upgradeResult.getStatus()) {
            case SUCCESS: 
            case SKIPPED: {
                log.info((Object)upgradeResult.getMessage());
                break;
            }
            case FAILURE: {
                log.error((Object)upgradeResult.getMessage());
                SystemUtil.hardShutdown((String)DATA_UPGRADE_FAIL_ERROR);
                break;
            }
            default: {
                log.error((Object)("Data upgrade on startup failed with an unknown status: " + upgradeResult.getStatus()));
                SystemUtil.hardShutdown((String)DATA_UPGRADE_FAIL_ERROR);
            }
        }
    }

    private static void generateStartupLogMessages() {
        String classPath;
        String javaHome;
        String pfHome;
        File curDir = new File(".");
        log.info((Object)("Current Directory: " + curDir.getAbsolutePath()));
        long maxHeapSizeBytes = Runtime.getRuntime().maxMemory();
        double maxHeapSizeGb = (double)maxHeapSizeBytes / 1.073741824E9;
        double requiredHeapSizeGb = 1.0;
        if (maxHeapSizeGb < requiredHeapSizeGb) {
            String message = String.format("The maximum heap size is %.2f GB. The recommended minimum for production deployments is %.2f GB.", maxHeapSizeGb, requiredHeapSizeGb);
            log.warn((Object)message);
        }
        if ((pfHome = System.getProperty("pf.home")) != null) {
            File homeDir = new File(pfHome);
            pfHome = homeDir.getAbsolutePath();
        }
        if ((javaHome = System.getProperty("pf.java")) == null || "".equals(javaHome)) {
            javaHome = System.getProperty("java.home");
        }
        if ((classPath = System.getProperty("pf.classpath")) == null || "".equals(classPath)) {
            classPath = System.getProperty("java.class.path");
        }
        String OS = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String opts = System.getProperty("pf.java.opts");
        if (opts == null) {
            opts = "See sbin/wrapper/PingFederateService.conf";
        }
        String javaVersion = System.getProperty("java.version", "Unknown");
        String javaVmName = StringUtils.defaultIfEmpty((String)System.getProperty("java.vm.name"), (String)"");
        String BORDER = "=========================================================================";
        log.info((Object)BORDER);
        log.info((Object)"");
        log.info((Object)" PingFederate Bootstrap Environment");
        log.info((Object)"");
        log.info((Object)(" PF_HOME: " + pfHome));
        log.info((Object)"");
        log.info((Object)(" JAVA_PATH: " + javaHome));
        log.info((Object)"");
        log.info((Object)(" JAVA_OPTS: " + opts));
        log.info((Object)"");
        log.info((Object)(" CLASSPATH: " + classPath));
        log.info((Object)"");
        log.info((Object)(" Operating System: " + OS));
        log.info((Object)"");
        log.info((Object)String.format(" Java Version: %s (%s)", javaVersion, javaVmName));
        log.info((Object)"");
        log.info((Object)(" PingFederate Version: " + System.getProperty("pingfederate.version")));
        log.info((Object)"");
        log.info((Object)String.format(" JVM Maximum Heap Size: %.2f GB", maxHeapSizeGb));
        log.info((Object)BORDER);
        AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        Mediator mediator = MgmtFactory.getMediator();
        mediator.retrieveClusterState();
        MgmtFactory.getDataSourceManager().initializeJndiLookup();
        MgmtFactory.getIdpAdapterManager().getInstances();
        MgmtFactory.getSpAdapterManager().getInstances();
        MgmtFactory.getTokenProcessorManager().getInstances();
        MgmtFactory.getTokenGeneratorManager().getInstances();
        DeltaReplicationProviderManager replProviderManager = MgmtFactory.getDeltaReplicationProviderManager();
        replProviderManager.registerReplicationProvider((DeltaReplicationProvider)MgmtFactory.getMetadataDirectory());
        if (!MgmtFactory.getClientManager().isBackendDatabase()) {
            replProviderManager.registerReplicationProvider((DeltaReplicationProvider)MgmtFactory.getClientManager());
        }
        if (mediator.isDistributable() && mediator.isEngine() && !mediator.isConsole()) {
            mediator.initEngineNode();
        }
        if (!mediator.isStandalone()) {
            StateMgmtFactory.getDistributedStateCoordinator().initialize();
            NodeIndexRegistry nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();
            if (adminNodeConfigManager.isEnabledAndPassiveNode()) {
                boolean syncSuccess = MgmtFactory.getConfigSynchronizationService().configurationSync();
                if (syncSuccess) {
                    mediator.reloadConfiguration();
                } else {
                    PingFederateInit.checkDefaultSslServerCertOnPassive(MgmtFactory.getSslServerPkCertManager(), nodeIndexRegistry);
                }
            }
        }
        try {
            Collection pcvInstances = null;
            if (mediator.isStandalone() || mediator.isDistributable() && mediator.isEngine()) {
                PasswordCredentialValidatorManager pcvMgr = MgmtFactory.getCredentialValidatorManager();
                pcvInstances = pcvMgr.getInstances();
            }
            AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
            Collection idpAdapterInstances = adapterMgr.getIdpAuthnAdapterInstances();
            Collection spAdapterInstances = adapterMgr.getSpAuthnAdapterInstances();
            TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
            TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
            Collection tokenProcessorInstances = tokenProcessorManager.getInstances();
            Collection tokenGeneratorInstances = tokenGeneratorManager.getInstances();
            String authAdminApiProperty = System.getProperty(PF_AUTHENTICATION_ADMIN_API_PROPERTY);
            log.info((Object)BORDER);
            log.info((Object)"");
            if (authAdminApiProperty != null) {
                log.debug((Object)(" pf.admin.api.authentication=" + authAdminApiProperty));
                log.debug((Object)"");
            }
            log.info((Object)" IdP Adapters");
            log.info((Object)"");
            if (idpAdapterInstances.isEmpty()) {
                log.info((Object)" None Configured");
                log.info((Object)"");
            } else {
                PingFederateInit.logConfigurablePluginDetails(idpAdapterInstances);
            }
            log.info((Object)"");
            log.info((Object)" SP Adapters");
            log.info((Object)"");
            if (spAdapterInstances.isEmpty()) {
                log.info((Object)" None Configured");
                log.info((Object)"");
            } else {
                PingFederateInit.logConfigurablePluginDetails(spAdapterInstances);
            }
            log.info((Object)"");
            log.info((Object)" IdP Token Processors");
            log.info((Object)"");
            if (tokenProcessorInstances.isEmpty()) {
                log.info((Object)" None Configured");
                log.info((Object)"");
            } else {
                PingFederateInit.logConfigurablePluginDetails(tokenProcessorInstances);
            }
            log.info((Object)"");
            log.info((Object)" SP Token Generators");
            log.info((Object)"");
            if (tokenGeneratorInstances.isEmpty()) {
                log.info((Object)" None Configured");
                log.info((Object)"");
            } else {
                PingFederateInit.logConfigurablePluginDetails(tokenGeneratorInstances);
            }
            log.info((Object)"");
            log.info((Object)" PasswordCredentialValidators");
            log.info((Object)"");
            if (pcvInstances == null) {
                log.info((Object)" None Configured");
                log.info((Object)"");
            } else {
                PingFederateInit.logConfigurablePluginDetails(pcvInstances);
            }
            log.info((Object)BORDER);
        }
        catch (Exception ex) {
            log.error((Object)"Exception in generateStartupLogMessages()", (Throwable)ex);
        }
        WarningsForHsqlDb.getInstance().logWarningsForHsqlDbUse();
    }

    private static void checkDefaultSslServerCertOnPassive(SslServerPkCertManager sslServerPkCertManager, NodeIndexRegistry nodeIndexRegistry) {
        if (!sslServerPkCertManager.hasActiveServerPkCert() && PropertyInfo.isHardwareHSM()) {
            List nodes = nodeIndexRegistry.getNodes();
            List otherPassiveNodes = nodes.stream().filter(node -> node.getConsoleRole() == AdminNodeRole.PASSIVE && node.getIndex() != nodeIndexRegistry.getLocalNodeIndex()).collect(Collectors.toList());
            if (otherPassiveNodes.isEmpty()) {
                log.debug((Object)"On the only passive console node in cluster: creating a default server SSL cert");
                JCEManagerBase.generateDefaultSslServerCert((SslServerPkCertManager)sslServerPkCertManager);
            } else {
                log.debug((Object)("On passive console node and skipping auto-create of default server SSL cert, because another passive console exists: " + otherPassiveNodes));
            }
        }
    }

    private static void logConfigurablePluginDetails(Collection<? extends ConfigurablePluginInstance> plugins) {
        for (ConfigurablePluginInstance configurablePluginInstance : plugins) {
            log.info((Object)(" Name: \t" + configurablePluginInstance.getName()));
            log.info((Object)(" Type: \t" + configurablePluginInstance.getDescriptor().getType()));
            log.info((Object)(" Version: \t" + configurablePluginInstance.getDescriptor().getVersion()));
            log.info((Object)"");
        }
    }

    private static void hsmInitialization() throws Exception {
        HSMStarter starter;
        if (!PropertyInfo.isBCFIPSMode()) {
            SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
            File hsmPwdFile = new File(sysDirInfo.getDataDirectory(), "hsmpasswd.txt");
            LegacyDecryptionUtil legacyDecryptionUtil = new LegacyDecryptionUtil();
            PingFederateInit.upgradeEncryptionOfHsmPwdFile(hsmPwdFile, legacyDecryptionUtil);
        }
        if ((starter = HSMStarter.getInstance((PropertyInfo.HSM_MODE)PropertyInfo.getHSMMode(), (Log)log)) != null) {
            starter.testConfiguration();
            starter.start();
            tls13Disabled = starter.isTls13Disabled();
        }
        if (!PropertyInfo.isBCFIPSMode()) {
            System.clearProperty("org.bouncycastle.fips.approved_only");
            CryptoServicesRegistrar.setSecureRandom((SecureRandom)SecurityProviderUtil.getSecureRandom());
        }
    }

    static void upgradeEncryptionOfHsmPwdFile(File hsmPwdFile, LegacyDecryptionUtil legacyDecryptionUtil) {
        if (hsmPwdFile.exists()) {
            try {
                String clearText = PasswordFile.getAndDeobfuscateHSMPassword((File)hsmPwdFile);
                if (clearText != null && log.isDebugEnabled()) {
                    log.debug((Object)("'" + hsmPwdFile.getPath() + "' is already encrypted using JWE, no need to upgrade encryption."));
                }
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not decrypt '" + hsmPwdFile.getPath() + "' using JWE method, trying legacy hard-coded seed-based method."));
                }
                try {
                    String clearText = legacyDecryptionUtil.decryptLegacyHsmPwdFile(hsmPwdFile);
                    PasswordFile.obfuscatePassword((File)hsmPwdFile, (String)"HSM", (String)clearText);
                    log.info((Object)("Updated '" + hsmPwdFile.getPath() + "' to use JWE encryption."));
                }
                catch (Exception ex2) {
                    log.error((Object)("Unable to process '" + hsmPwdFile.getPath() + "' to upgrade its encryption to use JWE. File may be corrupted."), (Throwable)ex2);
                }
            }
        }
    }
}

