/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty;

import com.pingidentity.crypto.Password;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;

public class ProxyAuthenticator
extends Authenticator {
    private static final Log log = LogFactory.getLog(ProxyAuthenticator.class);
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private final ProxyInfo httpProxyInfo = this.proxyInfoFromProperties("http");
    private final ProxyInfo httpsProxyInfo = this.proxyInfoFromProperties("https");

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving proxy credentials: proxy host=" + this.getRequestingHost() + ", port=" + this.getRequestingPort()));
        }
        if (this.getRequestingHost() == null) {
            return null;
        }
        for (ProxyInfo proxyInfo : Arrays.asList(this.httpProxyInfo, this.httpsProxyInfo)) {
            if (!StringUtils.equals((CharSequence)this.getRequestingHost(), (CharSequence)proxyInfo.getHost()) || this.getRequestingPort() != proxyInfo.getPort()) continue;
            if (proxyInfo.getUser() == null || proxyInfo.getPassword() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No credentials defined for proxy host=" + this.getRequestingHost() + ", port=" + this.getRequestingPort()));
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning configured credentials for proxy host=" + this.getRequestingHost() + ", port=" + this.getRequestingPort()));
            }
            if (SecretReferenceUtil.isSecretReference((String)proxyInfo.getPassword())) {
                SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(proxyInfo.getPassword());
                try {
                    SecretReferenceHelper.Credentials credentials = secretReferenceHelper.getSecretInfo(proxyInfo.getUser());
                    return new PasswordAuthentication(credentials.getUsername(), credentials.getSecret().toCharArray());
                }
                catch (SecretManagerException e) {
                    log.error((Object)"Failed to retrieve proxy credentials from secret manager", (Throwable)e);
                    return null;
                }
            }
            return new PasswordAuthentication(proxyInfo.getUser(), proxyInfo.getPassword().toCharArray());
        }
        return null;
    }

    private int getPortPropertyValue(String propertyName) {
        String propertyValue = StringUtils.trimToNull((String)System.getProperty(propertyName));
        if (propertyValue == null) {
            return -1;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid value for " + propertyName + ": " + propertyValue));
            return -1;
        }
    }

    private String getPasswordPropertyValue(String propertyName) {
        String propertyValue = StringUtils.trimToNull((String)System.getProperty(propertyName));
        if (propertyValue == null) {
            return null;
        }
        if (SecretReferenceUtil.isSecretReference((String)propertyValue)) {
            return propertyValue;
        }
        return new Password(propertyValue).getStrValue();
    }

    private ProxyInfo proxyInfoFromProperties(String protocol) {
        String proxyHost = StringUtils.trimToNull((String)System.getProperty(protocol + ".proxyHost"));
        int proxyPort = this.getPortPropertyValue(protocol + ".proxyPort");
        String proxyUser = StringUtils.trimToNull((String)System.getProperty(protocol + ".proxyUser"));
        String proxyPassword = this.getPasswordPropertyValue(protocol + ".proxyPassword");
        return new ProxyInfo(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    private static class ProxyInfo {
        private final String host;
        private final int port;
        private final String user;
        private final String password;

        public ProxyInfo(String host, int port, String user, String password) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

