/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.alpn;

import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;

public class BCALPNClientProcessor
implements ALPNProcessor.Client {
    private static final Log log = LogFactory.getLog(BCALPNClientProcessor.class);

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.bouncycastle.jsse.provider.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        ALPNClientConnection alpn = (ALPNClientConnection)connection;
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        List protocols = alpn.getProtocols();
        sslParameters.setApplicationProtocols(protocols.toArray(new String[0]));
        sslEngine.setSSLParameters(sslParameters);
        ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener((SslHandshakeListener)new ALPNListener(alpn));
    }

    private static final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            try {
                SSLEngine sslEngine = this.alpnConnection.getSSLEngine();
                String protocol = sslEngine.getApplicationProtocol();
                this.alpnConnection.selected(protocol);
            }
            catch (Throwable e) {
                log.warn((Object)("Unable to process BouncyCastle ApplicationProtocol for " + this.alpnConnection));
                this.alpnConnection.selected(null);
            }
        }
    }
}

