/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.alpn;

import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;

public class BCALPNServerProcessor
implements ALPNProcessor.Server {
    private static final Log log = LogFactory.getLog(BCALPNServerProcessor.class);

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.bouncycastle.jsse.provider.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        sslEngine.setHandshakeApplicationProtocolSelector(new ALPNCallback((ALPNServerConnection)connection));
    }

    private static final class ALPNCallback
    implements BiFunction<SSLEngine, List<String>, String>,
    SslHandshakeListener {
        private final ALPNServerConnection alpnConnection;

        private ALPNCallback(ALPNServerConnection connection) {
            this.alpnConnection = connection;
            ((SslConnection.DecryptedEndPoint)this.alpnConnection.getEndPoint()).getSslConnection().addHandshakeListener((SslHandshakeListener)this);
        }

        @Override
        public String apply(SSLEngine engine, List<String> protocols) {
            try {
                this.alpnConnection.select(protocols);
                return this.alpnConnection.getProtocol();
            }
            catch (Throwable x) {
                return null;
            }
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getProtocol();
            if (protocol == null) {
                this.alpnConnection.unsupported();
            }
        }
    }
}

