/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.server.customizer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class ForwardedRequestCustomizer
extends org.eclipse.jetty.server.ForwardedRequestCustomizer {
    private static final Log log = LogFactory.getLog(ForwardedRequestCustomizer.class);
    private static MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public void customize(Connector connector, HttpConfiguration config, Request request) {
        HttpFields httpFields = request.getHttpFields();
        String forwardedHost = this.getFieldValue(httpFields, metadataLocal.getForwardedHostHeaderName(), metadataLocal.getForwardedHostHeaderIndex());
        String forwardedFor = this.getFieldValue(httpFields, metadataLocal.getCustomGlobalHttpHeaderName(), metadataLocal.getClientIpHeaderIndex());
        boolean requestUrlUpdated = false;
        if (forwardedHost != null) {
            HostPortHttpField hostHeader = new HostPortHttpField(forwardedHost);
            HttpFields.Mutable modifiableHttpFields = HttpFields.build((int)(httpFields.size() + 1));
            modifiableHttpFields.add((HttpField)hostHeader);
            modifiableHttpFields.add(request.getHttpFields());
            request.setHttpFields((HttpFields)modifiableHttpFields);
            this.updateAuthority(request, hostHeader);
            requestUrlUpdated = true;
        }
        if (forwardedFor != null) {
            String remoteHost = this.getRemoteHost(forwardedFor);
            request.setRemoteAddr(InetSocketAddress.createUnresolved(remoteHost, request.getRemotePort()));
        }
        if (metadataLocal.isProxyTerminatesHttpsConns()) {
            this.updateSchemeToHttps(request);
            requestUrlUpdated = true;
        }
        if (requestUrlUpdated && log.isDebugEnabled()) {
            log.debug((Object)("Request updated based on incoming proxy settings, new request URL: " + request.getRequestURL()));
        }
    }

    private String getFieldValue(HttpFields fields, String header, LocalSettings.ForwardedHeaderIndex index) {
        if (StringUtils.isBlank((String)header)) {
            return null;
        }
        List values = fields.getCSV(header, false);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (Objects.requireNonNull(index) == LocalSettings.ForwardedHeaderIndex.FIRST) {
            return (String)values.get(0);
        }
        return (String)values.get(values.size() - 1);
    }

    private void updateAuthority(Request request, HostPortHttpField hostHeader) {
        String method = request.getMetaData().getMethod();
        HttpURI.Mutable httpURI = HttpURI.build((HttpURI)request.getMetaData().getURI());
        httpURI.authority(hostHeader.getHost(), hostHeader.getPort());
        HttpVersion httpVersion = request.getHttpVersion();
        HttpFields httpFields = request.getHttpFields();
        long contentLength = request.getMetaData().getContentLength();
        MetaData.Request req = new MetaData.Request(method, (HttpURI)httpURI, httpVersion, httpFields, contentLength);
        request.setMetaData(req);
    }

    private void updateSchemeToHttps(Request request) {
        String method = request.getMetaData().getMethod();
        HttpURI.Mutable httpURI = HttpURI.build((HttpURI)request.getMetaData().getURI());
        httpURI.scheme("https");
        HttpVersion httpVersion = request.getHttpVersion();
        HttpFields httpFields = request.getHttpFields();
        long contentLength = request.getMetaData().getContentLength();
        MetaData.Request req = new MetaData.Request(method, (HttpURI)httpURI, httpVersion, httpFields, contentLength);
        request.setMetaData(req);
    }

    private String getRemoteHost(String forwardedFor) {
        try {
            URI forwardedForUri = new URI("http://" + forwardedFor);
            return forwardedForUri.getHost() != null ? forwardedForUri.getHost() : forwardedFor;
        }
        catch (URISyntaxException e) {
            return forwardedFor;
        }
    }
}

