/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.appserver.jetty.server.customizer;

import com.pingidentity.crypto.X509ClientCertExtractor;
import com.pingidentity.crypto.X509ClientCertExtractorFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class X509CertificateCustomizer
implements HttpConfiguration.Customizer {
    private static final String JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final Log log = LogFactory.getLog(X509CertificateCustomizer.class);
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void customize(Connector connector, HttpConfiguration httpConfiguration, Request request) {
        X509Certificate[] certs;
        X509ClientCertExtractor extractor;
        if (this.metadataLocal.getEnableClientCertAuth().isEmpty()) {
            String clientCertHeader = this.metadataLocal.getClientCertSSLHeaderName();
            String clientCertChainHeader = this.metadataLocal.getClientCertChainSSLHeaderName();
            if (!StringUtils.isNotBlank((String)clientCertHeader) && !StringUtils.isNotBlank((String)clientCertChainHeader)) return;
            extractor = X509ClientCertExtractorFactory.createApacheModSslX509ClientCertExtractor((String)clientCertHeader, (String)clientCertChainHeader);
        } else {
            if (!((Boolean)this.metadataLocal.getEnableClientCertAuth().get()).equals(Boolean.TRUE)) return;
            extractor = X509ClientCertExtractorFactory.newInstance((String)this.metadataLocal.getClientCertEncodingFormat(), (String)this.metadataLocal.getClientCertSSLHeaderName(), (String)this.metadataLocal.getClientCertChainSSLHeaderName());
            if (extractor == null) {
                log.warn((Object)"Client certificate extractor is not created. Please check the configuration.");
                return;
            }
        }
        if ((certs = extractor.extractClientCert((HttpServletRequest)request)) == null) return;
        EndPoint endPoint = request.getHttpChannel().getEndPoint();
        if (endPoint instanceof SslConnection.DecryptedEndPoint) {
            request.setAttributes((Attributes)new PingSslAttributes(request.getAttributes()));
        }
        request.setAttribute(JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE, (Object)certs);
    }

    private static class PingSslAttributes
    implements Attributes {
        private final Attributes attributes;
        private X509Certificate[] certs;

        private PingSslAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        public void removeAttribute(String s) {
            if (X509CertificateCustomizer.JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE.equals(s)) {
                this.certs = null;
            }
            this.attributes.removeAttribute(s);
        }

        public void setAttribute(String s, Object o) {
            if (X509CertificateCustomizer.JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE.equals(s)) {
                this.certs = (X509Certificate[])o;
            } else {
                this.attributes.setAttribute(s, o);
            }
        }

        public Object getAttribute(String s) {
            if (this.certs != null && X509CertificateCustomizer.JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE.equals(s)) {
                return this.certs;
            }
            return this.attributes.getAttribute(s);
        }

        public Set<String> getAttributeNameSet() {
            HashSet<String> attributeNameSet = new HashSet<String>(this.attributes.getAttributeNameSet());
            if (this.certs != null) {
                attributeNameSet.add(X509CertificateCustomizer.JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE);
            }
            return attributeNameSet;
        }

        public void clearAttributes() {
            this.certs = null;
            this.attributes.clearAttributes();
        }
    }
}

