/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.common;

import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.model.DeviceProfile;
import com.pingidentity.sdk.api.authn.model.action.Authenticate;
import com.pingidentity.sdk.api.authn.model.action.AuthenticationSourceSelection;
import com.pingidentity.sdk.api.authn.model.action.CheckAccountRecoveryUsername;
import com.pingidentity.sdk.api.authn.model.action.CheckChallengeResponse;
import com.pingidentity.sdk.api.authn.model.action.CheckCurrentCredentials;
import com.pingidentity.sdk.api.authn.model.action.CheckNewPassword;
import com.pingidentity.sdk.api.authn.model.action.CheckOtp;
import com.pingidentity.sdk.api.authn.model.action.CheckPasswordReset;
import com.pingidentity.sdk.api.authn.model.action.CheckRecoveryCode;
import com.pingidentity.sdk.api.authn.model.action.CheckUsernamePassword;
import com.pingidentity.sdk.api.authn.model.action.CheckUsernameRecoveryEmail;
import com.pingidentity.sdk.api.authn.model.action.ClearIdentifier;
import com.pingidentity.sdk.api.authn.model.action.ConfirmUserCode;
import com.pingidentity.sdk.api.authn.model.action.RegisterUser;
import com.pingidentity.sdk.api.authn.model.action.SelectDevice;
import com.pingidentity.sdk.api.authn.model.action.SubmitDeviceProfile;
import com.pingidentity.sdk.api.authn.model.action.SubmitDeviceProfileSessionId;
import com.pingidentity.sdk.api.authn.model.action.SubmitIdentifier;
import com.pingidentity.sdk.api.authn.model.action.SubmitUserCode;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import java.util.Collections;

public class CommonActionSpec {
    public static final AuthnActionSpec<CheckUsernamePassword> CHECK_USERNAME_PASSWORD = new AuthnActionSpec.Builder().id("checkUsernamePassword").description("Validate the username/password combination.").modelClass(CheckUsernamePassword.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.CREDENTIAL_VALIDATION_FAILED).build();
    public static final AuthnActionSpec<AuthenticationSourceSelection> ALTERNATIVE_AUTHENTICATION = new AuthnActionSpec.Builder().id("useAlternativeAuthenticationSource").description("Authenticate using alternative source.").modelClass(AuthenticationSourceSelection.class).error(CommonErrorSpec.VALIDATION_ERROR).build();
    public static final AuthnActionSpec<CheckChallengeResponse> CHECK_CHALLENGE_RESPONSE = new AuthnActionSpec.Builder().id("checkChallengeResponse").description("Validate the challenge response from user.").modelClass(CheckChallengeResponse.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_CHALLENGE_RESPONSE)).build();
    public static final AuthnActionSpec<Void> CANCEL_AUTHENTICATION = new AuthnActionSpec.Builder().id("cancelAuthentication").description("Cancel the current authentication step.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> CANCEL = new AuthnActionSpec.Builder().id("cancel").description("Cancels the current operation.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> CONTINUE = new AuthnActionSpec.Builder().id("continue").description("Continue the current operation.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> RESTART = new AuthnActionSpec.Builder().id("restart").description("Restart the authentication process.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> INITIATE_PASSWORD_CHANGE = new AuthnActionSpec.Builder().id("initiatePasswordChange").description("Initiate password change process.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> CANCEL_PASSWORD_CHANGE = new AuthnActionSpec.Builder().id("cancelPasswordChange").description("Cancel password change.").modelClass(Void.class).build();
    public static final AuthnActionSpec<CheckNewPassword> CHECK_NEW_PASSWORD = new AuthnActionSpec.Builder().id("checkNewPassword").description("Attempt to change password.").modelClass(CheckNewPassword.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.FIELD_REQUIRED).errorDetail(CommonErrorDetailSpec.PASSWORD_CHANGE_ERROR).build();
    public static final AuthnActionSpec<Void> CONTINUE_AUTHENTICATION = new AuthnActionSpec.Builder().id("continueAuthentication").description("Continue the current authentication flow.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> INITIATE_ACCOUNT_RECOVERY = new AuthnActionSpec.Builder().id("initiateAccountRecovery").description("Initiate account recovery process.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> CANCEL_ACCOUNT_RECOVERY = new AuthnActionSpec.Builder().id("cancelAccountRecovery").description("Cancel account recovery.").modelClass(Void.class).build();
    public static final AuthnActionSpec<CheckAccountRecoveryUsername> CHECK_ACCOUNT_RECOVERY_USERNAME = new AuthnActionSpec.Builder().id("checkAccountRecoveryUsername").description("Submit the username for account recovery.").modelClass(CheckAccountRecoveryUsername.class).error(CommonErrorSpec.VALIDATION_ERROR).build();
    public static final AuthnActionSpec<CheckRecoveryCode> CHECK_RECOVERY_CODE = new AuthnActionSpec.Builder().id("checkRecoveryCode").description("Validate recovery code for account recovery.").modelClass(CheckRecoveryCode.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.ACCOUNT_RECOVERY_ERROR).build();
    public static final AuthnActionSpec<CheckPasswordReset> CHECK_PASSWORD_RESET = new AuthnActionSpec.Builder().id("checkPasswordReset").description("Validate new password for password reset.").modelClass(CheckPasswordReset.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.ACCOUNT_RECOVERY_ERROR).build();
    public static final AuthnActionSpec<Void> CONTINUE_ACCOUNT_RECOVERY = new AuthnActionSpec.Builder().id("continueAccountRecovery").description("Continue to account recovery after account has been unlocked.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> RECOVER_USERNAME = new AuthnActionSpec.Builder().id("recoverUsername").description("Initiate username recovery process.").modelClass(Void.class).build();
    public static final AuthnActionSpec<CheckUsernameRecoveryEmail> CHECK_USERNAME_RECOVERY_EMAIL = new AuthnActionSpec.Builder().id("checkUsernameRecoveryEmail").description("Provide username recovery email.").modelClass(CheckUsernameRecoveryEmail.class).error(CommonErrorSpec.VALIDATION_ERROR).build();
    public static final AuthnActionSpec<Void> CANCEL_USERNAME_RECOVERY = new AuthnActionSpec.Builder().id("cancelUsernameRecovery").description("Cancel username recovery.").modelClass(Void.class).build();
    public static final AuthnActionSpec<SubmitIdentifier> SUBMIT_IDENTIFIER = new AuthnActionSpec.Builder().id("submitIdentifier").description("Submit identifier.").modelClass(SubmitIdentifier.class).error(CommonErrorSpec.VALIDATION_ERROR).build();
    public static final AuthnActionSpec<ClearIdentifier> CLEAR_IDENTIFIER = new AuthnActionSpec.Builder().id("clearIdentifier").description("Clear previously submitted identifier.").modelClass(ClearIdentifier.class).build();
    public static final AuthnActionSpec<Void> CANCEL_IDENTIFIER_SUBMISSION = new AuthnActionSpec.Builder().id("cancelIdentifierSubmission").description("Cancel identifier submission.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> INITIATE_REGISTRATION = new AuthnActionSpec.Builder().id("initiateRegistration").description("Initiate the registration process.").modelClass(Void.class).build();
    public static final AuthnActionSpec<RegisterUser> REGISTER_USER = new AuthnActionSpec.Builder().id("registerUser").description("Register a new local identity user.").modelClass(RegisterUser.class).error(CommonErrorSpec.VALIDATION_ERROR).error(CommonErrorSpec.REGISTRATION_FAILED).errorDetail(CommonErrorDetailSpec.FIELD_REQUIRED).errorDetail(CommonErrorDetailSpec.CAPTCHA_ERROR).errorDetail(CommonErrorDetailSpec.REGISTRATION_FAILED).build();
    public static final AuthnActionSpec<SelectDevice> SELECT_DEVICE = new AuthnActionSpec.Builder().id("selectDevice").description("Select a device to use for multi-factor authentication.").modelClass(SelectDevice.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.INVALID_DEVICE).build();
    public static final AuthnActionSpec<CheckOtp> CHECK_OTP = new AuthnActionSpec.Builder().id("checkOtp").description("Validate the OTP (one-time passcode) from the user.").modelClass(CheckOtp.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.INVALID_OTP).build();
    public static final AuthnActionSpec<Void> RESEND_OTP = new AuthnActionSpec.Builder().id("resendOtp").description("Resend an OTP (one-time passcode) to the user's selected device.").modelClass(Void.class).error(CommonErrorSpec.REQUEST_FAILED).errorDetail(CommonErrorDetailSpec.OTP_RESEND_LIMIT).build();
    public static final AuthnActionSpec<Authenticate> AUTHENTICATE = new AuthnActionSpec.Builder().id("authenticate").description("Start the authentication flow.").modelClass(Authenticate.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.INVALID_MOBILE_PAYLOAD).build();
    public static final AuthnActionSpec<Void> POLL = new AuthnActionSpec.Builder().id("poll").description("Get the current operation's status.").modelClass(Void.class).build();
    public static final AuthnActionSpec<SubmitDeviceProfile<? extends DeviceProfile>> SUBMIT_DEVICE_PROFILE = new AuthnActionSpec.Builder().id("submitDeviceProfile").description("Submit the user's device profile.").modelClass(SubmitDeviceProfile.class).build();
    public static final AuthnActionSpec<CheckCurrentCredentials> CHECK_CURRENT_CREDENTIALS = new AuthnActionSpec.Builder().id("checkCurrentCredentials").description("Validate current credentials when multi-factor authentication is enabled for change password.").modelClass(CheckCurrentCredentials.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.CREDENTIAL_VALIDATION_FAILED).build();
    public static final AuthnActionSpec<SubmitDeviceProfileSessionId> SUBMIT_DEVICE_PROFILE_SESSION_ID = new AuthnActionSpec.Builder().id("submitDeviceProfileSessionId").description("Submit the session identifier created when the device was profiled.").modelClass(SubmitDeviceProfileSessionId.class).build();
    public static final AuthnActionSpec<Void> SEND_EMAIL_VERIFICATION_OTL = new AuthnActionSpec.Builder().id("sendEmailVerificationOtl").description("Send an OTL (one-time link) to the user for email verification.").modelClass(Void.class).build();
    public static final AuthnActionSpec<Void> SKIP_OTP = new AuthnActionSpec.Builder().id("skipOtp").description("Skip an OTP (one-time passcode) verification.").modelClass(Void.class).build();
    public static final AuthnActionSpec<SubmitUserCode> SUBMIT_USER_CODE = new AuthnActionSpec.Builder().id("submitUserCode").description("Submit the user code.").modelClass(SubmitUserCode.class).error(CommonErrorSpec.VALIDATION_ERROR).errorDetail(CommonErrorDetailSpec.INVALID_USER_CODE).error(CommonErrorSpec.REQUEST_FAILED).errorDetail(CommonErrorDetailSpec.USER_CODE_LOCKED).errorDetail(CommonErrorDetailSpec.USER_CODE_EXPIRED).build();
    public static final AuthnActionSpec<ConfirmUserCode> CONFIRM_USER_CODE = new AuthnActionSpec.Builder().id("confirmUserCode").description("Confirm the user code.").modelClass(ConfirmUserCode.class).build();
}

